/*
 * Decompiled with CFR 0.152.
 */
package moriyashiine.lostrelics.common.item;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import dev.emi.trinkets.api.SlotReference;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import moriyashiine.lostrelics.common.component.entity.CursedAmuletComponent;
import moriyashiine.lostrelics.common.init.ModEntityComponents;
import moriyashiine.lostrelics.common.init.ModSoundEvents;
import moriyashiine.lostrelics.common.item.RelicItem;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_5134;
import net.minecraft.class_5536;
import net.minecraft.class_5630;
import org.jetbrains.annotations.Nullable;

public class CursedAmuletItem
extends RelicItem {
    public static final Multimap<class_1320, class_1322> GOOD_MODIFIERS = HashMultimap.create();
    public static final Multimap<class_1320, class_1322> BAD_MODIFIERS;

    public void tick(class_1799 stack, SlotReference slot, class_1309 entity) {
        if (entity.field_6012 % 20 == 0) {
            this.applyModifiers(entity, false);
        }
    }

    public void onEquip(class_1799 stack, SlotReference slot, class_1309 entity) {
        this.applyModifiers(entity, false);
        ModEntityComponents.CURSED_AMULET.maybeGet((Object)entity).ifPresent(cursedAmuletComponent -> cursedAmuletComponent.toggleTransform(!CursedAmuletItem.shouldHideSkeleton(stack)));
    }

    public void onUnequip(class_1799 stack, SlotReference slot, class_1309 entity) {
        this.applyModifiers(entity, true);
        ModEntityComponents.CURSED_AMULET.maybeGet((Object)entity).ifPresent(cursedAmuletComponent -> cursedAmuletComponent.toggleTransform(false));
    }

    public Multimap<class_1320, class_1322> getModifiers(class_1799 stack, SlotReference slot, class_1309 entity, UUID uuid) {
        return GOOD_MODIFIERS;
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        if (user.method_5715()) {
            class_1799 stack = user.method_5998(hand);
            if (!world.field_9236) {
                CursedAmuletItem.toggleSkeleton(stack, hideSkeleton -> user.method_37908().method_8396(null, user.method_24515(), ModSoundEvents.ITEM_RELIC_TOGGLE, user.method_5634(), 1.0f, hideSkeleton != false ? 1.0f : 0.5f));
            }
            return class_1271.method_29237((Object)stack, (boolean)world.field_9236);
        }
        return super.method_7836(world, user, hand);
    }

    public boolean method_31566(class_1799 stack, class_1799 otherStack, class_1735 slot, class_5536 clickType, class_1657 player, class_5630 cursorStackReference) {
        if (clickType == class_5536.field_27014 && cursorStackReference.method_32327().method_7960()) {
            CursedAmuletItem.toggleSkeleton(stack, hideSkeleton -> {
                player.method_5783(ModSoundEvents.ITEM_RELIC_TOGGLE, 1.0f, hideSkeleton != false ? 1.0f : 0.5f);
                ((CursedAmuletComponent)ModEntityComponents.CURSED_AMULET.get((Object)player)).toggleTransform((boolean)hideSkeleton);
            });
            return true;
        }
        return false;
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        tooltip.add((class_2561)class_2561.method_43469((String)"tooltip.lostrelics.hide_skeleton", (Object[])new Object[]{CursedAmuletItem.shouldHideSkeleton(stack)}).method_27692(class_124.field_1063));
    }

    private void applyModifiers(class_1309 entity, boolean remove) {
        if (entity.method_37908().field_9236) {
            return;
        }
        if (remove || !entity.method_37908().method_8530() || !entity.method_37908().method_8311(entity.method_24515())) {
            this.applyNegativeModifiers(entity, true);
        } else {
            this.applyNegativeModifiers(entity, false);
            if (entity.method_6032() > entity.method_6063() && entity.method_33190()) {
                entity.method_6033(entity.method_6063());
            }
        }
    }

    private void applyNegativeModifiers(class_1309 entity, boolean remove) {
        if (remove) {
            BAD_MODIFIERS.forEach((entityAttribute, entityAttributeModifier) -> {
                class_1324 instance = entity.method_5996(entityAttribute);
                if (instance != null && instance.method_6196(entityAttributeModifier)) {
                    instance.method_6202(entityAttributeModifier);
                }
            });
        } else {
            BAD_MODIFIERS.forEach((entityAttribute, entityAttributeModifier) -> {
                class_1324 instance = entity.method_5996(entityAttribute);
                if (instance != null && !instance.method_6196(entityAttributeModifier)) {
                    instance.method_26835(entityAttributeModifier);
                }
            });
        }
    }

    public static boolean shouldHideSkeleton(class_1799 stack) {
        class_2487 compound = stack.method_7941("lostrelics");
        return compound != null && compound.method_10577("HideSkeleton");
    }

    private static void toggleSkeleton(class_1799 stack, Consumer<Boolean> playSound) {
        class_2487 compound;
        boolean active = (compound = stack.method_7911("lostrelics")).method_10577("HideSkeleton");
        compound.method_10556("HideSkeleton", !active);
        playSound.accept(active);
    }

    static {
        GOOD_MODIFIERS.put((Object)class_5134.field_23724, (Object)new class_1322(UUID.fromString("4c9510d8-5d90-4b9f-8ee6-4779f824998a"), "Trinket modifier", 4.0, class_1322.class_1323.field_6328));
        GOOD_MODIFIERS.put((Object)class_5134.field_23721, (Object)new class_1322(UUID.fromString("723e4c9c-37fe-4a22-a60f-704741b29f22"), "Trinket modifier", 3.0, class_1322.class_1323.field_6328));
        BAD_MODIFIERS = HashMultimap.create();
        BAD_MODIFIERS.put((Object)class_5134.field_23724, (Object)new class_1322(UUID.fromString("3637dedf-9d72-40a4-bf2b-3f31356af2d1"), "Trinket modifier", -8.0, class_1322.class_1323.field_6328));
        BAD_MODIFIERS.put((Object)class_5134.field_23721, (Object)new class_1322(UUID.fromString("bda17160-e891-4635-bf1a-bb4d85b2cdaf"), "Trinket modifier", -6.0, class_1322.class_1323.field_6328));
    }
}

