/*
 * Decompiled with CFR 0.152.
 */
package net.archers.item;

import java.util.ArrayList;
import java.util.Map;
import java.util.function.Supplier;
import net.archers.item.Group;
import net.archers.item.weapon.CustomWeaponItem;
import net.fabric_extras.ranged_weapon.api.CustomBow;
import net.fabric_extras.ranged_weapon.api.CustomCrossbow;
import net.fabric_extras.ranged_weapon.api.CustomRangedWeapon;
import net.fabric_extras.ranged_weapon.api.RangedConfig;
import net.fabricmc.fabric.api.item.v1.FabricItemSettings;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1832;
import net.minecraft.class_1834;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import net.spell_engine.api.item.ItemConfig;
import net.spell_engine.api.item.weapon.Weapon;

public class Weapons {
    public static final ArrayList<RangedEntry> rangedEntries = new ArrayList();
    public static final ArrayList<Weapon.Entry> meleeEntries = new ArrayList();
    public static final Weapon.Entry flint_spear = Weapons.spear("flint_spear", Weapon.CustomMaterial.matching((class_1834)class_1834.field_8927, () -> class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8145})), 4.0f);
    public static final Weapon.Entry iron_spear = Weapons.spear("iron_spear", Weapon.CustomMaterial.matching((class_1834)class_1834.field_8923, () -> class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8620})), 5.0f);
    public static final Weapon.Entry golden_spear = Weapons.spear("golden_spear", Weapon.CustomMaterial.matching((class_1834)class_1834.field_8929, () -> class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8695})), 3.0f);
    public static final Weapon.Entry diamond_spear = Weapons.spear("diamond_spear", Weapon.CustomMaterial.matching((class_1834)class_1834.field_8930, () -> class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8477})), 6.0f);
    public static final Weapon.Entry netherite_spear = Weapons.spear("netherite_spear", Weapon.CustomMaterial.matching((class_1834)class_1834.field_22033, () -> class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_22020})), 7.0f);
    private static final int durabilityTier0 = 384;
    private static final int durabilityTier1 = 465;
    private static final int durabilityTier2 = class_1834.field_8930.method_8025();
    private static final int durabilityTier3 = class_1834.field_22033.method_8025();
    private static final int pullTime_shortBow = 16;
    private static final int pullTime_longBow = 30;
    private static final int pullTime_rapidCrossbow = 20;
    private static final int pullTime_heavyCrossbow = 35;
    public static RangedEntry composite_longbow = Weapons.bow("composite_longbow", 465, () -> class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8606}), new RangedConfig(30, 8.0f, 0.0f));
    public static RangedEntry mechanic_shortbow = Weapons.bow("mechanic_shortbow", durabilityTier2, () -> class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8725}), new RangedConfig(16, 8.0f, 0.0f));
    public static RangedEntry royal_longbow = Weapons.bow("royal_longbow", durabilityTier2, () -> class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8695}), new RangedConfig(30, 10.0f, 0.0f));
    public static RangedEntry netherite_shortbow = Weapons.bow("netherite_shortbow", durabilityTier3, () -> class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_22020}), new RangedConfig(16, 9.0f, 0.0f));
    public static RangedEntry netherite_longbow = Weapons.bow("netherite_longbow", durabilityTier3, () -> class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_22020}), new RangedConfig(30, 12.0f, 0.0f));
    public static RangedEntry rapid_crossbow = Weapons.crossbow("rapid_crossbow", durabilityTier2, () -> class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8725}), new RangedConfig(20, 8.5f, 0.0f));
    public static RangedEntry heavy_crossbow = Weapons.crossbow("heavy_crossbow", durabilityTier2, () -> class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8477}), new RangedConfig(35, 13.0f, 0.0f));
    public static RangedEntry netherite_rapid_crossbow = Weapons.crossbow("netherite_rapid_crossbow", durabilityTier3, () -> class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_22020}), new RangedConfig(20, 9.5f, 0.0f));
    public static RangedEntry netherite_heavy_crossbow = Weapons.crossbow("netherite_heavy_crossbow", durabilityTier3, () -> class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_22020}), new RangedConfig(35, 15.0f, 0.0f));

    private static Supplier<class_1856> ingredient(String idString) {
        return Weapons.ingredient(idString, class_1802.field_8477);
    }

    private static Supplier<class_1856> ingredient(String idString, class_1792 fallback) {
        class_2960 id = new class_2960(idString);
        return () -> {
            class_1792 item = (class_1792)class_7923.field_41178.method_10223(id);
            class_1792 ingredient = item != null ? item : fallback;
            return class_1856.method_8091((class_1935[])new class_1935[]{ingredient});
        };
    }

    private static Weapon.Entry addMelee(String requiredMod, String name, Weapon.CustomMaterial material, class_1792 item, ItemConfig.Weapon defaults) {
        Weapon.Entry entry = new Weapon.Entry("archers", name, material, item, defaults, null);
        if (entry.isRequiredModInstalled()) {
            meleeEntries.add(entry);
        }
        return entry;
    }

    private static Weapon.Entry spear(String name, Weapon.CustomMaterial material, float damage) {
        return Weapons.spear(null, name, material, damage);
    }

    private static Weapon.Entry spear(String requiredMod, String name, Weapon.CustomMaterial material, float damage) {
        class_1792.class_1793 settings = new class_1792.class_1793();
        CustomWeaponItem item = new CustomWeaponItem((class_1832)material, settings);
        return Weapons.addMelee(requiredMod, name, material, (class_1792)item, new ItemConfig.Weapon(damage, -3.0f));
    }

    private static RangedEntry addRanged(class_2960 id, class_1792 item, RangedConfig defaults) {
        RangedEntry entry = new RangedEntry(id, item, defaults);
        rangedEntries.add(entry);
        return entry;
    }

    private static RangedEntry bow(String name, int durability, Supplier<class_1856> repairIngredientSupplier, RangedConfig defaults) {
        FabricItemSettings settings = new FabricItemSettings().maxDamage(durability);
        CustomBow item = new CustomBow((class_1792.class_1793)settings, repairIngredientSupplier);
        ((CustomRangedWeapon)item).configure(defaults);
        return Weapons.addRanged(new class_2960("archers", name), (class_1792)item, defaults);
    }

    private static RangedEntry crossbow(String name, int durability, Supplier<class_1856> repairIngredientSupplier, RangedConfig defaults) {
        FabricItemSettings settings = new FabricItemSettings().maxDamage(durability);
        CustomCrossbow item = new CustomCrossbow((class_1792.class_1793)settings, repairIngredientSupplier);
        ((CustomRangedWeapon)item).configure(defaults);
        return Weapons.addRanged(new class_2960("archers", name), (class_1792)item, defaults);
    }

    public static void register(Map<String, RangedConfig> rangedConfig, Map<String, ItemConfig.Weapon> meleeConfig) {
        if (FabricLoader.getInstance().isModLoaded("betterend")) {
            Weapons.spear("aeternium_spear", Weapon.CustomMaterial.matching((class_1834)class_1834.field_22033, Weapons.ingredient("betterend:aeternium_ingot")), 8.0f);
            Weapons.bow("crystal_shortbow", durabilityTier3, Weapons.ingredient("betterend:crystal_shards"), new RangedConfig(16, 10.0f, 0.0f));
            Weapons.bow("crystal_longbow", durabilityTier3, Weapons.ingredient("betterend:crystal_shards"), new RangedConfig(30, 13.5f, 0.0f));
        }
        if (FabricLoader.getInstance().isModLoaded("betternether")) {
            Weapons.crossbow("ruby_rapid_crossbow", durabilityTier3, Weapons.ingredient("betternether:nether_ruby"), new RangedConfig(20, 10.5f, 0.0f));
            Weapons.crossbow("ruby_heavy_crossbow", durabilityTier3, Weapons.ingredient("betternether:nether_ruby"), new RangedConfig(35, 17.0f, 0.0f));
        }
        Weapon.register(meleeConfig, meleeEntries, Group.KEY);
        for (RangedEntry entry : rangedEntries) {
            RangedConfig config = rangedConfig.get(entry.id.toString());
            if (config == null) {
                config = entry.defaults;
                rangedConfig.put(entry.id.toString(), config);
            }
            ((CustomRangedWeapon)entry.item).configure(config);
            class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)entry.id, (Object)entry.item);
        }
        ItemGroupEvents.modifyEntriesEvent(Group.KEY).register(content -> {
            for (RangedEntry entry : rangedEntries) {
                content.method_45421((class_1935)entry.item);
            }
        });
    }

    public record RangedEntry(class_2960 id, class_1792 item, RangedConfig defaults) {
    }
}

