/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.tramplenomore;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.Expose;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import net.darkhax.tramplenomore.Constants;

public class Config {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().excludeFieldsWithoutExposeAnnotation().create();
    @Expose
    public boolean featherFalling = true;
    @Expose
    public boolean taggedItems = true;
    @Expose
    public boolean taggedEntities = true;
    @Expose
    public boolean creativeMode = true;
    @Expose
    public boolean barefoot = false;

    public static Config load(File configFile) {
        Config config = new Config();
        if (configFile.exists()) {
            try (FileReader reader = new FileReader(configFile);){
                config = (Config)GSON.fromJson((Reader)reader, Config.class);
                Constants.LOG.info("Loaded config file.");
            }
            catch (Exception e) {
                Constants.LOG.error("Could not read config file {}. Defaults will be used.", (Object)configFile.getAbsolutePath(), (Object)e);
            }
        } else {
            Constants.LOG.info("Creating a new config file at {}.", (Object)configFile.getAbsolutePath());
            configFile.getParentFile().mkdirs();
        }
        try (FileWriter writer = new FileWriter(configFile);){
            GSON.toJson((Object)config, (Appendable)writer);
            Constants.LOG.info("Saved config file.");
        }
        catch (Exception e) {
            Constants.LOG.error("Could not write config file '{}'!", (Object)configFile.getAbsolutePath(), (Object)e);
        }
        return config;
    }
}

