/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util.cycle;

import de.keksuccino.fancymenu.util.ConsumingSupplier;
import de.keksuccino.fancymenu.util.cycle.ILocalizedValueCycle;
import de.keksuccino.fancymenu.util.cycle.ValueCycle;
import de.keksuccino.fancymenu.util.enums.LocalizedEnum;
import java.security.InvalidParameterException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

public class LocalizedEnumValueCycle<E extends LocalizedEnum<?>>
extends ValueCycle<E>
implements ILocalizedValueCycle<E> {
    protected String cycleLocalizationKey;
    protected ConsumingSupplier<E, class_2583> cycleStyle = consumes -> class_2583.field_24360;

    @SafeVarargs
    public static <E extends LocalizedEnum<?>> LocalizedEnumValueCycle<E> ofArray(@NotNull String cycleLocalizationKey, E ... values) {
        Objects.requireNonNull(values);
        List<E> valueList = Arrays.asList(values);
        if (valueList.size() < 2) {
            throw new InvalidParameterException("Failed to create LocalizedValueCycle! Value list size too small (<2)!");
        }
        LocalizedEnumValueCycle<E> valueCycle = new LocalizedEnumValueCycle<E>(cycleLocalizationKey);
        valueCycle.values.addAll(valueList);
        return valueCycle;
    }

    public static <E extends LocalizedEnum<?>> LocalizedEnumValueCycle<E> ofList(@NotNull String cycleLocalizationKey, @NotNull List<E> values) {
        return LocalizedEnumValueCycle.ofArray((String)cycleLocalizationKey, (LocalizedEnum[])((LocalizedEnum[])values.toArray(new Object[0])));
    }

    protected LocalizedEnumValueCycle(String cycleLocalizationKey) {
        this.cycleLocalizationKey = cycleLocalizationKey;
    }

    @Override
    @NotNull
    public String getCycleLocalizationKey() {
        return this.cycleLocalizationKey;
    }

    @Override
    public class_5250 getCycleComponent() {
        return class_2561.method_43469((String)this.getCycleLocalizationKey(), (Object[])new Object[]{this.getCurrentValueComponent()}).method_27696(this.cycleStyle.get((LocalizedEnum)this.current()));
    }

    @Override
    public class_5250 getCurrentValueComponent() {
        return ((LocalizedEnum)this.current()).getValueComponent();
    }

    @Override
    public LocalizedEnumValueCycle<E> setCycleComponentStyleSupplier(@NotNull ConsumingSupplier<E, class_2583> supplier) {
        this.cycleStyle = supplier;
        return this;
    }

    @Override
    public LocalizedEnumValueCycle<E> addCycleListener(@NotNull Consumer<E> listener) {
        return (LocalizedEnumValueCycle)super.addCycleListener((Consumer)listener);
    }
}

