/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.element.elements.text.v2;

import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.element.ElementBuilder;
import de.keksuccino.fancymenu.util.ListUtils;
import de.keksuccino.fancymenu.util.enums.LocalizedCycleEnum;
import de.keksuccino.fancymenu.util.rendering.DrawableColor;
import de.keksuccino.fancymenu.util.rendering.RenderingUtils;
import de.keksuccino.fancymenu.util.rendering.text.markdown.MarkdownRenderer;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v2.scrollarea.ScrollArea;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v2.scrollarea.entry.ScrollAreaEntry;
import de.keksuccino.fancymenu.util.resource.ResourceSupplier;
import de.keksuccino.fancymenu.util.resource.resources.text.IText;
import de.keksuccino.fancymenu.util.resource.resources.texture.ITexture;
import de.keksuccino.konkrete.input.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1074;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextElement
extends AbstractElement {
    @NotNull
    protected SourceMode sourceMode = SourceMode.DIRECT;
    @Nullable
    protected String source;
    protected volatile String text;
    protected String lastText;
    @Nullable
    public ResourceSupplier<IText> textResourceSupplier;
    public ResourceSupplier<ITexture> verticalScrollGrabberTextureNormal;
    public ResourceSupplier<ITexture> verticalScrollGrabberTextureHover;
    public ResourceSupplier<ITexture> horizontalScrollGrabberTextureNormal;
    public ResourceSupplier<ITexture> horizontalScrollGrabberTextureHover;
    public String scrollGrabberColorHexNormal;
    public String scrollGrabberColorHexHover;
    public boolean enableScrolling = true;
    public boolean interactable = true;
    @NotNull
    public volatile MarkdownRenderer markdownRenderer = new MarkdownRenderer();
    @NotNull
    public volatile ScrollArea scrollArea = new ScrollArea(0.0f, 0.0f, this.getAbsoluteWidth(), this.getAbsoluteHeight()){

        @Override
        public void updateScrollArea() {
            super.updateScrollArea();
            if (class_310.method_1551().field_1755 != null) {
                this.verticalScrollBar.scrollAreaEndX = TextElement.this.getAbsoluteX() + TextElement.this.getAbsoluteWidth() + 12;
                this.horizontalScrollBar.scrollAreaEndY = TextElement.this.getAbsoluteY() + TextElement.this.getAbsoluteHeight() + 12;
            }
        }

        @Override
        public boolean method_25402(double mouseX, double mouseY, int button) {
            if (TextElement.isEditor()) {
                if (this.verticalScrollBar.method_25402(mouseX, mouseY, button)) {
                    return true;
                }
                return this.horizontalScrollBar.method_25402(mouseX, mouseY, button);
            }
            return super.method_25402(mouseX, mouseY, button);
        }

        @Override
        public boolean method_25405(double mouseX, double mouseY) {
            if (TextElement.isEditor()) {
                return false;
            }
            return super.method_25405(mouseX, mouseY);
        }
    };
    protected List<String> lastLines;
    protected IText lastIText;

    public TextElement(@NotNull ElementBuilder<?, ?> builder) {
        super(builder);
        this.scrollArea.minimumEntryWidthIsAreaWidth = false;
        this.scrollArea.makeEntriesWidthOfArea = false;
        this.scrollArea.makeAllEntriesWidthOfWidestEntry = false;
        this.scrollArea.verticalScrollBar.grabberWidth = 10.0f;
        this.scrollArea.verticalScrollBar.grabberHeight = 20.0f;
        this.scrollArea.horizontalScrollBar.grabberWidth = 20.0f;
        this.scrollArea.horizontalScrollBar.grabberHeight = 10.0f;
        this.scrollArea.backgroundColor = () -> DrawableColor.of(0, 0, 0, 0);
        this.scrollArea.borderColor = () -> DrawableColor.of(0, 0, 0, 0);
        this.scrollArea.addEntry(new MarkdownRendererEntry(this.scrollArea, this.markdownRenderer));
        this.markdownRenderer.addLineRenderValidator(line -> {
            if (line.parent.getY() + line.offsetY + line.getLineHeight() < (float)this.getAbsoluteY()) {
                return false;
            }
            if (line.parent.getY() + line.offsetY > (float)(this.getAbsoluteY() + this.getAbsoluteHeight())) {
                return false;
            }
            return true;
        });
    }

    @Override
    public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {
        if (this.shouldRender()) {
            try {
                this.renderTick();
                this.markdownRenderer.setTextOpacity(this.opacity);
                RenderSystem.enableBlend();
                this.scrollArea.setX(this.getAbsoluteX(), true);
                this.scrollArea.setY(this.getAbsoluteY(), true);
                this.scrollArea.setWidth(this.getAbsoluteWidth(), true);
                this.scrollArea.setHeight(this.getAbsoluteHeight(), true);
                this.scrollArea.method_25394(graphics, mouseX, mouseY, partial);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            RenderingUtils.resetShaderColor(graphics);
        }
    }

    @Override
    @Nullable
    public List<class_364> getWidgetsToRegister() {
        return this.interactable ? ListUtils.of(this.markdownRenderer, this.scrollArea) : null;
    }

    protected void renderTick() {
        ITexture r;
        DrawableColor c;
        String t;
        if (this.sourceMode == SourceMode.RESOURCE) {
            List<String> lines;
            IText iText = this.textResourceSupplier != null ? this.textResourceSupplier.get() : null;
            List<String> list = lines = iText != null ? iText.getTextLines() : null;
            if (lines != null) {
                lines = new ArrayList<String>(lines);
            }
            if (!Objects.equals(this.lastIText, iText) || !Objects.equals(this.lastLines, lines)) {
                this.updateContent();
            }
            this.lastLines = lines;
            this.lastIText = iText;
        }
        if (!((t = this.text) == null || this.lastText != null && this.lastText.equals(t))) {
            this.markdownRenderer.setText(t);
        }
        this.lastText = t;
        this.scrollArea.verticalScrollBar.setScrollWheelAllowed(this.enableScrolling);
        this.scrollArea.verticalScrollBar.active = this.scrollArea.getTotalEntryHeight() > this.scrollArea.getInnerHeight() && this.enableScrolling;
        boolean bl = this.scrollArea.horizontalScrollBar.active = this.scrollArea.getTotalEntryWidth() > this.scrollArea.getInnerWidth() && this.enableScrolling;
        if (this.scrollGrabberColorHexNormal != null) {
            c = DrawableColor.of(this.scrollGrabberColorHexNormal);
            this.scrollArea.verticalScrollBar.idleBarColor = () -> c;
            this.scrollArea.horizontalScrollBar.idleBarColor = () -> c;
        }
        if (this.scrollGrabberColorHexHover != null) {
            c = DrawableColor.of(this.scrollGrabberColorHexHover);
            this.scrollArea.verticalScrollBar.hoverBarColor = () -> c;
            this.scrollArea.horizontalScrollBar.hoverBarColor = () -> c;
        }
        if (this.verticalScrollGrabberTextureNormal != null) {
            r = this.verticalScrollGrabberTextureNormal.get();
            if (r != null) {
                this.scrollArea.verticalScrollBar.idleBarTexture = r.getResourceLocation();
            }
        } else {
            this.scrollArea.verticalScrollBar.idleBarTexture = null;
        }
        if (this.verticalScrollGrabberTextureHover != null) {
            r = this.verticalScrollGrabberTextureHover.get();
            if (r != null) {
                this.scrollArea.verticalScrollBar.hoverBarTexture = r.getResourceLocation();
            }
        } else {
            this.scrollArea.verticalScrollBar.hoverBarTexture = null;
        }
        if (this.horizontalScrollGrabberTextureNormal != null) {
            r = this.horizontalScrollGrabberTextureNormal.get();
            if (r != null) {
                this.scrollArea.horizontalScrollBar.idleBarTexture = r.getResourceLocation();
            }
        } else {
            this.scrollArea.horizontalScrollBar.idleBarTexture = null;
        }
        if (this.horizontalScrollGrabberTextureHover != null) {
            r = this.horizontalScrollGrabberTextureHover.get();
            if (r != null) {
                this.scrollArea.horizontalScrollBar.hoverBarTexture = r.getResourceLocation();
            }
        } else {
            this.scrollArea.horizontalScrollBar.hoverBarTexture = null;
        }
    }

    public void updateContent() {
        if (this.source == null) {
            this.markdownRenderer.setText(class_1074.method_4662((String)"fancymenu.customization.items.text.placeholder", (Object[])new Object[0]));
            return;
        }
        new Thread(() -> {
            List<Object> linesRaw = new ArrayList<String>();
            try {
                if (this.source != null && !this.source.equals("")) {
                    if (this.sourceMode == SourceMode.DIRECT) {
                        String s = this.source.replace("%n%", "\n").replace("\r", "\n");
                        if (s.contains("\n")) {
                            linesRaw.addAll(Arrays.asList(StringUtils.splitLines((String)s, (String)"\n")));
                        } else {
                            linesRaw.add(s);
                        }
                    } else if (this.textResourceSupplier != null) {
                        IText iText = this.textResourceSupplier.get();
                        if (iText != null) {
                            linesRaw = iText.getTextLines();
                        }
                        linesRaw = linesRaw != null ? new ArrayList<Object>(linesRaw) : new ArrayList();
                    }
                } else {
                    linesRaw.add(class_1074.method_4662((String)"fancymenu.customization.items.text.placeholder", (Object[])new Object[0]));
                }
            }
            catch (Exception ex) {
                if (linesRaw == null) {
                    linesRaw = new ArrayList();
                }
                linesRaw.clear();
            }
            if (linesRaw.isEmpty()) {
                if (TextElement.isEditor()) {
                    linesRaw.add(class_1074.method_4662((String)"fancymenu.customization.items.text.status.unable_to_load", (Object[])new Object[0]));
                } else {
                    linesRaw.add("");
                }
            }
            StringBuilder text = new StringBuilder();
            for (String string : linesRaw) {
                if (text.length() > 0) {
                    text.append("\n");
                }
                text.append(string);
            }
            this.text = text.toString();
        }).start();
    }

    public void setSource(@NotNull SourceMode sourceMode, @Nullable String source) {
        this.sourceMode = Objects.requireNonNull(sourceMode);
        this.source = source;
        this.textResourceSupplier = null;
        if (sourceMode == SourceMode.RESOURCE && this.source != null) {
            this.textResourceSupplier = ResourceSupplier.text(this.source);
        }
        this.text = null;
        this.lastText = null;
        this.lastIText = null;
        this.lastLines = null;
        this.updateContent();
    }

    public static enum SourceMode implements LocalizedCycleEnum<SourceMode>
    {
        DIRECT("direct"),
        RESOURCE("resource");

        final String name;

        private SourceMode(String name) {
            this.name = name;
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @NotNull
        public SourceMode[] getValues() {
            return SourceMode.values();
        }

        @Override
        @Nullable
        public SourceMode getByNameInternal(@NotNull String name) {
            return SourceMode.getByName(name);
        }

        @Nullable
        public static SourceMode getByName(String name) {
            for (SourceMode i : SourceMode.values()) {
                if (!i.getName().equals(name)) continue;
                return i;
            }
            return null;
        }

        @Override
        @NotNull
        public String getLocalizationKeyBase() {
            return "fancymenu.elements.text.v2.source_mode";
        }

        @Override
        @NotNull
        public class_2583 getValueComponentStyle() {
            return (class_2583)WARNING_TEXT_STYLE.get();
        }
    }

    protected static class MarkdownRendererEntry
    extends ScrollAreaEntry {
        protected MarkdownRenderer markdownRenderer;

        public MarkdownRendererEntry(ScrollArea parent, MarkdownRenderer markdownRenderer) {
            super(parent, 20.0f, 20.0f);
            this.markdownRenderer = markdownRenderer;
            this.selectable = false;
            this.playClickSound = false;
            this.backgroundColorNormal = () -> DrawableColor.of(0, 0, 0, 0);
            this.backgroundColorHover = () -> DrawableColor.of(0, 0, 0, 0);
        }

        @Override
        public void renderEntry(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {
            this.markdownRenderer.setOptimalWidth(this.parent.getInnerWidth());
            this.markdownRenderer.setX(this.x);
            this.markdownRenderer.setY(this.y);
            this.setWidth(this.markdownRenderer.getRealWidth());
            this.setHeight(this.markdownRenderer.getRealHeight());
            this.markdownRenderer.method_25394(graphics, mouseX, mouseY, partial);
        }

        @Override
        public void onClick(ScrollAreaEntry entry, double mouseX, double mouseY, int button) {
        }
    }
}

