/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.customgui;

import de.keksuccino.fancymenu.FancyMenu;
import de.keksuccino.fancymenu.LegacyHandler;
import de.keksuccino.fancymenu.customization.customgui.CustomGui;
import de.keksuccino.fancymenu.customization.customgui.CustomGuiBaseScreen;
import de.keksuccino.fancymenu.customization.screen.identifier.ScreenIdentifierHandler;
import de.keksuccino.fancymenu.events.ModReloadEvent;
import de.keksuccino.fancymenu.util.event.acara.EventHandler;
import de.keksuccino.fancymenu.util.event.acara.EventListener;
import de.keksuccino.fancymenu.util.properties.PropertiesParser;
import de.keksuccino.fancymenu.util.properties.PropertyContainer;
import de.keksuccino.fancymenu.util.properties.PropertyContainerSet;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.class_310;
import net.minecraft.class_437;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class CustomGuiHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final File CUSTOM_GUIS_FILE = new File(FancyMenu.MOD_DIR, "/custom_gui_screens.txt");
    private static final File LEGACY_CUSTOM_GUIS_DIR = new File(FancyMenu.MOD_DIR, "/customguis");
    protected static final Map<String, CustomGui> CUSTOM_GUI_SCREENS = new HashMap<String, CustomGui>();
    protected static final Map<String, String> OVERRIDDEN_SCREENS = new HashMap<String, String>();
    protected static boolean initialized = false;

    public static void init() {
        CustomGuiHandler.reload();
        if (!LegacyHandler.getCheckList().customGuisPorted.getValue().booleanValue()) {
            LegacyHandler.getCheckList().customGuisPorted.setValue(true);
            for (CustomGui gui : CustomGuiHandler.deserializeLegacyGuis()) {
                CUSTOM_GUI_SCREENS.put(gui.identifier, gui);
            }
            CustomGuiHandler.saveChanges();
        }
        EventHandler.INSTANCE.registerListenersOf(new CustomGuiHandler());
        initialized = true;
    }

    public static void reload() {
        try {
            if (initialized || !CUSTOM_GUIS_FILE.isFile()) {
                CustomGuiHandler.saveChanges();
            }
            OVERRIDDEN_SCREENS.clear();
            CUSTOM_GUI_SCREENS.clear();
            PropertyContainerSet set = PropertiesParser.deserializeSetFromFile(CUSTOM_GUIS_FILE.getAbsolutePath());
            if (set != null) {
                PropertyContainer overridden = set.getFirstContainerOfType("overridden_screens");
                if (overridden != null) {
                    for (Map.Entry entry : overridden.getProperties().entrySet()) {
                        OVERRIDDEN_SCREENS.put(ScreenIdentifierHandler.getBestIdentifier((String)entry.getKey()), (String)entry.getValue());
                    }
                }
                for (PropertyContainer propertyContainer : set.getContainersOfType("custom_gui")) {
                    CustomGui gui = CustomGui.deserialize(propertyContainer);
                    if (gui == null) continue;
                    CUSTOM_GUI_SCREENS.put(gui.identifier, gui);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void saveChanges() {
        try {
            CUSTOM_GUIS_FILE.createNewFile();
            PropertyContainerSet set = new PropertyContainerSet("custom_gui_screens");
            PropertyContainer overridden = new PropertyContainer("overridden_screens");
            for (Map.Entry<String, String> m : OVERRIDDEN_SCREENS.entrySet()) {
                overridden.putProperty(m.getKey(), m.getValue());
            }
            set.putContainer(overridden);
            for (CustomGui gui : CUSTOM_GUI_SCREENS.values()) {
                set.putContainer(gui.serialize());
            }
            PropertiesParser.serializeSetToFile(set, CUSTOM_GUIS_FILE.getAbsolutePath());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @EventListener
    public void onReloadFancyMenu(ModReloadEvent e) {
        LOGGER.info("[FANCYMENU] Reloading Custom GUIs..");
        CustomGuiHandler.reload();
    }

    @Nullable
    public static class_437 beforeSetScreen(@Nullable class_437 screen) {
        CustomGui gui;
        if (screen != null && !(screen instanceof CustomGuiBaseScreen) && (gui = CustomGuiHandler.getGuiForOverriddenScreen(screen)) != null) {
            LOGGER.info("[FANCYMENU] Overriding '" + screen.getClass().getName() + "' with custom GUI '" + gui.identifier + "'..");
            return CustomGuiHandler.constructInstance(gui, class_310.method_1551().field_1755, screen);
        }
        return null;
    }

    public static void overrideScreenWithCustomGui(@NotNull String targetMenuIdentifier, @NotNull String customGuiIdentifier) {
        OVERRIDDEN_SCREENS.put(targetMenuIdentifier, customGuiIdentifier);
        CustomGuiHandler.saveChanges();
    }

    public static void removeScreenOverrideFor(@NotNull String menuIdentifier) {
        OVERRIDDEN_SCREENS.remove(menuIdentifier);
        CustomGuiHandler.saveChanges();
    }

    @Nullable
    public static CustomGui getGuiForOverriddenScreen(@NotNull class_437 screen) {
        if (screen instanceof CustomGuiBaseScreen) {
            return null;
        }
        for (Map.Entry<String, String> m : OVERRIDDEN_SCREENS.entrySet()) {
            if (!ScreenIdentifierHandler.isIdentifierOfScreen(m.getKey(), screen)) continue;
            return CustomGuiHandler.getGui(m.getValue());
        }
        return null;
    }

    public static Map<String, String> getOverriddenScreens() {
        return OVERRIDDEN_SCREENS;
    }

    public static void addGui(@NotNull CustomGui gui) {
        if (!CustomGuiHandler.guiExists(gui.identifier)) {
            CUSTOM_GUI_SCREENS.put(gui.identifier, gui);
            CustomGuiHandler.saveChanges();
        }
    }

    public static void removeGui(@NotNull String identifier) {
        if (CustomGuiHandler.guiExists(identifier)) {
            CUSTOM_GUI_SCREENS.remove(identifier);
            CustomGuiHandler.saveChanges();
        }
    }

    @Nullable
    public static CustomGui getGui(@NotNull String identifier) {
        return CUSTOM_GUI_SCREENS.get(identifier);
    }

    @NotNull
    public static List<CustomGui> getGuis() {
        return new ArrayList<CustomGui>(CUSTOM_GUI_SCREENS.values());
    }

    @NotNull
    public static List<String> getGuiIdentifiers() {
        ArrayList<String> l = new ArrayList<String>();
        CustomGuiHandler.getGuis().forEach(customGui -> l.add(customGui.identifier));
        return l;
    }

    public static boolean guiExists(@NotNull String identifier) {
        return CUSTOM_GUI_SCREENS.containsKey(identifier);
    }

    @NotNull
    public static CustomGuiBaseScreen constructInstance(@NotNull CustomGui customGui, @Nullable class_437 parentScreen, @Nullable class_437 overrideScreen) {
        return new CustomGuiBaseScreen(Objects.requireNonNull(customGui), parentScreen, overrideScreen);
    }

    @Nullable
    public static CustomGuiBaseScreen constructInstance(@NotNull String identifier, @Nullable class_437 parentScreen, @Nullable class_437 overrideScreen) {
        CustomGui gui = CustomGuiHandler.getGui(identifier);
        if (gui == null) {
            return null;
        }
        return CustomGuiHandler.constructInstance(gui, parentScreen, overrideScreen);
    }

    @NotNull
    private static List<CustomGui> deserializeLegacyGuis() {
        ArrayList<CustomGui> guis = new ArrayList<CustomGui>();
        if (LEGACY_CUSTOM_GUIS_DIR.isDirectory()) {
            LOGGER.info("[FANCYMENU] Trying to port old FMv2 custom GUIs to the new FMv3 system..");
            for (String s : de.keksuccino.fancymenu.util.file.FileUtils.getFiles((String)LEGACY_CUSTOM_GUIS_DIR.getPath())) {
                File f = new File(s);
                String identifier = null;
                String title = null;
                boolean allowEsc = false;
                for (String s2 : de.keksuccino.fancymenu.util.file.FileUtils.getFileLines((File)f)) {
                    if (!s2.contains("=")) continue;
                    String variable = s2.replace(" ", "").split("=", 2)[0].toLowerCase();
                    String value = "";
                    String rawValue = s2.split("=", 2)[1];
                    for (int i = 0; i < rawValue.length(); ++i) {
                        if (rawValue.charAt(i) == ' ') continue;
                        value = rawValue.substring(i);
                        break;
                    }
                    if (variable.equals("identifier")) {
                        identifier = value;
                    }
                    if (variable.equals("title")) {
                        title = value;
                    }
                    if (!variable.equals("allowesc") || !value.equalsIgnoreCase("true")) continue;
                    allowEsc = true;
                }
                if (identifier == null) continue;
                CustomGui gui = new CustomGui();
                gui.identifier = identifier;
                gui.title = title;
                gui.allowEsc = allowEsc;
                guis.add(gui);
            }
            try {
                LOGGER.info("[FANCYMENU] Successfully ported old FMv2 custom GUIs to new FMv3 system! Renaming old FMv2 'customguis' directory now..");
                File renamedDir = de.keksuccino.fancymenu.util.file.FileUtils.generateUniqueFileName(new File(LEGACY_CUSTOM_GUIS_DIR.getPath() + "_old"), true);
                FileUtils.moveDirectory((File)LEGACY_CUSTOM_GUIS_DIR, (File)renamedDir);
            }
            catch (Exception ex) {
                LOGGER.error("[FANCYMENU] Failed to rename old FMv2 'customguis' directory!");
                ex.printStackTrace();
            }
        }
        return guis;
    }
}

