/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.addons.image.util;

import net.jafama.FastMath;

public class ColorUtil {
    private ColorUtil() {
    }

    public static int distance(int a, int b) {
        return FastMath.abs(ColorUtil.getRed(a) - ColorUtil.getRed(b)) + FastMath.abs(ColorUtil.getGreen(a) - ColorUtil.getGreen(b)) + FastMath.abs(ColorUtil.getBlue(a) - ColorUtil.getBlue(b));
    }

    public static int getRed(int argb) {
        return argb >> 16 & 0xFF;
    }

    public static int getGreen(int argb) {
        return argb >> 8 & 0xFF;
    }

    public static int getBlue(int argb) {
        return argb & 0xFF;
    }

    public static int getAlpha(int argb) {
        return argb >> 24 & 0xFF;
    }

    public static int getGrayscale(int argb) {
        return (ColorUtil.getRed(argb) + ColorUtil.getGreen(argb) + ColorUtil.getBlue(argb)) / 3;
    }

    public static int getChannel(int argb, Channel channel) {
        return channel.from(argb);
    }

    public static int zeroRed(int argb) {
        return argb & 0xFF00FFFF;
    }

    public static int zeroGreen(int argb) {
        return argb & 0xFFFF00FF;
    }

    public static int zeroBlue(int argb) {
        return argb & 0xFFFFFF00;
    }

    public static int zeroAlpha(int argb) {
        return argb & 0xFFFFFF;
    }

    public static int zeroGrayscale(int argb) {
        return argb & 0xFF000000;
    }

    public static int zeroChannel(int argb, Channel channel) {
        return channel.zero(argb);
    }

    public static int premultiply(int argb) {
        int alpha = ColorUtil.getAlpha(argb);
        int red = (ColorUtil.getRed(argb) * alpha + 127) / 255;
        int green = (ColorUtil.getGreen(argb) * alpha + 127) / 255;
        int blue = (ColorUtil.getBlue(argb) * alpha + 127) / 255;
        return ColorUtil.argb(alpha, red, green, blue);
    }

    public static int argb(int alpha, int red, int green, int blue) {
        return ColorUtil.argbAlpha(alpha) | ColorUtil.argbRed(red) | ColorUtil.argbGreen(green) | ColorUtil.argbBlue(blue);
    }

    public static int argbValidated(int alpha, int red, int green, int blue) throws IllegalArgumentException {
        if (alpha < 0 || alpha > 255 || red < 0 || red > 255 || green < 0 || green > 255 || blue < 0 || blue > 255) {
            throw new IllegalArgumentException("Channel values must be in range 0-255");
        }
        return ColorUtil.argb(alpha, red, green, blue);
    }

    public static int argbAlpha(int alpha) {
        return alpha << 24;
    }

    public static int argbRed(int red) {
        return red << 16;
    }

    public static int argbGreen(int green) {
        return green << 8;
    }

    public static int argbBlue(int blue) {
        return blue;
    }

    public static int argbGrayscale(int value) {
        return ColorUtil.argb(value, value, value, value);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum Channel {
        RED{

            @Override
            public int from(int argb) {
                return ColorUtil.getRed(argb);
            }

            @Override
            public int zero(int argb) {
                return ColorUtil.zeroRed(argb);
            }

            @Override
            public int argb(int value) {
                return ColorUtil.argbRed(value);
            }
        }
        ,
        GREEN{

            @Override
            public int from(int argb) {
                return ColorUtil.getGreen(argb);
            }

            @Override
            public int zero(int argb) {
                return ColorUtil.zeroGreen(argb);
            }

            @Override
            public int argb(int value) {
                return ColorUtil.argbGreen(value);
            }
        }
        ,
        BLUE{

            @Override
            public int from(int argb) {
                return ColorUtil.getBlue(argb);
            }

            @Override
            public int zero(int argb) {
                return ColorUtil.zeroBlue(argb);
            }

            @Override
            public int argb(int value) {
                return ColorUtil.argbBlue(value);
            }
        }
        ,
        GRAYSCALE{

            @Override
            public int from(int argb) {
                return ColorUtil.getGrayscale(argb);
            }

            @Override
            public int zero(int argb) {
                return ColorUtil.zeroGrayscale(argb);
            }

            @Override
            public int argb(int value) {
                return ColorUtil.argbAlpha(value);
            }
        }
        ,
        ALPHA{

            @Override
            public int from(int argb) {
                return ColorUtil.getAlpha(argb);
            }

            @Override
            public int zero(int argb) {
                return ColorUtil.zeroAlpha(argb);
            }

            @Override
            public int argb(int value) {
                return ColorUtil.argbAlpha(value);
            }
        };


        public abstract int from(int var1);

        public abstract int zero(int var1);

        public abstract int argb(int var1);
    }
}

