/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.addons.image.converter;

import com.dfsek.terra.addons.image.converter.ColorConverter;
import com.dfsek.terra.addons.image.util.ColorUtil;
import java.util.Map;

public class ClosestMatchColorConverter<T>
implements ColorConverter<T> {
    private final Map<Integer, T> map;
    private final Integer[] colors;

    public ClosestMatchColorConverter(Map<Integer, T> map) {
        this.map = map;
        this.colors = map.keySet().toArray(new Integer[0]);
    }

    @Override
    public T apply(int color) {
        int closest = 0;
        int smallestDistance = Integer.MAX_VALUE;
        Integer[] integerArray = this.colors;
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int compare = integerArray[i];
            if (color == compare) {
                closest = compare;
                break;
            }
            int distance = ColorUtil.distance(color, compare);
            if (distance >= smallestDistance) continue;
            smallestDistance = distance;
            closest = compare;
        }
        return this.map.get(closest);
    }

    @Override
    public Iterable<T> getEntries() {
        return this.map.values();
    }
}

