/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.addons.image.config.image;

import com.dfsek.tectonic.api.config.template.ValidatedConfigTemplate;
import com.dfsek.tectonic.api.config.template.annotations.Default;
import com.dfsek.tectonic.api.config.template.annotations.Value;
import com.dfsek.tectonic.api.config.template.object.ObjectTemplate;
import com.dfsek.tectonic.api.exception.ValidationException;
import com.dfsek.terra.addons.image.config.image.ImageCache;
import com.dfsek.terra.addons.image.image.Image;
import com.dfsek.terra.addons.image.image.StitchedImage;
import com.dfsek.terra.api.config.ConfigPack;
import com.dfsek.terra.api.config.Loader;
import java.io.IOException;

public class StitchedImageTemplate
implements ObjectTemplate<Image>,
ValidatedConfigTemplate {
    @Value(value="path-format")
    private String path;
    @Value(value="rows")
    private int rows;
    @Value(value="columns")
    private int cols;
    @Value(value="zero-indexed")
    @Default
    private boolean zeroIndexed = false;
    private final Loader files;
    private final ConfigPack pack;

    public StitchedImageTemplate(Loader files, ConfigPack pack) {
        this.files = files;
        this.pack = pack;
    }

    public Image get() {
        Image[][] grid = new Image[this.rows][this.cols];
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.cols; ++j) {
                try {
                    grid[i][j] = ImageCache.load(this.getFormattedPath(i, j), this.pack, this.files);
                    continue;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return new StitchedImage(grid, this.zeroIndexed);
    }

    private String getFormattedPath(int row, int column) {
        if (!this.zeroIndexed) {
            ++row;
            ++column;
        }
        return this.path.replaceFirst("\\{row}", String.valueOf(row)).replaceFirst("\\{column}", String.valueOf(column));
    }

    public boolean validate() throws ValidationException {
        if (!this.path.contains("{row}")) {
            throw new ValidationException("Path format does not contain sequence '{row}'");
        }
        if (!this.path.contains("{column}")) {
            throw new ValidationException("Path format does not contain sequence '{column}'");
        }
        if (this.rows < 1) {
            throw new ValidationException("Must have at least one row");
        }
        if (this.cols < 1) {
            throw new ValidationException("Must have at least one column");
        }
        return true;
    }
}

