/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.addons.image.config.image;

import com.dfsek.terra.addons.image.image.BufferedImageWrapper;
import com.dfsek.terra.addons.image.image.Image;
import com.dfsek.terra.api.config.ConfigPack;
import com.dfsek.terra.api.config.Loader;
import com.dfsek.terra.api.properties.Properties;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import javax.imageio.ImageIO;

record ImageCache(ConcurrentHashMap<String, Image> map) implements Properties
{
    public static Image load(String path, ConfigPack pack, Loader files) throws IOException {
        ImageCache cache;
        if (!pack.getContext().has(ImageCache.class)) {
            cache = new ImageCache(new ConcurrentHashMap<String, Image>());
            pack.getContext().put((Properties)cache);
        } else {
            cache = (ImageCache)pack.getContext().get(ImageCache.class);
        }
        if (cache.map.containsKey(path)) {
            return cache.map.get(path);
        }
        try {
            BufferedImageWrapper image = new BufferedImageWrapper(ImageIO.read(files.get(path)));
            cache.map.put(path, image);
            return image;
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Unable to load image (image might be too large?)", e);
        }
        catch (IOException e) {
            if (e instanceof FileNotFoundException) {
                throw new IOException("Unable to load image: No such file or directory: " + path, e);
            }
            throw new IOException("Unable to load image", e);
        }
    }
}

