/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.addons.biome.pipeline.mutator;

import com.dfsek.terra.addons.biome.pipeline.api.delegate.BiomeDelegate;
import com.dfsek.terra.addons.biome.pipeline.api.stage.type.BiomeMutator;
import com.dfsek.terra.api.noise.NoiseSampler;
import com.dfsek.terra.api.util.MathUtil;
import java.util.Objects;

public class SmoothMutator
implements BiomeMutator {
    private final NoiseSampler sampler;

    public SmoothMutator(NoiseSampler sampler) {
        this.sampler = sampler;
    }

    @Override
    public BiomeDelegate mutate(BiomeMutator.ViewPoint viewPoint, double x, double z, long seed) {
        boolean horiz;
        BiomeDelegate top = viewPoint.getBiome(1, 0);
        BiomeDelegate bottom = viewPoint.getBiome(-1, 0);
        BiomeDelegate left = viewPoint.getBiome(0, 1);
        BiomeDelegate right = viewPoint.getBiome(0, -1);
        boolean vert = Objects.equals(top, bottom) && top != null;
        boolean bl = horiz = Objects.equals(left, right) && left != null;
        if (vert && horiz) {
            return MathUtil.normalizeIndex((double)this.sampler.noise(seed, x, z), (int)2) == 0 ? left : top;
        }
        if (vert) {
            return top;
        }
        if (horiz) {
            return left;
        }
        return viewPoint.getBiome(0, 0);
    }
}

