/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.addons.biome.pipeline.mutator;

import com.dfsek.terra.addons.biome.pipeline.api.delegate.BiomeDelegate;
import com.dfsek.terra.addons.biome.pipeline.api.stage.type.BiomeMutator;
import com.dfsek.terra.api.noise.NoiseSampler;
import com.dfsek.terra.api.util.collection.ProbabilityCollection;
import java.util.HashSet;
import java.util.function.Predicate;

public class BorderMutator
implements BiomeMutator {
    private final String border;
    private final NoiseSampler noiseSampler;
    private final ProbabilityCollection<BiomeDelegate> replace;
    private final String replaceTag;

    public BorderMutator(String border, String replaceTag, NoiseSampler noiseSampler, ProbabilityCollection<BiomeDelegate> replace) {
        this.border = border;
        this.noiseSampler = noiseSampler;
        this.replace = replace;
        this.replaceTag = replaceTag;
    }

    @Override
    public BiomeDelegate mutate(BiomeMutator.ViewPoint viewPoint, double x, double z, long seed) {
        BiomeDelegate origin = viewPoint.getBiome(0, 0);
        if (origin.getTags().contains(this.replaceTag)) {
            for (int xi = -1; xi <= 1; ++xi) {
                for (int zi = -1; zi <= 1; ++zi) {
                    BiomeDelegate current;
                    if (xi == 0 && zi == 0 || (current = viewPoint.getBiome(xi, zi)) == null || !current.getTags().contains(this.border)) continue;
                    BiomeDelegate biome = (BiomeDelegate)this.replace.get(this.noiseSampler, x, z, seed);
                    return biome.isSelf() ? origin : biome;
                }
            }
        }
        return origin;
    }

    @Override
    public Iterable<BiomeDelegate> getBiomes(Iterable<BiomeDelegate> biomes) {
        HashSet<BiomeDelegate> biomeSet = new HashSet<BiomeDelegate>();
        biomes.forEach(biomeSet::add);
        biomeSet.addAll(this.replace.getContents().stream().filter(Predicate.not(BiomeDelegate::isSelf)).toList());
        return biomeSet;
    }
}

