/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.addons.biome.pipeline;

import com.dfsek.terra.addons.biome.pipeline.BiomePipeline;
import com.dfsek.terra.addons.biome.pipeline.BiomePipelineColumn;
import com.dfsek.terra.addons.biome.pipeline.api.BiomeHolder;
import com.dfsek.terra.addons.biome.pipeline.api.delegate.BiomeDelegate;
import com.dfsek.terra.addons.biome.pipeline.api.stage.Stage;
import com.dfsek.terra.addons.biome.pipeline.lib.jafama.FastMath;
import com.dfsek.terra.api.noise.NoiseSampler;
import com.dfsek.terra.api.registry.key.StringIdentifiable;
import com.dfsek.terra.api.util.Column;
import com.dfsek.terra.api.world.biome.Biome;
import com.dfsek.terra.api.world.biome.generation.BiomeProvider;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.StreamSupport;

public class BiomePipelineProvider
implements BiomeProvider {
    private final LoadingCache<SeededVector, BiomeHolder> holderCache;
    private final BiomePipeline pipeline;
    private final int resolution;
    private final NoiseSampler mutator;
    private final double noiseAmp;
    private final Set<Biome> biomes;

    public BiomePipelineProvider(BiomePipeline pipeline, int resolution, NoiseSampler mutator, double noiseAmp) {
        this.resolution = resolution;
        this.mutator = mutator;
        this.noiseAmp = noiseAmp;
        this.holderCache = Caffeine.newBuilder().maximumSize(1024L).build(key -> pipeline.getBiomes(key.x, key.z, key.seed));
        this.pipeline = pipeline;
        HashSet<BiomeDelegate> biomeSet = new HashSet<BiomeDelegate>();
        pipeline.getSource().getBiomes().forEach(biomeSet::add);
        Iterable<BiomeDelegate> result = biomeSet;
        for (Stage stage : pipeline.getStages()) {
            result = stage.getBiomes(result);
        }
        this.biomes = new HashSet<Biome>();
        HashSet<BiomeDelegate> finalResult = result;
        result.forEach(biomeDelegate -> {
            if (biomeDelegate.isEphemeral()) {
                StringBuilder biomeList = new StringBuilder("\n");
                StreamSupport.stream(finalResult.spliterator(), false).sorted(Comparator.comparing(StringIdentifiable::getID)).forEach(delegate -> biomeList.append("    - ").append(delegate.getID()).append(':').append(delegate.getClass().getCanonicalName()).append('\n'));
                throw new IllegalArgumentException("Biome Pipeline leaks ephemeral biome \"" + biomeDelegate.getID() + "\". Ensure there is a stage to guarantee replacement of the ephemeral biome. Biomes: " + biomeList);
            }
            this.biomes.add(biomeDelegate.getBiome());
        });
    }

    public Biome getBiome(int x, int y, int z, long seed) {
        return this.getBiome(x, z, seed);
    }

    public Biome getBiome(int x, int z, long seed) {
        x = (int)((double)x + this.mutator.noise(seed + 1L, x, z) * this.noiseAmp);
        z = (int)((double)z + this.mutator.noise(seed + 2L, x, z) * this.noiseAmp);
        int fdX = FastMath.floorDiv(x /= this.resolution, this.pipeline.getSize());
        int fdZ = FastMath.floorDiv(z /= this.resolution, this.pipeline.getSize());
        return ((BiomeHolder)this.holderCache.get((Object)new SeededVector(fdX, fdZ, seed))).getBiome(x - fdX * this.pipeline.getSize(), z - fdZ * this.pipeline.getSize()).getBiome();
    }

    public Optional<Biome> getBaseBiome(int x, int z, long seed) {
        return Optional.of(this.getBiome(x, z, seed));
    }

    public Iterable<Biome> getBiomes() {
        return this.biomes;
    }

    public Column<Biome> getColumn(int x, int z, long seed, int min, int max) {
        return new BiomePipelineColumn(this, min, max, x, z, seed);
    }

    public int resolution() {
        return this.resolution;
    }

    private record SeededVector(int x, int z, long seed) {
        @Override
        public boolean equals(Object obj) {
            if (obj instanceof SeededVector) {
                SeededVector that = (SeededVector)obj;
                return this.z == that.z && this.x == that.x && this.seed == that.seed;
            }
            return false;
        }

        @Override
        public int hashCode() {
            int code = this.x;
            code = 31 * code + this.z;
            return 31 * code + (int)(this.seed ^ this.seed >>> 32);
        }
    }
}

