/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.addons.biome.pipeline;

import com.dfsek.terra.addons.biome.pipeline.BiomeHolderImpl;
import com.dfsek.terra.addons.biome.pipeline.api.BiomeHolder;
import com.dfsek.terra.addons.biome.pipeline.api.stage.Stage;
import com.dfsek.terra.addons.biome.pipeline.source.BiomeSource;
import com.dfsek.terra.api.util.vector.Vector2;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BiomePipeline {
    private final BiomeSource source;
    private final List<Stage> stages;
    private final int size;
    private final int init;

    private BiomePipeline(BiomeSource source, List<Stage> stages, int size, int init) {
        this.source = source;
        this.stages = stages;
        this.size = size;
        this.init = init;
    }

    public BiomeHolder getBiomes(int x, int z, long seed) {
        BiomeHolder holder = new BiomeHolderImpl(this.init, Vector2.of((double)(x * (this.init - 1)), (double)(z * (this.init - 1))).mutable());
        holder.fill(this.source, seed);
        for (Stage stage : this.stages) {
            holder = stage.apply(holder, seed);
        }
        return holder;
    }

    public BiomeSource getSource() {
        return this.source;
    }

    public List<Stage> getStages() {
        return Collections.unmodifiableList(this.stages);
    }

    public int getSize() {
        return this.size;
    }

    public static final class BiomePipelineBuilder {
        private final int init;
        private final List<Stage> stages = new ArrayList<Stage>();
        private int expand;

        public BiomePipelineBuilder(int init) {
            this.init = init;
            this.expand = init;
        }

        public BiomePipeline build(BiomeSource source) {
            for (Stage stage : this.stages) {
                if (!stage.isExpansion()) continue;
                this.expand = this.expand * 2 - 1;
            }
            return new BiomePipeline(source, this.stages, this.expand, this.init);
        }

        public BiomePipelineBuilder addStage(Stage stage) {
            this.stages.add(stage);
            return this;
        }
    }
}

