/*
 * Decompiled with CFR 0.152.
 */
package com.obscuria.obscureapi.common.entities;

import com.obscuria.obscureapi.registry.ObscureAPIEnchantments;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_8111;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CompoundProjectileEntity
extends class_1309 {
    private static final UUID BLANK_UUID = UUID.fromString("0-0-0-0-0");
    protected static final class_2940<Float> SCALE = class_2945.method_12791(CompoundProjectileEntity.class, (class_2941)class_2943.field_13320);
    protected static final class_2940<Float> SCALE_SPEED = class_2945.method_12791(CompoundProjectileEntity.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Optional<UUID>> OWNER_UUID = class_2945.method_12791(CompoundProjectileEntity.class, (class_2941)class_2943.field_13313);
    private static final class_2940<Integer> OWNER_ID = class_2945.method_12791(CompoundProjectileEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<class_1799> RELATED_STACK = class_2945.method_12791(CompoundProjectileEntity.class, (class_2941)class_2943.field_13322);
    private static final class_2940<Boolean> UNRELATED = class_2945.method_12791(CompoundProjectileEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Integer> SPIN = class_2945.method_12791(CompoundProjectileEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Float> OFFSET = class_2945.method_12791(CompoundProjectileEntity.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Integer> LIFETIME = class_2945.method_12791(CompoundProjectileEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> USES = class_2945.method_12791(CompoundProjectileEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> DAMAGE = class_2945.method_12791(CompoundProjectileEntity.class, (class_2941)class_2943.field_13327);
    @Nullable
    public class_1297 owner = null;

    public CompoundProjectileEntity(class_1299<? extends CompoundProjectileEntity> type, class_1937 world) {
        super(type, world);
        this.method_5875(true);
    }

    public static void create(class_1299<? extends CompoundProjectileEntity> type, class_1297 owner, class_1937 level, @Nullable class_1799 stack, int damage, float offset, int lifetime, int maxUses) {
        if (level instanceof class_3218) {
            class_3218 server = (class_3218)level;
            if (stack != null && class_1890.method_8225((class_1887)ObscureAPIEnchantments.MIRROR, (class_1799)stack) > 0) {
                class_1297 projectile1 = type.method_5883((class_1937)server);
                class_1297 projectile2 = type.method_5883((class_1937)server);
                if (projectile1 instanceof CompoundProjectileEntity) {
                    CompoundProjectileEntity p1 = (CompoundProjectileEntity)projectile1;
                    if (projectile2 instanceof CompoundProjectileEntity) {
                        CompoundProjectileEntity p2 = (CompoundProjectileEntity)projectile2;
                        p1.defineOwner(owner, stack);
                        p2.defineOwner(owner, stack);
                        p1.method_5841().method_12778(OFFSET, (Object)Float.valueOf(offset));
                        p2.method_5841().method_12778(OFFSET, (Object)Float.valueOf(offset + 0.5f));
                        p1.method_5841().method_12778(LIFETIME, (Object)lifetime);
                        p2.method_5841().method_12778(LIFETIME, (Object)lifetime);
                        p1.method_5841().method_12778(USES, (Object)maxUses);
                        p2.method_5841().method_12778(USES, (Object)maxUses);
                        p1.method_5841().method_12778(DAMAGE, (Object)((int)Math.round((double)damage * 0.5)));
                        p2.method_5841().method_12778(DAMAGE, (Object)((int)Math.round((double)damage * 0.5)));
                        p1.method_23327(owner.method_23317(), owner.method_23318() + (double)(owner.method_17682() / 2.0f), owner.method_23321());
                        p2.method_23327(owner.method_23317(), owner.method_23318() + (double)(owner.method_17682() / 2.0f), owner.method_23321());
                        level.method_8649((class_1297)p1);
                        level.method_8649((class_1297)p2);
                    }
                }
            } else {
                class_1297 projectile = type.method_5883((class_1937)server);
                if (projectile instanceof CompoundProjectileEntity) {
                    CompoundProjectileEntity p = (CompoundProjectileEntity)projectile;
                    p.defineOwner(owner, stack);
                    p.method_5841().method_12778(OFFSET, (Object)Float.valueOf(offset));
                    p.method_5841().method_12778(LIFETIME, (Object)lifetime);
                    p.method_5841().method_12778(USES, (Object)maxUses);
                    p.method_5841().method_12778(DAMAGE, (Object)damage);
                    p.method_23327(owner.method_23317(), owner.method_23318() + (double)(owner.method_17682() / 2.0f), owner.method_23321());
                    level.method_8649((class_1297)p);
                }
            }
        }
    }

    protected void method_5693() {
        this.method_5841().method_12784(SCALE, (Object)Float.valueOf(1.0f));
        this.method_5841().method_12784(SCALE_SPEED, (Object)Float.valueOf(0.3f));
        this.method_5841().method_12784(OWNER_UUID, Optional.of(BLANK_UUID));
        this.method_5841().method_12784(OWNER_ID, (Object)0);
        this.method_5841().method_12784(RELATED_STACK, (Object)class_1799.field_8037);
        this.method_5841().method_12784(UNRELATED, (Object)false);
        this.method_5841().method_12784(SPIN, (Object)0);
        this.method_5841().method_12784(OFFSET, (Object)Float.valueOf(0.0f));
        this.method_5841().method_12784(LIFETIME, (Object)0);
        this.method_5841().method_12784(USES, (Object)0);
        this.method_5841().method_12784(DAMAGE, (Object)0);
        super.method_5693();
    }

    public void method_5652(class_2487 tag) {
        class_2487 data = new class_2487();
        data.method_10548("Scale", ((Float)this.method_5841().method_12789(SCALE)).floatValue());
        data.method_10548("ScaleSpeed", ((Float)this.method_5841().method_12789(SCALE_SPEED)).floatValue());
        data.method_25927("Owner", ((Optional)this.method_5841().method_12789(OWNER_UUID)).orElse(BLANK_UUID));
        data.method_10569("OwnerID", ((Integer)this.method_5841().method_12789(OWNER_ID)).intValue());
        data.method_10566("ItemStack", (class_2520)((class_1799)this.method_5841().method_12789(RELATED_STACK)).method_7953(new class_2487()));
        data.method_10556("Unrelated", ((Boolean)this.method_5841().method_12789(UNRELATED)).booleanValue());
        data.method_10569("Spin", ((Integer)this.method_5841().method_12789(SPIN)).intValue());
        data.method_10548("Offset", ((Float)this.method_5841().method_12789(OFFSET)).floatValue());
        data.method_10569("LifeTime", ((Integer)this.method_5841().method_12789(LIFETIME)).intValue());
        data.method_10569("Uses", ((Integer)this.method_5841().method_12789(USES)).intValue());
        data.method_10569("Damage", ((Integer)this.method_5841().method_12789(DAMAGE)).intValue());
        tag.method_10566("ProjectileData", (class_2520)data);
        super.method_5652(tag);
    }

    public void method_5749(class_2487 tag) {
        class_2487 data = tag.method_10562("ProjectileData");
        if (data.method_33133()) {
            return;
        }
        this.method_5841().method_12778(SCALE, (Object)Float.valueOf(data.method_10583("Scale")));
        this.method_5841().method_12778(SCALE_SPEED, (Object)Float.valueOf(data.method_10583("ScaleSpeed")));
        this.method_5841().method_12778(OWNER_UUID, Optional.of(data.method_25926("Owner")));
        this.method_5841().method_12778(OWNER_ID, (Object)data.method_10550("OwnerID"));
        this.method_5841().method_12778(RELATED_STACK, (Object)class_1799.method_7915((class_2487)data.method_10562("ItemStack")));
        this.method_5841().method_12778(UNRELATED, (Object)data.method_10577("Unrelated"));
        this.method_5841().method_12778(SPIN, (Object)data.method_10550("Spin"));
        this.method_5841().method_12778(OFFSET, (Object)Float.valueOf(data.method_10583("Offset")));
        this.method_5841().method_12778(LIFETIME, (Object)data.method_10550("LifeTime"));
        this.method_5841().method_12778(USES, (Object)data.method_10550("Uses"));
        this.method_5841().method_12778(DAMAGE, (Object)data.method_10550("Damage"));
        super.method_5749(tag);
    }

    public void defineOwner(class_1297 entity, @Nullable class_1799 stack) {
        if (stack != null) {
            this.method_5841().method_12778(RELATED_STACK, (Object)stack);
        } else {
            this.method_5841().method_12778(UNRELATED, (Object)true);
        }
        this.method_5841().method_12778(OWNER_UUID, Optional.of(entity.method_5667()));
        this.owner = entity;
    }

    public void method_5773() {
        this.owner = this.method_37908().method_8469(((Integer)this.method_5841().method_12789(OWNER_ID)).intValue());
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 server = (class_3218)class_19372;
            class_1297 owner = server.method_14190(((Optional)this.method_5841().method_12789(OWNER_UUID)).orElse(BLANK_UUID));
            if (owner != null) {
                this.method_5841().method_12778(OWNER_ID, (Object)owner.method_5628());
                this.owner = owner;
            }
            this.method_5841().method_12778(SPIN, (Object)((Integer)this.method_5841().method_12789(SPIN) + 1));
            this.method_5841().method_12778(LIFETIME, (Object)((Integer)this.method_5841().method_12789(LIFETIME) - 1));
            if (this.owner == null || !this.owner.method_5805() || (Integer)this.method_5841().method_12789(USES) <= 0 || (Integer)this.method_5841().method_12789(LIFETIME) <= 0) {
                this.method_31472();
            }
            if (this.owner != null) {
                this.updateMotion();
                List list = this.method_37908().method_8390(class_1309.class, new class_238(this.method_19538(), this.method_19538()).method_1014((double)this.getAttackRange()), e -> true);
                for (class_1309 entities : list) {
                    if (entities == this.owner || !(entities.method_19538().method_1022(this.method_19538()) <= (double)this.getAttackRange())) continue;
                    this.attack(entities);
                }
            }
        }
        super.method_5773();
    }

    protected boolean attack(class_1309 entity) {
        if (entity.method_5643(this.owner instanceof class_1309 ? this.method_48923().method_48800((class_1297)this, (class_1309)this.owner) : this.method_48923().method_48831(), (float)((Integer)this.method_5841().method_12789(DAMAGE)).intValue())) {
            this.method_5841().method_12778(USES, (Object)((Integer)this.method_5841().method_12789(USES) - 1));
            return true;
        }
        return false;
    }

    protected void updateMotion() {
        if (this.owner == null) {
            return;
        }
        class_243 center = this.owner.method_19538().method_1031(0.0, (double)this.owner.method_17682() * 0.33, 0.0);
        float radius = this.getRadius();
        float speed = this.getSpinSpeed();
        float offset = this.getSpinOffset();
        class_243 orbit = new class_243(center.field_1352 + Math.cos(speed + offset) * (double)radius, center.field_1351, center.field_1350 + Math.sin(speed + offset) * (double)radius);
        this.method_33574(orbit);
    }

    protected float getAttackRange() {
        return 2.0f;
    }

    protected float getDefaultRadius() {
        return 4.0f;
    }

    protected float getDefaultSpinSpeed() {
        return 0.06f;
    }

    protected float getSpinSpeed() {
        float speed = this.getDefaultSpinSpeed();
        class_1799 stack = (class_1799)this.method_5841().method_12789(RELATED_STACK);
        if (stack.method_7960()) {
            return (float)((Integer)this.method_5841().method_12789(SPIN)).intValue() * speed;
        }
        return (float)((Integer)this.method_5841().method_12789(SPIN)).intValue() * (speed * (1.0f + 0.25f * (float)class_1890.method_8225((class_1887)ObscureAPIEnchantments.FAST_SPIN, (class_1799)stack)));
    }

    protected float getRadius() {
        float radius = this.getDefaultRadius();
        class_1799 stack = (class_1799)this.method_5841().method_12789(RELATED_STACK);
        if (stack.method_7960()) {
            return radius;
        }
        return radius * (1.0f + 0.2f * (float)class_1890.method_8225((class_1887)ObscureAPIEnchantments.DISTANCE, (class_1799)stack));
    }

    protected float getSpinOffset() {
        return 6.315f * ((Float)this.method_5841().method_12789(OFFSET)).floatValue();
    }

    public boolean method_5643(class_1282 source, float amount) {
        if (!source.method_49708(class_8111.field_42347)) {
            return false;
        }
        return super.method_5643(source, amount);
    }

    public boolean method_5747(float l, float d, @NotNull class_1282 source) {
        return false;
    }

    public class_1306 method_6068() {
        return class_1306.field_6183;
    }

    public Iterable<class_1799> method_5661() {
        return new ArrayList<class_1799>();
    }

    public class_1799 method_6118(class_1304 slot) {
        return class_1799.field_8037;
    }

    public void method_5673(class_1304 slot, class_1799 stack) {
    }

    protected void method_5623(double y, boolean onGroundIn, @NotNull class_2680 state, @NotNull class_2338 pos) {
    }

    public void method_5875(boolean ignored) {
        super.method_5875(true);
    }

    public boolean method_30948() {
        return false;
    }

    public boolean method_5810() {
        return false;
    }

    public boolean method_5732() {
        return false;
    }

    public boolean method_5740() {
        return true;
    }

    public boolean method_5640(double d0) {
        double d1 = 100.0;
        return d0 < 10000.0;
    }
}

