/*
 * Decompiled with CFR 0.152.
 */
package com.obscuria.obscureapi.client.tooltips;

import com.google.common.collect.Multimap;
import com.obscuria.obscureapi.api.ClassRegistry;
import com.obscuria.obscureapi.api.Icons;
import com.obscuria.obscureapi.api.utils.ItemUtils;
import com.obscuria.obscureapi.api.utils.TextUtils;
import com.obscuria.obscureapi.client.tooltips.ModifiedTooltip;
import com.obscuria.obscureapi.client.tooltips.Tooltip;
import com.obscuria.obscureapi.common.classes.GameClassHelper;
import com.obscuria.obscureapi.common.classes.ability.Ability;
import com.obscuria.obscureapi.common.classes.bonus.Bonus;
import com.obscuria.obscureapi.registry.ObscureAPIEffects;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1291;
import net.minecraft.class_1304;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1738;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1831;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_5134;
import net.minecraft.class_7923;

public class TooltipBuilder {
    public static List<class_2561> buildTooltip(List<class_2561> list, class_1799 stack, class_1657 player) {
        if (player == null) {
            return list;
        }
        Modules.buildPerkNames(stack, list);
        Modules.putTooltip(stack, list, Tooltip.Type.BOTTOM);
        Modules.expandableTooltip(player, stack, list);
        Modules.buildKnowledge(player, stack, list);
        Modules.buildLore(stack, list);
        Modules.buildClass(stack, list);
        Modules.putTooltip(stack, list, Tooltip.Type.TOP);
        Modules.buildIcons(stack, list);
        return list;
    }

    public static class Modules {
        private static void buildIcons(class_1799 stack, List<class_2561> list) {
            if (stack.method_7909().method_19263()) {
                AttributeIcons.putFoodIcons(list, stack);
            }
            if (stack.method_7909() instanceof class_1831 || stack.method_7909() instanceof class_1738 || Modules.hasTooltip(stack.method_7909(), Tooltip.Type.ICONS_START) || Modules.hasTooltip(stack.method_7909(), Tooltip.Type.ICONS_END)) {
                AttributeIcons.putIcons(list, stack);
            }
        }

        private static void buildClass(class_1799 stack, List<class_2561> list) {
            if (GameClassHelper.hasClass(stack)) {
                list.add(1, (class_2561)TextUtils.component(Icons.STAR.get() + "\u00a76" + GameClassHelper.getClass(stack).orElse(ClassRegistry.BLANK).getLabel(GameClassHelper.getType(stack).orElse("null"))));
            }
        }

        private static void buildLore(class_1799 stack, List<class_2561> list) {
            if (Lore.contains(stack)) {
                list.addAll(1, TextUtils.buildLore(new ArrayList<class_2561>(), 34, TextUtils.translation(Lore.get(stack))));
            }
        }

        private static void buildKnowledge(class_1657 player, class_1799 stack, List<class_2561> list) {
            if (player.method_6059((class_1291)ObscureAPIEffects.KNOWLEDGE) && Knowledge.contains(stack)) {
                list.addAll(1, TextUtils.buildKnowledge(new ArrayList<class_2561>(), 30, TextUtils.translation(Knowledge.get(stack))));
            }
        }

        private static void expandableTooltip(class_1657 player, class_1799 stack, List<class_2561> list) {
            boolean abilities = GameClassHelper.hasVisibleAbilities(stack.method_7909());
            boolean bonuses = GameClassHelper.hasVisibleBonuses(stack);
            boolean perks = ItemUtils.hasPerks(stack);
            if (abilities || bonuses || perks || Modules.hasTooltip(stack.method_7909(), Tooltip.Type.EXPAND_TOP) || Modules.hasTooltip(stack.method_7909(), Tooltip.Type.EXPAND_BOTTOM)) {
                if (stack.method_7942() || ItemUtils.hasPerks(stack)) {
                    list.add(1, (class_2561)class_2561.method_43473());
                }
                if (class_437.method_25442()) {
                    Modules.putTooltip(stack, list, Tooltip.Type.EXPAND_BOTTOM);
                    if (perks) {
                        Modules.buildPerks(stack, list);
                    }
                    if (abilities) {
                        Modules.buildAbilities(stack, player, list);
                    }
                    if (bonuses) {
                        Modules.buildBonuses(stack.method_7909(), list);
                    }
                    Modules.putTooltip(stack, list, Tooltip.Type.EXPAND_TOP);
                    list.add(1, (class_2561)TextUtils.component(TextUtils.translation("obscure_api.tooltip.collapse")));
                } else {
                    list.add(1, (class_2561)TextUtils.component(TextUtils.translation("obscure_api.tooltip.expand")));
                }
            }
        }

        private static void buildAbilities(class_1799 stack, class_1657 player, List<class_2561> list) {
            for (Ability ability : GameClassHelper.getVisibleAbilities(stack.method_7909())) {
                list.addAll(1, TextUtils.buildAbility(new ArrayList<class_2561>(), 30, ability, player));
            }
        }

        private static void buildBonuses(class_1792 item, List<class_2561> list) {
            for (Bonus bonus : GameClassHelper.getVisibleBonuses(item)) {
                list.add(1, (class_2561)TextUtils.component(Icons.STICK.get() + " " + bonus.getBonusString()));
                list.add(1, (class_2561)TextUtils.component(TextUtils.translation("icon.stick") + TextUtils.translation("obscure_api.ability.bonuses")));
            }
        }

        private static void buildPerkNames(class_1799 stack, List<class_2561> list) {
            if (ItemUtils.hasPerks(stack)) {
                for (String perk : ItemUtils.getOrCreatePerks(stack).method_10541()) {
                    class_2960 registry = new class_2960(perk);
                    list.add(1, (class_2561)class_2561.method_43471((String)("perk." + registry.method_12836() + "." + registry.method_12832())).method_10862(class_2583.field_24360.method_27704(registry)));
                }
            }
        }

        private static void buildPerks(class_1799 stack, List<class_2561> list) {
            for (String perk : ItemUtils.getOrCreatePerks(stack).method_10541()) {
                list.addAll(1, TextUtils.buildPerk(new ArrayList<class_2561>(), 30, new class_2960(perk)));
            }
        }

        private static void putTooltip(class_1799 stack, List<class_2561> list, Tooltip.Type type) {
            if (!Modules.hasTooltip(stack.method_7909(), type)) {
                return;
            }
            for (Method method : stack.method_7909().getClass().getDeclaredMethods()) {
                if (!method.isAnnotationPresent(Tooltip.class) || !method.getAnnotation(Tooltip.class).type().equals((Object)type)) continue;
                try {
                    list.addAll(1, TextUtils.buildLore(new ArrayList<class_2561>(), method.getAnnotation(Tooltip.class).wight(), (String)method.invoke((Object)stack.method_7909(), stack, class_310.method_1551().field_1724), type.equals((Object)Tooltip.Type.EXPAND_TOP) || type.equals((Object)Tooltip.Type.EXPAND_BOTTOM) ? Icons.STICK.get() : ""));
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        private static String getLine(class_1799 stack, Tooltip.Type type) {
            StringBuilder tooltip = new StringBuilder();
            if (!Modules.hasTooltip(stack.method_7909(), type)) {
                return tooltip.toString();
            }
            for (Method method : stack.method_7909().getClass().getDeclaredMethods()) {
                if (!method.isAnnotationPresent(Tooltip.class) || !method.getAnnotation(Tooltip.class).type().equals((Object)type)) continue;
                try {
                    tooltip.append((String)method.invoke((Object)stack.method_7909(), stack, class_310.method_1551().field_1724));
                    tooltip.append(" ");
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
            return tooltip.toString();
        }

        private static boolean hasTooltip(class_1792 item, Tooltip.Type type) {
            if (!item.getClass().isAnnotationPresent(ModifiedTooltip.class)) {
                return false;
            }
            for (Method method : item.getClass().getDeclaredMethods()) {
                if (!method.isAnnotationPresent(Tooltip.class) || !method.getAnnotation(Tooltip.class).type().equals((Object)type)) continue;
                return true;
            }
            return false;
        }
    }

    private static class AttributeIcons {
        private AttributeIcons() {
        }

        private static void putIcons(List<class_2561> list, class_1799 stack) {
            Object icons = "";
            icons = (String)icons + Modules.getLine(stack, Tooltip.Type.ICONS_START);
            Multimap mainhandMap = stack.method_7926(class_1304.field_6173);
            Multimap headMap = stack.method_7926(class_1304.field_6169);
            Multimap chestMap = stack.method_7926(class_1304.field_6174);
            Multimap legsMap = stack.method_7926(class_1304.field_6172);
            Multimap feetMap = stack.method_7926(class_1304.field_6166);
            if (!mainhandMap.isEmpty()) {
                icons = (String)icons + AttributeIcons.getIcon(false, Icons.DAMAGE.get(), 1.0, mainhandMap.get((Object)class_5134.field_23721)) + AttributeIcons.getAttackSpeedIcon(mainhandMap.get((Object)class_5134.field_23723));
            }
            if (!headMap.isEmpty()) {
                icons = (String)icons + AttributeIcons.getIcon(false, Icons.ARMOR.get(), 0.0, headMap.get((Object)class_5134.field_23724)) + AttributeIcons.getIcon(false, Icons.ARMOR_TOUGHNESS.get(), 0.0, headMap.get((Object)class_5134.field_23725)) + AttributeIcons.getIcon(true, Icons.KNOCKBACK_RESISTANCE.get(), 0.0, headMap.get((Object)class_5134.field_23718));
            }
            if (!chestMap.isEmpty()) {
                icons = (String)icons + AttributeIcons.getIcon(false, Icons.ARMOR.get(), 0.0, chestMap.get((Object)class_5134.field_23724)) + AttributeIcons.getIcon(false, Icons.ARMOR_TOUGHNESS.get(), 0.0, chestMap.get((Object)class_5134.field_23725)) + AttributeIcons.getIcon(true, Icons.KNOCKBACK_RESISTANCE.get(), 0.0, chestMap.get((Object)class_5134.field_23718));
            }
            if (!legsMap.isEmpty()) {
                icons = (String)icons + AttributeIcons.getIcon(false, Icons.ARMOR.get(), 0.0, legsMap.get((Object)class_5134.field_23724)) + AttributeIcons.getIcon(false, Icons.ARMOR_TOUGHNESS.get(), 0.0, legsMap.get((Object)class_5134.field_23725)) + AttributeIcons.getIcon(true, Icons.KNOCKBACK_RESISTANCE.get(), 0.0, legsMap.get((Object)class_5134.field_23718));
            }
            if (!feetMap.isEmpty()) {
                icons = (String)icons + AttributeIcons.getIcon(false, Icons.ARMOR.get(), 0.0, feetMap.get((Object)class_5134.field_23724)) + AttributeIcons.getIcon(false, Icons.ARMOR_TOUGHNESS.get(), 0.0, feetMap.get((Object)class_5134.field_23725)) + AttributeIcons.getIcon(true, Icons.KNOCKBACK_RESISTANCE.get(), 0.0, feetMap.get((Object)class_5134.field_23718));
            }
            icons = (String)icons + AttributeIcons.getDurabilityIcon(stack);
            icons = (String)icons + Modules.getLine(stack, Tooltip.Type.ICONS_END);
            list.add(1, (class_2561)TextUtils.component((String)icons));
        }

        private static String getIcon(boolean percent, String icon, double base, Collection<class_1322> modifier) {
            if (modifier != null && !modifier.isEmpty()) {
                double modAmount = 0.0;
                double modPercent = 0.0;
                for (class_1322 attribute : modifier) {
                    if (attribute.method_6182() == class_1322.class_1323.field_6328) {
                        modAmount += attribute.method_6186();
                        continue;
                    }
                    if (attribute.method_6182() != class_1322.class_1323.field_6330) continue;
                    modPercent += attribute.method_6186();
                }
                if ((modAmount += base + modAmount * modPercent) == 0.0) {
                    return "";
                }
                if (percent) {
                    return icon + (modPercent > 0.0 ? "\u00a72" : "") + new DecimalFormat("##.#").format(modAmount * 100.0).replace(".0", "") + "% ";
                }
                return icon + (modPercent > 0.0 ? "\u00a72" : "") + new DecimalFormat("##.#").format(modAmount).replace(".0", "") + " ";
            }
            return "";
        }

        private static String getAttackSpeedIcon(Collection<class_1322> modifier) {
            if (modifier != null && !modifier.isEmpty()) {
                double modAmount = 0.0;
                double modPercent = 0.0;
                for (class_1322 attribute : modifier) {
                    if (attribute.method_6182() == class_1322.class_1323.field_6328) {
                        modAmount += attribute.method_6186();
                        continue;
                    }
                    if (attribute.method_6182() != class_1322.class_1323.field_6330) continue;
                    modPercent += attribute.method_6186();
                }
                if ((modAmount += 4.0 + modAmount * modPercent) <= 0.6) {
                    return Icons.ATTACK_SPEED_VERY_SLOW.get() + " ";
                }
                if (modAmount <= 1.0) {
                    return Icons.ATTACK_SPEED_SLOW.get() + " ";
                }
                if (modAmount <= 2.0) {
                    return Icons.ATTACK_SPEED_MEDIUM.get() + " ";
                }
                if (modAmount <= 3.0) {
                    return Icons.ATTACK_SPEED_FAST.get() + " ";
                }
                return Icons.ATTACK_SPEED_VERY_FAST.get() + " ";
            }
            return "";
        }

        private static String getDurabilityIcon(class_1799 stack) {
            if (stack.method_7936() > 0) {
                return Icons.DURABILITY.get() + (stack.method_7936() - stack.method_7919()) + "\u00a78/" + stack.method_7936() + "\u00a7f ";
            }
            return "";
        }

        private static void putFoodIcons(List<class_2561> list, class_1799 stack) {
            Object icons = "";
            if (Objects.requireNonNull(stack.method_7909().method_19264()).method_19230() > 0) {
                icons = (String)icons + Icons.FOOD.get() + stack.method_7909().method_19264().method_19230() + " ";
            }
            if (Objects.requireNonNull(stack.method_7909().method_19264()).method_19231() > 0.0f) {
                icons = (String)icons + Icons.FOOD_SATURATION.get() + (int)(Objects.requireNonNull(stack.method_7909().method_19264()).method_19231() * 100.0f) + "% ";
            }
            if (!((String)icons).equals("")) {
                list.add(1, (class_2561)TextUtils.component((String)icons));
            }
        }
    }

    public static class Knowledge {
        private static final HashMap<class_2960, String> KNOWLEDGE = new HashMap();

        public static void add(String modID, String itemID, String translationKey) {
            KNOWLEDGE.put(new class_2960(itemID), "knowledge." + modID + "." + translationKey);
        }

        public static boolean contains(class_1799 stack) {
            return KNOWLEDGE.containsKey(class_7923.field_41178.method_10221((Object)stack.method_7909()));
        }

        public static String get(class_1799 stack) {
            return KNOWLEDGE.get(class_7923.field_41178.method_10221((Object)stack.method_7909()));
        }
    }

    public static class Lore {
        private static final HashMap<class_2960, String> LORE = new HashMap();

        public static void add(String modID, String itemID, String translationKey) {
            LORE.put(new class_2960(itemID), "lore." + modID + "." + translationKey);
        }

        public static boolean contains(class_1799 stack) {
            return LORE.containsKey(class_7923.field_41178.method_10221((Object)stack.method_7909()));
        }

        public static String get(class_1799 stack) {
            return LORE.get(class_7923.field_41178.method_10221((Object)stack.method_7909()));
        }
    }
}

