/*
 * Decompiled with CFR 0.152.
 */
package com.obscuria.obscureapi.api.utils;

import com.obscuria.obscureapi.client.tooltips.TooltipBuilder;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public final class ItemUtils {
    public static void addLore(String itemID) {
        class_2960 registry = new class_2960(itemID);
        TooltipBuilder.Lore.add(registry.method_12836(), itemID, registry.method_12832());
    }

    public static void addLore(String itemID, String translationKey) {
        TooltipBuilder.Lore.add(new class_2960(itemID).method_12836(), itemID, translationKey);
    }

    public static void addLore(String modID, String itemID, String translationKey) {
        TooltipBuilder.Lore.add(modID, itemID, translationKey);
    }

    public static void addKnowledge(String itemID) {
        class_2960 registry = new class_2960(itemID);
        TooltipBuilder.Knowledge.add(registry.method_12836(), itemID, registry.method_12832());
    }

    public static void addKnowledge(String itemID, String translationKey) {
        TooltipBuilder.Knowledge.add(new class_2960(itemID).method_12836(), itemID, translationKey);
    }

    public static void addKnowledge(String modID, String itemID, String translationKey) {
        TooltipBuilder.Knowledge.add(modID, itemID, translationKey);
    }

    @SafeVarargs
    public static int countArmorPieces(class_1309 entity, Class<? extends class_1792> ... armors) {
        boolean HEAD = false;
        boolean CHEST = false;
        boolean LEGS = false;
        boolean FEET = false;
        for (Class<? extends class_1792> item : armors) {
            if (!ItemUtils.hasItemInSlot(entity, class_1304.field_6169, item)) continue;
            HEAD = true;
        }
        for (Class<? extends class_1792> item : armors) {
            if (!ItemUtils.hasItemInSlot(entity, class_1304.field_6174, item)) continue;
            CHEST = true;
        }
        for (Class<? extends class_1792> item : armors) {
            if (!ItemUtils.hasItemInSlot(entity, class_1304.field_6172, item)) continue;
            LEGS = true;
        }
        for (Class<? extends class_1792> item : armors) {
            if (!ItemUtils.hasItemInSlot(entity, class_1304.field_6166, item)) continue;
            FEET = true;
        }
        return (HEAD ? 1 : 0) + (CHEST ? 1 : 0) + (LEGS ? 1 : 0) + (FEET ? 1 : 0);
    }

    public static boolean hasItemInSlot(class_1309 entity, class_1304 slot, Class<? extends class_1792> item) {
        return item.isAssignableFrom(entity.method_6118(slot).method_7909().getClass());
    }

    @Nullable
    public static class_2487 getData(class_1799 stack) {
        return stack.method_7969() == null ? null : stack.method_7969().method_10562("ObscureData");
    }

    public static class_2487 getOrCreateData(class_1799 stack) {
        if (!stack.method_7948().method_10545("ObscureData")) {
            stack.method_7948().method_10566("ObscureData", (class_2520)new class_2487());
        }
        return stack.method_7948().method_10562("ObscureData");
    }

    @Nullable
    public static class_2487 getPerks(class_1799 stack) {
        class_2487 data = ItemUtils.getData(stack);
        return data == null ? null : data.method_10562("Perks");
    }

    public static class_2487 getOrCreatePerks(class_1799 stack) {
        if (!ItemUtils.getOrCreateData(stack).method_10545("Perks")) {
            ItemUtils.getOrCreateData(stack).method_10566("Perks", (class_2520)new class_2487());
        }
        return ItemUtils.getOrCreateData(stack).method_10562("Perks");
    }

    public static boolean hasPerks(class_1799 stack) {
        class_2487 perks = ItemUtils.getPerks(stack);
        return perks != null && !perks.method_33133();
    }

    public static boolean hasPerk(class_1799 stack, class_2960 perk) {
        class_2487 perks = ItemUtils.getPerks(stack);
        return perks != null && perks.method_10545(perk.toString());
    }

    public static boolean hasPerk(class_1799 stack, String perk) {
        class_2487 perks = ItemUtils.getPerks(stack);
        return perks != null && perks.method_10545(perk);
    }

    public static void addPerk(class_1799 stack, class_2960 perk, int level) {
        ItemUtils.getOrCreatePerks(stack).method_10569(perk.toString(), level);
    }

    public static void removePerk(class_1799 stack, class_2960 perk) {
        class_2487 perks = ItemUtils.getPerks(stack);
        if (perks != null && perks.method_10545(perk.toString())) {
            perks.method_10551(perk.toString());
        }
    }

    public static void removePerk(class_1799 stack, String perk) {
        class_2487 perks = ItemUtils.getPerks(stack);
        if (perks != null && perks.method_10545(perk)) {
            perks.method_10551(perk);
        }
    }
}

