/*
 * Decompiled with CFR 0.152.
 */
package moonfather.lilypads;

import moonfather.lilypads.PositionBlacklist;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2261;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.minecraft.class_4538;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7924;

public class SwampMath {
    private static final class_6862<class_2248> LANTERNS = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)new class_2960("c", "lanterns"));
    private static final class_6862<class_2248> TORCHES = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)new class_2960("c", "torches"));

    public static boolean tryMoveLilypadByBoat(class_2338 blockPos, class_1297 entity, class_1937 world, double distanceFactor, double angleDelta, class_2680 original) {
        double movement_angle;
        double angle = Math.atan2((double)blockPos.method_10260() + 0.5 - entity.method_23321(), (double)blockPos.method_10263() + 0.5 - entity.method_23317());
        if (Math.abs(angle + angleDelta - (movement_angle = ((double)entity.method_36454() + 90.0) * Math.PI / 180.0)) < 0.3490658503988659 || Math.abs(angle + angleDelta - movement_angle + Math.PI * 2) < 0.3490658503988659 || Math.abs(angle + angleDelta - movement_angle - Math.PI * 2) < 0.3490658503988659) {
            return false;
        }
        return SwampMath.tryMoveLilypadCore(blockPos, angle, world, distanceFactor, angleDelta, original);
    }

    public static boolean tryMoveLilypadByLanding(class_2338 blockPos, class_1297 entity, class_1937 world, double distanceFactor, double angleDelta, class_2680 original) {
        double angle = Math.atan2((double)blockPos.method_10260() + 0.5 - entity.method_23321(), (double)blockPos.method_10263() + 0.5 - entity.method_23317());
        return SwampMath.tryMoveLilypadCore(blockPos, angle, world, distanceFactor, angleDelta, original);
    }

    private static boolean tryMoveLilypadCore(class_2338 blockPos, double angle, class_1937 world, double distanceFactor, double angleDelta, class_2680 original) {
        class_2261 plant;
        class_2248 class_22482;
        class_2261 plant2;
        class_2248 class_22483;
        class_2338 targetPos = blockPos.method_10069((int)Math.round(Math.cos(angle + angleDelta) * (distanceFactor += SwampMath.getDistanceFactorAdjustment(angle, angleDelta))), 0, (int)Math.round(Math.sin(angle + angleDelta) * distanceFactor));
        class_2680 target = world.method_8320(targetPos);
        if (PositionBlacklist.isInBlacklist(world, targetPos) || !world.method_8477(targetPos)) {
            return false;
        }
        PositionBlacklist.put(world, targetPos);
        if (target.method_26215() && (class_22483 = original.method_26204()) instanceof class_2261 && (plant2 = (class_2261)class_22483).method_9558(original, (class_4538)world, targetPos)) {
            SwampMath.spawnParticles((class_3218)world, blockPos, angle + angleDelta);
            world.method_8652(blockPos, class_2246.field_10124.method_9564(), 3);
            world.method_8652(targetPos, original, 3);
            return true;
        }
        if (target.method_27852(class_2246.field_10382) && (class_22483 = original.method_26204()) instanceof class_2261 && (plant2 = (class_2261)class_22483).method_9558(original, (class_4538)world, targetPos) && world.method_8320(targetPos.method_10084()).method_26215()) {
            SwampMath.spawnParticles((class_3218)world, blockPos, angle + angleDelta);
            world.method_8652(targetPos, original, 3);
            class_2680 maybeCandle = world.method_8320(blockPos.method_10084());
            if (maybeCandle.method_26164(class_3481.field_26983) || maybeCandle.method_26164(TORCHES) || maybeCandle.method_26164(LANTERNS)) {
                world.method_8652(targetPos.method_10084(), maybeCandle, 3);
                world.method_8652(blockPos.method_10084(), class_2246.field_10124.method_9564(), 3);
            }
            world.method_8652(blockPos, class_2246.field_10382.method_9564(), 3);
            return true;
        }
        class_2338 above = targetPos.method_10084();
        if (target.method_27852(class_2246.field_10382) && (class_22482 = original.method_26204()) instanceof class_2261 && (plant = (class_2261)class_22482).method_9558(original, (class_4538)world, above) && world.method_8320(above).method_26215()) {
            SwampMath.spawnParticles((class_3218)world, blockPos.method_10084(), angle + angleDelta);
            class_2680 maybeCandle = world.method_8320(blockPos.method_10084());
            class_2586 be1 = world.method_8321(blockPos);
            class_2487 nbt = null;
            if (be1 != null) {
                nbt = be1.method_38243();
            }
            if (maybeCandle.method_26164(class_3481.field_26983) || maybeCandle.method_26164(TORCHES) || maybeCandle.method_26164(LANTERNS)) {
                world.method_8652(blockPos.method_10084(), class_2246.field_10589.method_9564(), 0);
            }
            world.method_8652(targetPos, original, 3);
            class_2586 be2 = world.method_8321(targetPos);
            if (be2 != null && nbt != null) {
                be2.method_11014(nbt);
            }
            world.method_8652(blockPos, class_2246.field_10382.method_9564(), 3);
            if (maybeCandle.method_26164(class_3481.field_26983) || maybeCandle.method_26164(TORCHES) || maybeCandle.method_26164(LANTERNS)) {
                world.method_8652(blockPos.method_10084(), class_2246.field_10124.method_9564(), 3);
                world.method_8652(targetPos.method_10084(), maybeCandle, 3);
            }
            return true;
        }
        return false;
    }

    private static double getDistanceFactorAdjustment(double angle, double angleDelta) {
        if (SwampMath.isDiagonal(angle) == SwampMath.isDiagonal(angleDelta)) {
            return 0.0;
        }
        return 0.42;
    }

    private static boolean isDiagonal(double angle) {
        return (int)Math.abs(Math.round((angle = angle / Math.PI * 180.0) / 45.0)) % 2 == 1;
    }

    private static void spawnParticles(class_3218 world, class_2338 blockPos, double angle) {
        world.method_14199((class_2394)class_2398.field_11244, (double)blockPos.method_10263() + 0.25, (double)blockPos.method_10264() + 0.01, (double)blockPos.method_10260() + 0.25, 0, Math.cos(angle) * 0.31, 0.0, Math.sin(angle) * 0.31, 0.25);
        world.method_14199((class_2394)class_2398.field_11244, (double)blockPos.method_10263() + 0.25, (double)blockPos.method_10264() + 0.01, (double)blockPos.method_10260() + 0.75, 0, Math.cos(angle) * 0.31, 0.0, Math.sin(angle) * 0.31, 0.25);
        world.method_14199((class_2394)class_2398.field_11244, (double)blockPos.method_10263() + 0.75, (double)blockPos.method_10264() + 0.01, (double)blockPos.method_10260() + 0.25, 0, Math.cos(angle) * 0.31, 0.0, Math.sin(angle) * 0.31, 0.25);
        world.method_14199((class_2394)class_2398.field_11244, (double)blockPos.method_10263() + 0.75, (double)blockPos.method_10264() + 0.01, (double)blockPos.method_10260() + 0.75, 0, Math.cos(angle) * 0.31, 0.0, Math.sin(angle) * 0.31, 0.25);
        world.method_14199((class_2394)class_2398.field_11244, (double)blockPos.method_10263() + 0.5, (double)blockPos.method_10264() + 0.01, (double)blockPos.method_10260() + 0.5, 0, Math.cos(angle) * 0.31, 0.0, Math.sin(angle) * 0.31, 0.25);
    }
}

