/*
 * Decompiled with CFR 0.152.
 */
package com.noxcrew.noxesium.mixin.component;

import com.google.common.collect.Iterables;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.noxcrew.noxesium.api.protocol.skull.SkullStringFormatter;
import com.noxcrew.noxesium.feature.skull.GameProfileFetcher;
import com.noxcrew.noxesium.feature.skull.SkullContents;
import java.lang.reflect.Type;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3518;
import net.minecraft.class_5250;
import net.minecraft.class_7417;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_2561.class_2562.class})
public abstract class ComponentSerializerMixin {
    @Shadow
    public abstract class_5250 method_10871(JsonElement var1, Type var2, JsonDeserializationContext var3) throws JsonParseException;

    @Shadow
    protected abstract void method_10875(class_2583 var1, JsonObject var2, JsonSerializationContext var3);

    @Shadow
    public abstract JsonElement serialize(Object var1, Type var2, JsonSerializationContext var3);

    @Inject(method={"deserialize(Lcom/google/gson/JsonElement;Ljava/lang/reflect/Type;Lcom/google/gson/JsonDeserializationContext;)Lnet/minecraft/network/chat/MutableComponent;"}, at={@At(value="HEAD")}, cancellable=true)
    private void injected(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext, CallbackInfoReturnable<class_5250> cir) {
        if (!jsonElement.isJsonObject()) {
            return;
        }
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        if (jsonObject.has("translate")) {
            String jsonString = class_3518.method_15265((JsonObject)jsonObject, (String)"translate");
            if (!jsonString.startsWith("%nox_uuid%") && !jsonString.startsWith("%nox_raw%")) {
                return;
            }
            SkullStringFormatter.SkullInfo info = SkullStringFormatter.parse((String)jsonString);
            try {
                UUID uuid = null;
                CompletableFuture<String> texture = new CompletableFuture<String>();
                if (info.raw()) {
                    texture.complete(info.value());
                } else {
                    String stringUuid = info.value();
                    try {
                        uuid = UUID.fromString(stringUuid);
                        GameProfile gameprofile = new GameProfile(uuid, null);
                        GameProfileFetcher.updateGameProfile(gameprofile, profile -> {
                            Property property = (Property)Iterables.getFirst((Iterable)profile.getProperties().get((Object)"textures"), null);
                            if (property != null) {
                                texture.complete(property.getValue());
                            }
                        });
                    }
                    catch (Exception gameprofile) {
                        // empty catch block
                    }
                }
                class_5250 mutableComponent = class_5250.method_43477((class_7417)new SkullContents(uuid, texture, info.grayscale(), info.advance(), info.ascent(), info.scale()));
                if (jsonObject.has("extra")) {
                    JsonArray jsonArray2 = class_3518.method_15261((JsonObject)jsonObject, (String)"extra");
                    if (jsonArray2.size() <= 0) {
                        throw new JsonParseException("Unexpected empty array of components");
                    }
                    for (int j = 0; j < jsonArray2.size(); ++j) {
                        mutableComponent.method_10852((class_2561)this.method_10871(jsonArray2.get(j), type, jsonDeserializationContext));
                    }
                }
                mutableComponent.method_10862((class_2583)jsonDeserializationContext.deserialize(jsonElement, class_2583.class));
                cir.setReturnValue((Object)mutableComponent);
            }
            catch (Exception uuid) {}
        } else if (jsonObject.has("skull")) {
            JsonObject jsonObject2 = class_3518.method_15296((JsonObject)jsonObject, (String)"skull");
            CompletableFuture<String> texture = new CompletableFuture<String>();
            UUID uuid = null;
            if (jsonObject2.has("texture")) {
                texture.complete(class_3518.method_15265((JsonObject)jsonObject2, (String)"texture"));
            } else {
                try {
                    uuid = UUID.fromString(class_3518.method_15265((JsonObject)jsonObject2, (String)"uuid"));
                    GameProfile gameprofile = new GameProfile(uuid, null);
                    GameProfileFetcher.updateGameProfile(gameprofile, profile -> {
                        Property property = (Property)Iterables.getFirst((Iterable)profile.getProperties().get((Object)"textures"), null);
                        if (property != null) {
                            texture.complete(property.getValue());
                        }
                    });
                }
                catch (Exception gameprofile) {
                    // empty catch block
                }
            }
            boolean grayscale = class_3518.method_15258((JsonObject)jsonObject, (String)"grayscale", (boolean)false);
            int advance = class_3518.method_15282((JsonObject)jsonObject2, (String)"advance", (int)0);
            int ascent = class_3518.method_15282((JsonObject)jsonObject2, (String)"ascent", (int)0);
            float scale = class_3518.method_15277((JsonObject)jsonObject2, (String)"scale", (float)1.0f);
            class_5250 mutableComponent = class_5250.method_43477((class_7417)new SkullContents(uuid, texture, grayscale, advance, ascent, scale));
            if (jsonObject.has("extra")) {
                JsonArray jsonArray2 = class_3518.method_15261((JsonObject)jsonObject, (String)"extra");
                if (jsonArray2.size() <= 0) {
                    throw new JsonParseException("Unexpected empty array of components");
                }
                for (int j = 0; j < jsonArray2.size(); ++j) {
                    mutableComponent.method_10852((class_2561)this.method_10871(jsonArray2.get(j), type, jsonDeserializationContext));
                }
            }
            mutableComponent.method_10862((class_2583)jsonDeserializationContext.deserialize(jsonElement, class_2583.class));
            cir.setReturnValue((Object)mutableComponent);
        }
    }

    @Inject(method={"serialize(Lnet/minecraft/network/chat/Component;Ljava/lang/reflect/Type;Lcom/google/gson/JsonSerializationContext;)Lcom/google/gson/JsonElement;"}, at={@At(value="HEAD")}, cancellable=true)
    private void injected(class_2561 component, Type type, JsonSerializationContext jsonSerializationContext, CallbackInfoReturnable<JsonElement> cir) {
        class_7417 componentContents = component.method_10851();
        if (componentContents instanceof SkullContents) {
            SkullContents contents = (SkullContents)componentContents;
            JsonObject jsonObject = new JsonObject();
            if (!component.method_10866().method_10967()) {
                this.method_10875(component.method_10866(), jsonObject, jsonSerializationContext);
            }
            if (!component.method_10855().isEmpty()) {
                JsonArray jsonArray = new JsonArray();
                for (class_2561 component2 : component.method_10855()) {
                    jsonArray.add(this.serialize(component2, (Type)((Object)class_2561.class), jsonSerializationContext));
                }
                jsonObject.add("extra", (JsonElement)jsonArray);
            }
            JsonObject jsonObject2 = new JsonObject();
            if (contents.getUuid() != null) {
                jsonObject2.addProperty("uuid", contents.getUuid().toString());
            } else {
                String texture = contents.getTexture();
                if (texture != null) {
                    jsonObject2.addProperty("texture", texture);
                }
            }
            jsonObject2.addProperty("grayscale", Boolean.valueOf(contents.isGrayscale()));
            jsonObject2.addProperty("advance", (Number)contents.getAdvance());
            jsonObject2.addProperty("ascent", (Number)contents.getAscent());
            jsonObject2.addProperty("scale", (Number)Float.valueOf(contents.getScale()));
            jsonObject.add("skull", (JsonElement)jsonObject2);
            cir.setReturnValue((Object)jsonObject);
        }
    }
}

