/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.mysticaloaktree.client.dialogues;

import net.mehvahdjukaar.mysticaloaktree.client.TreeLoreManager;
import net.mehvahdjukaar.mysticaloaktree.client.dialogues.ITreeDialogue;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_746;

public class DialogueInstance {
    private static final int TIME_PER_LINE = 51;
    private static final int WAIT_TIME = 40;
    private static final int MAX_DISTANCE_SQ = 36;
    private final ITreeDialogue dialogue;
    private int timeUntilNextLine = 0;
    private int lineIndex = 0;
    private boolean waiting = false;

    DialogueInstance(ITreeDialogue dialogue) {
        this.dialogue = dialogue;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean tick(class_2338 pos) {
        if (this.timeUntilNextLine != 0) {
            --this.timeUntilNextLine;
            return true;
        }
        if (this.waiting) {
            return true;
        }
        ITreeDialogue.Status status = this.dialogue.getLine(this.lineIndex, false);
        if (status == ITreeDialogue.Status.WAITING) {
            this.timeUntilNextLine = 40;
            this.waiting = true;
            return true;
        }
        if (status == ITreeDialogue.Status.DONE) {
            return false;
        }
        this.talk(status.text(), pos);
        return true;
    }

    public boolean interact(class_2338 pos) {
        ITreeDialogue.Status status;
        if (this.waiting && (status = this.dialogue.getLine(this.lineIndex, true)) != ITreeDialogue.Status.WAITING && status != ITreeDialogue.Status.DONE) {
            this.talk(status.text(), pos);
            return true;
        }
        return false;
    }

    private void talk(String text, class_2338 pos) {
        class_746 player = class_310.method_1551().field_1724;
        if (player != null && pos.method_19770((class_2374)player.method_19538()) < 36.0) {
            player.method_7353((class_2561)TreeLoreManager.formatText(text, (class_1657)player), true);
        }
        this.timeUntilNextLine = 51;
        ++this.lineIndex;
        this.waiting = false;
    }
}

