/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.mysticaloaktree.client;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.mysticaloaktree.MysticalOakTree;
import net.mehvahdjukaar.mysticaloaktree.client.BinarySearch;
import net.mehvahdjukaar.mysticaloaktree.client.dialogues.ITreeDialogue;
import net.mehvahdjukaar.mysticaloaktree.client.dialogues.TreeDialogueTypes;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_5250;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TreeLoreManager
extends class_4309 {
    private static final Gson GSON = new Gson();
    private static final Map<ITreeDialogue.Type<?>, List<ITreeDialogue>> DIALOGUES = new HashMap();
    private static final int MAX_SENTENCE_LEN = 80;
    private static final List<ITreeDialogue> RANDOM_WISDOM_QUOTES = Collections.synchronizedList(new ArrayList());
    private static final List<ITreeDialogue> RANDOM_FACTS = Collections.synchronizedList(new ArrayList());
    private static final List<String> PET_NAMES = Collections.synchronizedList(new ArrayList<String>(List.of("blorgle", "splorgle", "garvin", "pepa", "boris")));
    private static final List<String> ALL_COUNTRIES = new ArrayList<String>();
    private static ITreeDialogue TOMORROW_WEATHER = null;
    private static String IP = "***";
    private static double LAT = 0.0;
    private static double LON = 0.0;
    private static boolean HAS_BEEN_INIT = false;
    private static final ExecutorService EXECUTORS = Executors.newCachedThreadPool();
    private static final String API_NINJA_KEY = "Go6dGXfyi+63T+dZcWWV3Q==QbzSr5qgjyBR4ivM";
    private static final String IP_KEY = "$ip";
    private static final String PLAYER_NAME_KEY = "$player_name";
    private static final String RANDOM_POS_KEY = "$random_pos";
    private static final String RANDOM_DATE_KEY = "$random_date";
    private static final String RANDOM_NAME_KEY = "$random_name";
    private static final String RANDOM_COUNTRY_KEY = "$random_country";
    private static final int RANDOM_POS_DISTANCE = 1000;
    private static final String[] SEPARATORS = new String[]{"\n", "...", ".", "?", "!", ";", ","};

    public TreeLoreManager() {
        super(GSON, "tree_wisdom");
    }

    protected void apply(Map<class_2960, JsonElement> object, class_3300 resourceManager, class_3695 profiler) {
        DIALOGUES.clear();
        ArrayList list = new ArrayList();
        for (Map.Entry<class_2960, JsonElement> e : object.entrySet()) {
            JsonElement json = e.getValue();
            if (e.getKey().method_12832().equals("countries")) {
                ALL_COUNTRIES.clear();
                JsonArray arr = json.getAsJsonObject().get("countries").getAsJsonArray();
                arr.forEach(s -> ALL_COUNTRIES.add(s.getAsString()));
                continue;
            }
            JsonElement modLoaded = json.getAsJsonObject().get("mod_loaded");
            if (modLoaded != null && !PlatHelper.isModLoaded((String)modLoaded.getAsString())) continue;
            DataResult result = ITreeDialogue.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json);
            Optional o2 = result.resultOrPartial(error -> MysticalOakTree.LOGGER.error("Failed to read tree dialogue JSON object for {} : {}", e.getKey(), error));
            o2.ifPresent(list::add);
        }
        for (ITreeDialogue l : list) {
            DIALOGUES.computeIfAbsent(l.getType(), o -> new ArrayList()).add(l);
        }
        DIALOGUES.values().forEach(Collections::sort);
    }

    @Nullable
    public static ITreeDialogue getRandomDialogue(ITreeDialogue.Type<?> source, class_5819 random, int trust) {
        List<ITreeDialogue> dialogues;
        TreeLoreManager.initIfNeeded();
        if (source == TreeDialogueTypes.TALKED_TO) {
            if ((double)random.method_43057() < 0.04 && trust >= 40 && TOMORROW_WEATHER != null) {
                return TOMORROW_WEATHER;
            }
            if ((double)random.method_43057() < 0.05 && trust >= 100 && !RANDOM_FACTS.isEmpty()) {
                return TreeLoreManager.getRandomFact(random);
            }
            if (!RANDOM_WISDOM_QUOTES.isEmpty() && (double)random.method_43057() < 0.07 && trust >= 75) {
                return RANDOM_WISDOM_QUOTES.get(random.method_43048(RANDOM_WISDOM_QUOTES.size()));
            }
        }
        if ((dialogues = DIALOGUES.get(source)) != null) {
            int lowerBound;
            int upperBound = BinarySearch.find(dialogues, new ITreeDialogue.Dummy(trust)) + 1;
            int delta = trust - source.trustDelta();
            int n = lowerBound = delta <= 0 ? 0 : BinarySearch.find(dialogues, new ITreeDialogue.Dummy(delta));
            if (upperBound > lowerBound) {
                int i = random.method_39332(lowerBound, upperBound);
                return dialogues.get(Math.min(i, dialogues.size() - 1));
            }
        }
        return null;
    }

    public static void init() {
        TreeLoreManager.initIfNeeded();
    }

    private static void initIfNeeded() {
        if (!HAS_BEEN_INIT) {
            HAS_BEEN_INIT = true;
            EXECUTORS.submit(TreeLoreManager::addWordsOfWisdom);
            EXECUTORS.submit(TreeLoreManager::addFacts);
            EXECUTORS.submit(TreeLoreManager::addPetNames);
            EXECUTORS.submit(TreeLoreManager::addIP);
        }
    }

    private static void addWordsOfWisdom() {
        Pattern pattern = Pattern.compile("\\[(.+?)\\]");
        Pattern pattern2 = Pattern.compile("\"(.+?)\"");
        String response = TreeLoreManager.readFromURL("https://www.fantasynamegenerators.com/scripts/wisdomQuotes.js");
        Matcher m = pattern.matcher(response);
        while (m.find()) {
            Matcher m2 = pattern2.matcher(m.group(1));
            ArrayList<String> l = new ArrayList<String>();
            while (m2.find()) {
                String t = m2.group(1).replaceAll("\\(.*?\\)", "");
                if (t.length() > 80) {
                    l = null;
                    break;
                }
                l.add(t);
            }
            if (l == null) continue;
            RANDOM_WISDOM_QUOTES.add(new ITreeDialogue.Simple(l));
        }
    }

    private static void addIP() {
        try {
            IP = TreeLoreManager.readFromURL("http://checkip.amazonaws.com/").trim();
            EXECUTORS.submit(TreeLoreManager::addLocation);
        }
        catch (Exception e) {
            try (DatagramSocket socket = new DatagramSocket();){
                socket.connect(InetAddress.getByName("8.8.8.8"), 10002);
                IP = socket.getLocalAddress().getHostAddress();
            }
            catch (SocketException | UnknownHostException iOException) {
                // empty catch block
            }
        }
    }

    private static void addLocation() {
        String page = TreeLoreManager.readFromURL("https://api.api-ninjas.com/v1/iplookup?address=" + IP, true);
        JsonObject json = JsonParser.parseString((String)page).getAsJsonObject();
        LON = json.get("lon").getAsDouble();
        LAT = json.get("lat").getAsDouble();
        EXECUTORS.submit(TreeLoreManager::addWeatherReport);
    }

    private static void addWeatherReport() {
        String page = TreeLoreManager.readFromURL(" http://api.weatherunlocked.com/api/forecast/" + LAT + "," + LON + "?app_id=9fb6970a&app_key=f02776b40a5c83cafbb7d072263252a5");
        JsonArray json = JsonParser.parseString((String)page).getAsJsonObject().get("Days").getAsJsonArray();
        JsonArray tomorrow = json.get(1).getAsJsonObject().get("Timeframes").getAsJsonArray();
        HashMultiset desc = HashMultiset.create();
        for (JsonElement v : tomorrow) {
            desc.add((Object)v.getAsJsonObject().get("wx_desc").getAsString());
        }
        String weather = desc.stream().max(Comparator.comparingInt(arg_0 -> ((Multiset)desc).count(arg_0))).get();
        TOMORROW_WEATHER = new ITreeDialogue.Simple(List.of("I can feel it in the air, tomorrow will be " + weather));
    }

    private static void addFacts() {
        String page = TreeLoreManager.readFromURL("https://api.api-ninjas.com/v1/facts?limit=20", true);
        JsonElement json = JsonParser.parseString((String)page);
        JsonArray array = json.getAsJsonArray();
        for (JsonElement a : array) {
            String fact = a.getAsJsonObject().get("fact").getAsString();
            List<String> processed = TreeLoreManager.splitSentenceToLen(fact, "");
            if (processed.isEmpty()) continue;
            RANDOM_FACTS.add(new ITreeDialogue.Simple(processed));
        }
    }

    private static void addPetNames() {
        String page = TreeLoreManager.readFromURL("https://api.api-ninjas.com/v1/babynames?limit=10", true);
        JsonElement json = JsonParser.parseString((String)page);
        JsonArray array = json.getAsJsonArray();
        for (JsonElement a : array) {
            String name = a.getAsString();
            PET_NAMES.add(name);
        }
    }

    private static String readFromURL(String link) {
        return TreeLoreManager.readFromURL(link, false);
    }

    private static String readFromURL(String link, boolean apiNinja) {
        StringBuilder content = new StringBuilder();
        try {
            String encoding;
            URL url = new URL(link);
            URLConnection connection = url.openConnection();
            if (apiNinja) {
                connection.setRequestProperty("accept", "application/json");
                connection.addRequestProperty("X-Api-Key", API_NINJA_KEY);
            }
            Charset charset = (encoding = connection.getContentEncoding()) == null ? StandardCharsets.UTF_8 : Charset.forName(encoding);
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), charset));){
                String line;
                while ((line = reader.readLine()) != null) {
                    content.append(line + "\n");
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return content.toString();
    }

    @Nullable
    private static ITreeDialogue getRandomFact(class_5819 randomSource) {
        if (RANDOM_FACTS.isEmpty()) {
            return null;
        }
        ITreeDialogue d = RANDOM_FACTS.remove(randomSource.method_43048(RANDOM_FACTS.size()));
        if (RANDOM_FACTS.isEmpty()) {
            EXECUTORS.submit(TreeLoreManager::addFacts);
        }
        return d;
    }

    @NotNull
    public static class_5250 formatText(String text, class_1657 player) {
        if (text.contains("$")) {
            if (text.contains(IP_KEY)) {
                text = text.replace(IP_KEY, IP);
            }
            if (text.contains(PLAYER_NAME_KEY)) {
                text = text.replace(PLAYER_NAME_KEY, player.method_5476().getString());
            }
            class_5819 random = player.method_37908().field_9229;
            if (text.contains(RANDOM_POS_KEY)) {
                text = text.replace(RANDOM_POS_KEY, TreeLoreManager.generateRandomPos(player.method_24515(), random));
            }
            if (text.contains(RANDOM_DATE_KEY)) {
                text = text.replace(RANDOM_DATE_KEY, TreeLoreManager.generateRandomDate(random));
            }
            if (text.contains(RANDOM_NAME_KEY)) {
                text = text.replace(RANDOM_NAME_KEY, TreeLoreManager.getRandomName(random));
            }
            if (text.contains(RANDOM_COUNTRY_KEY)) {
                text = text.replace(RANDOM_COUNTRY_KEY, TreeLoreManager.getRandomCountry(random));
            }
        }
        return class_2561.method_43471((String)text);
    }

    private static String getRandomCountry(class_5819 random) {
        return ALL_COUNTRIES.get(random.method_43048(ALL_COUNTRIES.size()));
    }

    private static String getRandomName(class_5819 random) {
        String[] l = new String[]{"Blorg"};
        return l[random.method_43048(l.length)];
    }

    private static String generateRandomDate(class_5819 randomSource) {
        Calendar c = Calendar.getInstance();
        long startMillis = c.getTime().getTime();
        c.set(4000, 0, 0);
        long endMillis = c.getTime().getTime();
        Random random = new Random(randomSource.method_43054());
        long dateMillis = random.nextLong(startMillis, endMillis);
        Date date = new Date(dateMillis);
        c.setTime(date);
        Locale locale = Locale.forLanguageTag(class_310.method_1551().method_1526().method_4669().replace("_", "-"));
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd MMMM yyy", locale);
        return dateFormat.format(date);
    }

    private static String generateRandomPos(class_2338 pos, class_5819 randomSource) {
        class_2338 newPos = pos.method_10069(randomSource.method_39332(-1000, 1000), randomSource.method_39332(-64, 64), randomSource.method_39332(-1000, 1000));
        return "X = " + newPos.method_10263() + ", Y = " + newPos.method_10264() + ", Z = " + newPos.method_10260();
    }

    private static List<String> splitSentenceToLen(String text) {
        return TreeLoreManager.splitSentenceToLen(text, "");
    }

    private static List<String> splitSentenceToLen(String text, String start) {
        ArrayList<String> list = new ArrayList<String>();
        int len = 80 - start.length();
        while (text.length() > len) {
            String max = text.substring(0, len);
            boolean split = false;
            for (String sep : SEPARATORS) {
                int index = max.lastIndexOf(sep);
                if (index == -1) continue;
                Object cut = text.substring(0, index);
                text = text.substring(index);
                if (list.isEmpty()) {
                    cut = start + (String)cut;
                }
                list.add((String)cut);
                split = true;
                break;
            }
            if (split) continue;
            return Collections.emptyList();
        }
        return list;
    }
}

