/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.addons.feature.locator.patterns;

import com.dfsek.terra.addons.feature.locator.lib.jafama.FastMath;
import com.dfsek.terra.addons.feature.locator.patterns.Pattern;
import com.dfsek.terra.api.block.state.BlockState;
import com.dfsek.terra.api.util.Range;
import com.dfsek.terra.api.world.WritableWorld;
import com.dfsek.terra.api.world.chunk.generation.util.Column;
import java.util.function.Predicate;

public class MatchPattern
implements Pattern {
    private final Range range;
    private final Predicate<BlockState> matches;

    public MatchPattern(Range range, Predicate<BlockState> matches) {
        this.range = range;
        this.matches = matches;
    }

    @Override
    public boolean matches(int y, Column<?> column) {
        int min = FastMath.max(column.getMinY(), this.range.getMin() + y);
        int max = FastMath.min(column.getMaxY(), this.range.getMax() + y);
        if (max <= min) {
            return false;
        }
        for (int i = min; i < max; ++i) {
            if (this.matches.test(column.getBlock(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean matches(WritableWorld world, int x, int y, int z) {
        int min = FastMath.max(world.getMinHeight(), this.range.getMin() + y);
        int max = FastMath.min(world.getMaxHeight(), this.range.getMax() + y);
        if (max <= min) {
            return false;
        }
        for (int i = min; i < max; ++i) {
            if (this.matches.test(world.getBlockState(x, i, z))) continue;
            return false;
        }
        return true;
    }
}

