/*
 * Decompiled with CFR 0.152.
 */
package com.github.thedeathlycow.thermoo.api.util;

import java.util.function.DoubleUnaryOperator;
import net.minecraft.class_3542;

public enum TemperatureUnit implements class_3542
{
    CELSIUS("C", celsiusValue -> celsiusValue, celsiusValue -> celsiusValue),
    KELVIN("K", kelvinValue -> kelvinValue - 273.15, celsiusValue -> celsiusValue + 273.15),
    FAHRENHEIT("F", fahrenheitValue -> (fahrenheitValue - 32.0) * 5.0 / 9.0, celsiusValue -> 1.8 * celsiusValue + 32.0),
    RANKINE("R", rankineValue -> FAHRENHEIT.toCelsius(rankineValue - 459.67), celsiusValue -> FAHRENHEIT.fromCelsius(celsiusValue) + 459.67);

    private final String unitSymbol;
    private final DoubleUnaryOperator toCelsius;
    private final DoubleUnaryOperator fromCelsius;

    private TemperatureUnit(String unitSymbol, DoubleUnaryOperator toCelsius, DoubleUnaryOperator fromCelsius) {
        this.unitSymbol = unitSymbol;
        this.toCelsius = toCelsius;
        this.fromCelsius = fromCelsius;
    }

    public String getUnitSymbol() {
        return this.unitSymbol;
    }

    public double toCelsius(double value) {
        return this.toCelsius.applyAsDouble(value);
    }

    public double fromCelsius(double celsiusValue) {
        return this.fromCelsius.applyAsDouble(celsiusValue);
    }

    public double convertTemperature(double inputValue, TemperatureUnit inputUnit) {
        if (this == inputUnit) {
            return inputValue;
        }
        double inputCelsius = inputUnit.toCelsius(inputValue);
        return this.fromCelsius(inputCelsius);
    }

    public String method_15434() {
        return this.toString().toLowerCase();
    }
}

