/*
 * Decompiled with CFR 0.152.
 */
package com.github.thedeathlycow.thermoo.api.predicate;

import com.github.thedeathlycow.thermoo.api.temperature.TemperatureAware;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import net.minecraft.class_2096;
import net.minecraft.class_3518;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public class TemperaturePredicate {
    public static final TemperaturePredicate ANY = new TemperaturePredicate(class_2096.class_2099.field_9705, class_2096.class_2100.field_9708);
    private final class_2096.class_2099 scaleRange;
    private final class_2096.class_2100 temperatureRange;

    public TemperaturePredicate(class_2096.class_2099 scaleRange, class_2096.class_2100 temperatureRange) {
        this.scaleRange = scaleRange;
        this.temperatureRange = temperatureRange;
    }

    public boolean test(TemperatureAware tempAware) {
        if (this == ANY) {
            return true;
        }
        float scale = tempAware.thermoo$getTemperatureScale();
        int temp = tempAware.thermoo$getTemperature();
        return this.scaleRange.method_9047((double)scale) && this.temperatureRange.method_9054(temp);
    }

    public JsonElement toJson() {
        if (this == ANY) {
            return JsonNull.INSTANCE;
        }
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("scale", this.scaleRange.method_9036());
        jsonObject.add("temperature", this.temperatureRange.method_9036());
        return jsonObject;
    }

    @Contract(value="!null->new")
    public static TemperaturePredicate fromJson(@Nullable JsonElement json) {
        if (json == null || json.isJsonNull()) {
            return ANY;
        }
        JsonObject jsonObject = class_3518.method_15295((JsonElement)json, (String)"thermoo.temperature");
        class_2096.class_2099 scaleRange = class_2096.class_2099.field_9705;
        class_2096.class_2100 tempRange = class_2096.class_2100.field_9708;
        if (jsonObject.has("scale")) {
            scaleRange = class_2096.class_2099.method_9051((JsonElement)jsonObject.get("scale"));
        }
        if (jsonObject.has("temperature")) {
            tempRange = class_2096.class_2100.method_9056((JsonElement)jsonObject.get("temperature"));
        }
        return new TemperaturePredicate(scaleRange, tempRange);
    }

    public static class Builder {
        private class_2096.class_2099 scale = class_2096.class_2099.field_9705;
        private class_2096.class_2100 temperature = class_2096.class_2100.field_9708;

        public static Builder create() {
            return new Builder();
        }

        public Builder scale(class_2096.class_2099 scale) {
            this.scale = scale;
            return this;
        }

        public Builder temperature(class_2096.class_2100 temperature) {
            this.temperature = temperature;
            return this;
        }

        public TemperaturePredicate build() {
            return new TemperaturePredicate(this.scale, this.temperature);
        }
    }
}

