/*
 * Decompiled with CFR 0.152.
 */
package com.github.thedeathlycow.thermoo.api.command;

import com.github.thedeathlycow.thermoo.api.command.HeatingModeArgumentType;
import com.github.thedeathlycow.thermoo.api.temperature.HeatingModes;
import com.github.thedeathlycow.thermoo.api.temperature.TemperatureAware;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Collection;
import java.util.function.Supplier;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3532;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Contract;

public class TemperatureCommand {
    private static final SimpleCommandExceptionType NOT_LIVING_ENTITY = new SimpleCommandExceptionType((Message)class_2561.method_48321((String)"commands.thermoo.temperature.exception.not_living_entity", (String)"Target is not a living entity!"));
    public static final Supplier<LiteralArgumentBuilder<class_2168>> COMMAND_BUILDER = TemperatureCommand::buildCommand;

    @Contract(value="->new")
    private static LiteralArgumentBuilder<class_2168> buildCommand() {
        LiteralArgumentBuilder getSubCommand = (LiteralArgumentBuilder)class_2170.method_9247((String)"get").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9309()).executes(context -> TemperatureCommand.runGetCurrent((class_2168)context.getSource(), class_2186.method_9313((CommandContext)context, (String)"target")))).then(class_2170.method_9247((String)"current").executes(context -> TemperatureCommand.runGetCurrent((class_2168)context.getSource(), class_2186.method_9313((CommandContext)context, (String)"target"))))).then(class_2170.method_9247((String)"max").executes(context -> TemperatureCommand.runGetMax((class_2168)context.getSource(), class_2186.method_9313((CommandContext)context, (String)"target"))))).then(class_2170.method_9247((String)"min").executes(context -> TemperatureCommand.runGetMin((class_2168)context.getSource(), class_2186.method_9313((CommandContext)context, (String)"target"))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"scale").executes(context -> TemperatureCommand.runGetScale((class_2168)context.getSource(), class_2186.method_9313((CommandContext)context, (String)"target"), 100))).then(class_2170.method_9244((String)"scale", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> TemperatureCommand.runGetScale((class_2168)context.getSource(), class_2186.method_9313((CommandContext)context, (String)"target"), IntegerArgumentType.getInteger((CommandContext)context, (String)"scale"))))));
        LiteralArgumentBuilder remove = (LiteralArgumentBuilder)class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9306()).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> TemperatureCommand.runAdjust((class_2168)context.getSource(), class_2186.method_9317((CommandContext)context, (String)"targets"), IntegerArgumentType.getInteger((CommandContext)context, (String)"amount"), HeatingModes.ABSOLUTE, true))).then(class_2170.method_9244((String)"mode", (ArgumentType)HeatingModeArgumentType.heatingMode()).executes(context -> TemperatureCommand.runAdjust((class_2168)context.getSource(), class_2186.method_9317((CommandContext)context, (String)"targets"), IntegerArgumentType.getInteger((CommandContext)context, (String)"amount"), HeatingModeArgumentType.getHeatingMode((CommandContext<class_2168>)context, "mode"), true)))));
        LiteralArgumentBuilder add = (LiteralArgumentBuilder)class_2170.method_9247((String)"add").then(class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9306()).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> TemperatureCommand.runAdjust((class_2168)context.getSource(), class_2186.method_9317((CommandContext)context, (String)"targets"), IntegerArgumentType.getInteger((CommandContext)context, (String)"amount"), HeatingModes.ABSOLUTE, false))).then(class_2170.method_9244((String)"mode", (ArgumentType)HeatingModeArgumentType.heatingMode()).executes(context -> TemperatureCommand.runAdjust((class_2168)context.getSource(), class_2186.method_9317((CommandContext)context, (String)"targets"), IntegerArgumentType.getInteger((CommandContext)context, (String)"amount"), HeatingModeArgumentType.getHeatingMode((CommandContext<class_2168>)context, "mode"), false)))));
        LiteralArgumentBuilder setSubCommand = (LiteralArgumentBuilder)class_2170.method_9247((String)"set").then(class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9306()).then(class_2170.method_9244((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(context -> TemperatureCommand.runSet((class_2168)context.getSource(), class_2186.method_9317((CommandContext)context, (String)"targets"), IntegerArgumentType.getInteger((CommandContext)context, (String)"amount")))));
        return (LiteralArgumentBuilder)class_2170.method_9247((String)"thermoo").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"temperature").requires(src -> src.method_9259(2))).then((ArgumentBuilder)getSubCommand)).then((ArgumentBuilder)remove)).then((ArgumentBuilder)add)).then((ArgumentBuilder)setSubCommand));
    }

    private static int runGetScale(class_2168 source, class_1297 target, int scale) throws CommandSyntaxException {
        if (target instanceof class_1309) {
            class_1309 livingEntity = (class_1309)target;
            float progress = livingEntity.thermoo$getTemperatureScale();
            int result = class_3532.method_15375((float)(progress * (float)scale));
            source.method_9226(() -> class_2561.method_43469((String)"commands.thermoo.temperature.get.scale.success", (Object[])new Object[]{target.method_5476(), result}), false);
            return result;
        }
        throw NOT_LIVING_ENTITY.create();
    }

    private static int runGetMax(class_2168 source, class_1297 target) throws CommandSyntaxException {
        if (target instanceof class_1309) {
            class_1309 livingEntity = (class_1309)target;
            int amount = livingEntity.thermoo$getMaxTemperature();
            source.method_9226(() -> class_2561.method_43469((String)"commands.thermoo.temperature.get.max.success", (Object[])new Object[]{target.method_5476(), amount}), false);
            return amount;
        }
        throw NOT_LIVING_ENTITY.create();
    }

    private static int runGetMin(class_2168 source, class_1297 target) throws CommandSyntaxException {
        if (target instanceof class_1309) {
            class_1309 livingEntity = (class_1309)target;
            int amount = livingEntity.thermoo$getMinTemperature();
            source.method_9226(() -> class_2561.method_48322((String)"commands.thermoo.temperature.get.min.success", (String)"%s can have a minimum temperature of %d", (Object[])new Object[]{target.method_5476(), amount}), false);
            return amount;
        }
        throw NOT_LIVING_ENTITY.create();
    }

    private static int runGetCurrent(class_2168 source, class_1297 target) throws CommandSyntaxException {
        if (target instanceof class_1309) {
            class_1309 livingEntity = (class_1309)target;
            int amount = livingEntity.thermoo$getTemperature();
            source.method_9226(() -> class_2561.method_48322((String)"commands.thermoo.temperature.get.current.success", (String)"The current temperature of %s is %d", (Object[])new Object[]{target.method_5476(), amount}), false);
            return amount;
        }
        throw NOT_LIVING_ENTITY.create();
    }

    private static int runAdjust(class_2168 source, Collection<? extends class_1297> targets, int amount, HeatingModes mode, boolean isRemoving) throws CommandSyntaxException {
        class_5250 msg;
        amount = isRemoving ? -amount : amount;
        int sum = 0;
        for (class_1297 class_12972 : targets) {
            if (class_12972 instanceof TemperatureAware) {
                TemperatureAware temperatureAware = (TemperatureAware)class_12972;
                temperatureAware.thermoo$addTemperature(amount, mode);
                sum += amount;
                continue;
            }
            if (targets.size() != 1) continue;
            throw NOT_LIVING_ENTITY.create();
        }
        if (isRemoving) {
            if (targets.size() == 1) {
                class_1297 class_12973 = targets.iterator().next();
                msg = class_2561.method_48322((String)"commands.thermoo.temperature.remove.success.single", (String)"Removed %d temperature from %s (now %d)", (Object[])new Object[]{amount, class_12973.method_5477(), ((TemperatureAware)class_12973).thermoo$getTemperature()});
            } else {
                msg = class_2561.method_48322((String)"commands.thermoo.temperature.remove.success.multiple", (String)"Removed %d temperature from %d entities", (Object[])new Object[]{amount, targets.size()});
            }
        } else if (targets.size() == 1) {
            class_1297 class_12974 = targets.iterator().next();
            msg = class_2561.method_48322((String)"commands.thermoo.temperature.add.success.single", (String)"Added %d temperature to %s (now %d)", (Object[])new Object[]{amount, class_12974.method_5477(), ((TemperatureAware)class_12974).thermoo$getTemperature()});
        } else {
            msg = class_2561.method_48322((String)"commands.thermoo.temperature.add.success.multiple", (String)"Added %d temperature to %d entities", (Object[])new Object[]{amount, targets.size()});
        }
        source.method_9226(() -> TemperatureCommand.lambda$runAdjust$16((class_2561)msg), true);
        return sum;
    }

    private static int runSet(class_2168 source, Collection<? extends class_1297> targets, int amount) throws CommandSyntaxException {
        int sum = 0;
        for (class_1297 class_12972 : targets) {
            if (class_12972 instanceof class_1309) {
                class_1309 livingEntity = (class_1309)class_12972;
                livingEntity.thermoo$setTemperature(amount);
                sum += amount;
                continue;
            }
            if (targets.size() != 1) continue;
            throw NOT_LIVING_ENTITY.create();
        }
        class_5250 msg = targets.size() == 1 ? class_2561.method_48322((String)"commands.thermoo.temperature.set.success.single", (String)"Set the temperature of %s to %d", (Object[])new Object[]{targets.iterator().next().method_5477(), amount}) : class_2561.method_48322((String)"commands.thermoo.temperature.set.success.multiple", (String)"Set the temperature of %s entities to %d", (Object[])new Object[]{targets.size(), amount});
        source.method_9226(() -> TemperatureCommand.lambda$runSet$17((class_2561)msg), true);
        return sum;
    }

    private static /* synthetic */ class_2561 lambda$runSet$17(class_2561 msg) {
        return msg;
    }

    private static /* synthetic */ class_2561 lambda$runAdjust$16(class_2561 msg) {
        return msg;
    }
}

