/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.spawn.block;

import com.ninni.spawn.SpawnProperties;
import com.ninni.spawn.SpawnTags;
import com.ninni.spawn.registry.SpawnCriteriaTriggers;
import com.ninni.spawn.registry.SpawnEntityType;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3726;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class MucusBlockBlock
extends class_2248 {
    private static final class_2758 DISTANCE = class_2741.field_12541;
    public static final class_2746 SOLID = SpawnProperties.SOLID;
    protected static final class_265 SHAPE = class_2248.method_9541((double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)10.0, (double)15.0);

    public MucusBlockBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)this.method_9564().method_11657((class_2769)SOLID, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)DISTANCE, (Comparable)Integer.valueOf(7)));
    }

    @Nullable
    public class_2680 method_9605(class_1750 ctx) {
        return MucusBlockBlock.updateDistanceFromWater(this.method_9564(), ctx.method_8045(), ctx.method_8037());
    }

    public class_2680 method_9559(class_2680 blockState, class_2350 direction, class_2680 blockState2, class_1936 levelAccessor, class_2338 blockPos, class_2338 blockPos2) {
        int i = MucusBlockBlock.getDistanceFromWater(blockState2) + 1;
        if (i != 1 || (Integer)blockState.method_11654((class_2769)DISTANCE) != i) {
            levelAccessor.method_39279(blockPos, (class_2248)this, 2);
        }
        return blockState;
    }

    public void method_9588(class_2680 blockState, class_3218 serverLevel, class_2338 blockPos, class_5819 randomSource) {
        serverLevel.method_8652(blockPos, MucusBlockBlock.updateDistanceFromWater(blockState, (class_1937)serverLevel, blockPos), 3);
    }

    private static class_2680 updateDistanceFromWater(class_2680 state, class_1937 world, class_2338 pos) {
        int i = 7;
        class_2338.class_2339 mutable = new class_2338.class_2339();
        for (class_2350 direction : class_2350.values()) {
            mutable.method_25505((class_2382)pos, direction);
            i = Math.min(i, MucusBlockBlock.getDistanceFromWater(world.method_8320((class_2338)mutable)) + 1);
            if (i == 1) break;
        }
        world.method_8396(null, pos, world.method_8320(pos).method_26204().method_9573(state).method_10595(), class_3419.field_15245, 0.15f, 1.5f);
        return (class_2680)((class_2680)state.method_11657((class_2769)DISTANCE, (Comparable)Integer.valueOf(i))).method_11657((class_2769)SOLID, (Comparable)Boolean.valueOf(i < 7));
    }

    public static int getDistanceFromWater(class_2680 state) {
        if (state.method_26164(SpawnTags.MUCUS_SOLIDIFIER)) {
            return 0;
        }
        if (state.method_26164(SpawnTags.MUCUS_SOLIDIFICATION_SPREADER)) {
            return (Integer)state.method_11654((class_2769)DISTANCE);
        }
        return 7;
    }

    public void method_9548(class_2680 blockState, class_1937 level, class_2338 blockPos, class_1297 entity) {
        if (!(entity instanceof class_1309) || entity.method_5864() == SpawnEntityType.SNAIL || entity.method_5864() == class_1299.field_20346) {
            return;
        }
        if (entity instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)entity;
            SpawnCriteriaTriggers.GOT_STUCK_IN_MUCUS.trigger(serverPlayer);
        }
        entity.method_5844(blockState, new class_243(0.5, 0.5, 0.5));
    }

    public class_265 method_9549(class_2680 blockState, class_1922 blockGetter, class_2338 blockPos, class_3726 collisionContext) {
        return (Boolean)blockState.method_11654((class_2769)SOLID) != false ? class_259.method_1077() : SHAPE;
    }

    public class_265 method_9530(class_2680 blockState, class_1922 blockGetter, class_2338 blockPos, class_3726 collisionContext) {
        return class_259.method_1077();
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{SOLID, DISTANCE});
    }
}

