/*
 * Decompiled with CFR 0.152.
 */
package terrablender.api;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_6686;
import terrablender.worldgen.TBSurfaceRuleData;
import terrablender.worldgen.surface.NamespacedSurfaceRuleSource;

public class SurfaceRuleManager {
    private static Map<RuleCategory, Map<String, class_6686.class_6708>> surfaceRules = Maps.newHashMap();
    private static Map<RuleCategory, class_6686.class_6708> defaultSurfaceRules = Maps.newHashMap();
    private static Map<RuleCategory, Map<RuleStage, List<Pair<Integer, class_6686.class_6708>>>> defaultSurfaceRuleInjections = Maps.newHashMap();

    public static void addSurfaceRules(RuleCategory category, String namespace, class_6686.class_6708 rules) {
        surfaceRules.get((Object)category).put(namespace, rules);
    }

    public static void addToDefaultSurfaceRulesAtStage(RuleCategory category, RuleStage ruleStage, int priority, class_6686.class_6708 rules) {
        defaultSurfaceRuleInjections.get((Object)category).get((Object)ruleStage).add((Pair<Integer, class_6686.class_6708>)Pair.of((Object)priority, (Object)rules));
    }

    public static void setDefaultSurfaceRules(RuleCategory category, class_6686.class_6708 rules) {
        defaultSurfaceRules.put(category, rules);
    }

    public static void removeSurfaceRules(RuleCategory category, String namespace) {
        surfaceRules.get((Object)category).remove(namespace);
    }

    public static class_6686.class_6708 getNamespacedRules(RuleCategory category, class_6686.class_6708 fallback) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)"minecraft", (Object)SurfaceRuleManager.getDefaultSurfaceRules(category));
        builder.putAll(surfaceRules.get((Object)category));
        return new NamespacedSurfaceRuleSource(fallback, (Map<String, class_6686.class_6708>)builder.build());
    }

    public static List<class_6686.class_6708> getDefaultSurfaceRuleAdditionsForStage(RuleCategory category, RuleStage ruleStage) {
        return (List)defaultSurfaceRuleInjections.get((Object)category).get((Object)ruleStage).stream().sorted(Comparator.comparing(Pair::getFirst, Comparator.reverseOrder())).map(Pair::getSecond).collect(ImmutableList.toImmutableList());
    }

    public static class_6686.class_6708 getDefaultSurfaceRules(RuleCategory category) {
        if (defaultSurfaceRules.containsKey((Object)category)) {
            return defaultSurfaceRules.get((Object)category);
        }
        if (category == RuleCategory.NETHER) {
            return TBSurfaceRuleData.nether();
        }
        return TBSurfaceRuleData.overworld();
    }

    static {
        for (RuleCategory category : RuleCategory.values()) {
            surfaceRules.put(category, Maps.newHashMap());
            HashMap ruleStages = Maps.newHashMap();
            for (RuleStage stage : RuleStage.values()) {
                ruleStages.put(stage, Lists.newArrayList());
            }
            defaultSurfaceRuleInjections.put(category, ruleStages);
        }
    }

    public static enum RuleCategory {
        OVERWORLD,
        NETHER;

    }

    public static enum RuleStage {
        BEFORE_BEDROCK,
        AFTER_BEDROCK;

    }
}

