/*
 * Decompiled with CFR 0.152.
 */
package io.github.zekerzhayard.cme_blockmixin;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import sun.misc.Unsafe;

public class CopyOnWriteArrayListWithMutableIterator<T>
extends CopyOnWriteArrayList<T> {
    static MethodHandle getArrayMethod = CopyOnWriteArrayListWithMutableIterator.getMethod();

    public static <T> List<T> create() {
        return new CopyOnWriteArrayListWithMutableIterator<T>();
    }

    private static MethodHandle getMethod() {
        try {
            Field theUnsafeField = Unsafe.class.getDeclaredField("theUnsafe");
            theUnsafeField.setAccessible(true);
            Unsafe theUnsafe = (Unsafe)theUnsafeField.get(null);
            Field implLookupField = MethodHandles.Lookup.class.getDeclaredField("IMPL_LOOKUP");
            MethodHandles.Lookup implLookup = (MethodHandles.Lookup)theUnsafe.getObject(theUnsafe.staticFieldBase(implLookupField), theUnsafe.staticFieldOffset(implLookupField));
            return implLookup.findVirtual(CopyOnWriteArrayList.class, "getArray", MethodType.methodType(Object[].class));
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    protected Object[] getArray() {
        try {
            return (Object[])getArrayMethod.invokeWithArguments(new Object[]{this});
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    @Override
    public Iterator<T> iterator() {
        return new COWIterator(this.getArray(), 0);
    }

    @Override
    public ListIterator<T> listIterator() {
        return new COWIterator(this.getArray(), 0);
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        Object[] elements = this.getArray();
        int len = elements.length;
        if (index < 0 || index > len) {
            throw new IndexOutOfBoundsException("Index: " + index);
        }
        return new COWIterator(elements, index);
    }

    final class COWIterator<E>
    implements ListIterator<E> {
        private final Object[] snapshot;
        private int cursor;

        private COWIterator(Object[] elements, int initialCursor) {
            this.cursor = initialCursor;
            this.snapshot = elements;
        }

        @Override
        public boolean hasNext() {
            return this.cursor < this.snapshot.length;
        }

        @Override
        public boolean hasPrevious() {
            return this.cursor > 0;
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return (E)this.snapshot[this.cursor++];
        }

        @Override
        public E previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            return (E)this.snapshot[--this.cursor];
        }

        @Override
        public int nextIndex() {
            return this.cursor;
        }

        @Override
        public int previousIndex() {
            return this.cursor - 1;
        }

        @Override
        public void remove() {
            CopyOnWriteArrayListWithMutableIterator.this.remove(this.snapshot[this.cursor - 1]);
        }

        @Override
        public void set(E e) {
            CopyOnWriteArrayListWithMutableIterator.this.set(this.cursor - 1, e);
        }

        @Override
        public void add(E e) {
            CopyOnWriteArrayListWithMutableIterator.this.add(this.cursor - 1, e);
        }

        @Override
        public void forEachRemaining(Consumer<? super E> action) {
            Objects.requireNonNull(action);
            Object[] elements = this.snapshot;
            int size = elements.length;
            for (int i = this.cursor; i < size; ++i) {
                Object e = elements[i];
                action.accept(e);
            }
            this.cursor = size;
        }
    }
}

