/*
 * Decompiled with CFR 0.152.
 */
package com.github.thedeathlycow.moregeodes.blocks.entity;

import com.github.thedeathlycow.moregeodes.MoreGeodes;
import com.github.thedeathlycow.moregeodes.blocks.EchoLocatorType;
import com.github.thedeathlycow.moregeodes.blocks.entity.EchoLocatorCallback;
import com.github.thedeathlycow.moregeodes.blocks.entity.ModBlockEntities;
import com.github.thedeathlycow.moregeodes.entity.GeodesEntityTypes;
import com.github.thedeathlycow.moregeodes.mixin.BlockDisplayInvoker;
import com.github.thedeathlycow.moregeodes.world.GeodesGameEvents;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2495;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_5707;
import net.minecraft.class_5714;
import net.minecraft.class_5716;
import net.minecraft.class_8113;
import net.minecraft.class_8514;
import org.slf4j.Logger;

public class EchoLocatorBlockEntity
extends class_2586
implements class_5714.class_8513<class_8514.class_8516>,
class_8514 {
    public static final int SCAN_RADIUS = 30;
    private static final class_2382 SCAN_BOX = new class_2382(30, 30, 30);
    private static final int MAX_PING_TIME = 400;
    public static final int TICKS_PER_PING = 20;
    private int pingTicks = 0;
    private final List<class_2338> pinging = new ArrayList<class_2338>();
    private EchoLocatorType type = EchoLocatorType.EMPTY;
    private class_8514.class_8516 vibrationListener;
    private class_8514.class_8515 listenerData;
    private class_8514.class_5719 callback = new EchoLocatorCallback(this, 30, (class_5716)new class_5707(this.method_11016()));

    public EchoLocatorBlockEntity(class_2338 pos, class_2680 state) {
        super(ModBlockEntities.ECHO_LOCATOR, pos, state);
        this.listenerData = new class_8514.class_8515();
        this.vibrationListener = new class_8514.class_8516((class_8514)this);
    }

    public static void tick(class_3218 world, class_2338 origin, class_2680 state, EchoLocatorBlockEntity blockEntity) {
        if (blockEntity.isPinging() && !world.method_8608()) {
            ++blockEntity.pingTicks;
            if (blockEntity.pingTicks % 20 != 0) {
                return;
            }
            boolean shouldHighlight = true;
            Iterator<class_2338> pinging = blockEntity.pinging.iterator();
            while (pinging.hasNext()) {
                class_2680 atState;
                class_2338 pos = pinging.next();
                if (EchoLocatorBlockEntity.checkBlock(blockEntity, world, pos, atState = world.method_8320(pos), shouldHighlight)) {
                    shouldHighlight = false;
                    continue;
                }
                pinging.remove();
            }
        }
    }

    public static void serverTick(class_1937 world, class_2338 pos, class_2680 state, EchoLocatorBlockEntity blockEntity) {
        EchoLocatorBlockEntity.tick((class_3218)world, pos, state, blockEntity);
    }

    private static boolean checkBlock(EchoLocatorBlockEntity blockEntity, class_3218 world, class_2338 pos, class_2680 state, boolean shouldHighlight) {
        if (state.method_26164(blockEntity.type.canLocate())) {
            if (shouldHighlight) {
                EchoLocatorBlockEntity.highlightCrystal(blockEntity, world, pos, state);
            }
            return true;
        }
        return false;
    }

    private static void highlightCrystal(EchoLocatorBlockEntity blockEntity, class_3218 world, class_2338 pos, class_2680 state) {
        world.method_33596(null, GeodesGameEvents.CRYSTAL_RESONATE, pos);
        world.method_8396(null, pos, blockEntity.type.resonateSound(), class_3419.field_15245, 2.5f, 1.0f);
        class_8113.class_8115 blockDisplay = (class_8113.class_8115)GeodesEntityTypes.ECHO_DISPLAY.method_5883((class_1937)world);
        if (blockDisplay == null) {
            return;
        }
        ((BlockDisplayInvoker)blockDisplay).geodes$setBlockState(state);
        blockDisplay.method_23327((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260());
        blockDisplay.method_5834(true);
        blockDisplay.method_5684(true);
        world.method_8649((class_1297)blockDisplay);
    }

    public void activate(class_1937 world, class_2338 origin) {
        class_2338 from = origin.method_10059(SCAN_BOX);
        class_2338 to = origin.method_10081(SCAN_BOX);
        this.pingTicks = 0;
        this.pinging.clear();
        for (class_2338 pos : class_2338.method_10097((class_2338)from, (class_2338)to)) {
            class_2680 state = world.method_8320(pos);
            int rangeSquared = class_3532.method_34954((int)this.vibrationListener.method_32948());
            if (!(origin.method_10262((class_2382)pos) <= (double)rangeSquared) || !state.method_26164(this.type.canLocate())) continue;
            this.pinging.add(pos.method_10062());
        }
    }

    public boolean isPinging() {
        return this.pingTicks < 400;
    }

    public void setType(EchoLocatorType type) {
        this.type = type;
    }

    public void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        nbt.method_10569("PingTicks", this.pingTicks);
        nbt.method_10566("Type", (class_2520)this.type.toNbt());
        class_2499 pinging = new class_2499();
        for (class_2338 pingingPos : this.pinging) {
            class_2495 pos = new class_2495(new int[]{pingingPos.method_10263(), pingingPos.method_10264(), pingingPos.method_10260()});
            pinging.add((Object)pos);
        }
        nbt.method_10566("Pinging", (class_2520)pinging);
        DataResult listener = class_8514.class_8515.field_44640.encodeStart((DynamicOps)class_2509.field_11560, (Object)this.listenerData);
        listener.resultOrPartial(arg_0 -> ((Logger)MoreGeodes.LOGGER).error(arg_0)).ifPresent(nbtElement -> nbt.method_10566("listener", nbtElement));
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.pingTicks = nbt.method_10550("PingTicks");
        this.pinging.clear();
        class_2499 nbtList = nbt.method_10554("Pinging", 10);
        for (int i = 0; i < nbtList.size(); ++i) {
            class_2499 pos = nbtList.method_10603(i);
            this.pinging.add(new class_2338(pos.method_10600(0), pos.method_10600(1), pos.method_10600(2)));
        }
        this.type = nbt.method_10545("Type") ? EchoLocatorType.fromNbt(nbt.method_10562("Type")) : EchoLocatorType.EMPTY;
        if (nbt.method_10573("listener", 10)) {
            DataResult listener = class_8514.class_8515.field_44640.parse(new Dynamic((DynamicOps)class_2509.field_11560, (Object)nbt.method_10562("listener")));
            listener.resultOrPartial(arg_0 -> ((Logger)MoreGeodes.LOGGER).error(arg_0)).ifPresent(lsData -> {
                this.listenerData = lsData;
            });
        }
    }

    public class_8514.class_8516 getEventListener() {
        return this.vibrationListener;
    }

    public class_8514.class_8515 method_51298() {
        return this.listenerData;
    }

    public class_8514.class_5719 method_51299() {
        return this.callback;
    }
}

