/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.addons.biome.extrusion;

import com.dfsek.terra.addons.biome.extrusion.BaseBiomeColumn;
import com.dfsek.terra.addons.biome.extrusion.api.Extrusion;
import com.dfsek.terra.api.util.Column;
import com.dfsek.terra.api.world.biome.Biome;
import com.dfsek.terra.api.world.biome.generation.BiomeProvider;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class BiomeExtrusionProvider
implements BiomeProvider {
    private final BiomeProvider delegate;
    private final Set<Biome> biomes;
    private final List<Extrusion> extrusions;
    private final int resolution;

    public BiomeExtrusionProvider(BiomeProvider delegate, List<Extrusion> extrusions, int resolution) {
        this.delegate = delegate;
        this.biomes = delegate.stream().collect(Collectors.toSet());
        extrusions.forEach(e -> this.biomes.addAll(e.getBiomes()));
        this.extrusions = extrusions;
        this.resolution = resolution;
    }

    public Biome getBiome(int x, int y, int z, long seed) {
        Biome delegated = this.delegate.getBiome(x, y, z, seed);
        return this.extrude(delegated, x, y, z, seed);
    }

    public Biome extrude(Biome original, int x, int y, int z, long seed) {
        for (Extrusion extrusion : this.extrusions) {
            original = extrusion.extrude(original, x, y, z, seed);
        }
        return original;
    }

    public Column<Biome> getColumn(int x, int z, long seed, int min, int max) {
        return this.delegate.getBaseBiome(x, z, seed).map(base -> new BaseBiomeColumn(this, (Biome)base, min, max, x, z, seed)).orElseGet(() -> super.getColumn(x, z, seed, min, max));
    }

    public Optional<Biome> getBaseBiome(int x, int z, long seed) {
        return this.delegate.getBaseBiome(x, z, seed);
    }

    public Iterable<Biome> getBiomes() {
        return this.biomes;
    }

    public int resolution() {
        return this.resolution;
    }

    public BiomeProvider getDelegate() {
        return this.delegate;
    }
}

