/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercapaint.client;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1060;
import net.minecraft.class_1297;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5617;
import net.minecraft.class_7833;
import net.minecraft.class_897;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import xerca.xercapaint.Mod;
import xerca.xercapaint.PaletteUtil;
import xerca.xercapaint.entity.EntityCanvas;

@ParametersAreNonnullByDefault
@Environment(value=EnvType.CLIENT)
public class RenderEntityCanvas
extends class_897<EntityCanvas> {
    public static RenderEntityCanvas theInstance;
    private static final class_2960 backLocation;
    private static final int[] EMPTY_PIXELS;
    private final class_1060 textureManager;
    private final Map<String, Instance> loadedCanvases = Maps.newHashMap();

    RenderEntityCanvas(class_5617.class_5618 ctx) {
        super(ctx);
        this.textureManager = class_310.method_1551().method_1531();
    }

    @NotNull
    public class_2960 getTextureLocation(EntityCanvas entity) {
        return this.getCanvasRendererInstance((EntityCanvas)entity).location;
    }

    public void render(EntityCanvas entity, float entityYaw, float partialTicks, class_4587 matrixStackIn, class_4597 bufferIn, int packedLightIn) {
        super.method_3936((class_1297)entity, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
        this.getCanvasRendererInstance(entity).render(entity, entityYaw, entity.method_36455(), matrixStackIn, bufferIn, entity.method_5735(), packedLightIn);
    }

    private Instance getCanvasRendererInstance(EntityCanvas canvas) {
        return this.getCanvasRendererInstance(canvas.getCanvasName(), canvas.getCanvasVersion(), canvas.method_6897(), canvas.method_6891());
    }

    Instance getCanvasRendererInstance(class_2487 tag, int width, int height) {
        String name = tag.method_10558("name");
        int version = tag.method_10550("v");
        if (!EntityCanvas.PICTURES.containsKey(name) || EntityCanvas.PICTURES.get((Object)name).version < version) {
            EntityCanvas.PICTURES.put(name, new EntityCanvas.Picture(version, tag.method_10561("pixels")));
        }
        return this.getCanvasRendererInstance(name, version, width, height);
    }

    Instance getCanvasRendererInstance(String name, int version, int width, int height) {
        Instance instance = this.loadedCanvases.get(name);
        if (instance == null) {
            instance = new Instance(name, version, width, height);
            this.loadedCanvases.put(name, instance);
        } else if (instance.version < version || !instance.loaded) {
            instance.updateCanvasTexture(name, version);
        }
        return instance;
    }

    static {
        backLocation = new class_2960("minecraft", "textures/block/birch_planks.png");
        EMPTY_PIXELS = new int[1024];
        for (int i = 0; i < 1024; ++i) {
            RenderEntityCanvas.EMPTY_PIXELS[i] = PaletteUtil.Color.WHITE.rgbVal();
        }
    }

    @Environment(value=EnvType.CLIENT)
    public class Instance
    implements AutoCloseable {
        int version = 0;
        final int width;
        final int height;
        boolean loaded = false;
        boolean started = false;
        public final class_1043 canvasTexture;
        public final class_2960 location;

        private Instance(String name, int version, int width, int height) {
            this.width = width;
            this.height = height;
            this.canvasTexture = new class_1043(width, height, true);
            this.location = RenderEntityCanvas.this.textureManager.method_4617("canvas/" + name, this.canvasTexture);
            this.updateCanvasTexture(name, version);
        }

        private int swapColor(int color) {
            int i = (color & 0xFF0000) >> 16;
            int j = (color & 0xFF00) >> 8;
            int k = color & 0xFF;
            return k << 16 | j << 8 | i | 0xFF000000;
        }

        private void updateCanvasTexture(String name, int version) {
            this.version = version;
            int[] pixels = EMPTY_PIXELS;
            if (EntityCanvas.PICTURES.containsKey(name)) {
                pixels = EntityCanvas.PICTURES.get((Object)name).pixels;
                this.loaded = true;
            }
            if (this.loaded || !this.started) {
                if (pixels.length < this.height * this.width) {
                    Mod.LOGGER.warn("Pixels array length (" + pixels.length + ") is smaller than canvas area (" + this.height * this.width + ")");
                    return;
                }
                class_1011 image = this.canvasTexture.method_4525();
                if (image != null) {
                    for (int i = 0; i < this.height; ++i) {
                        for (int j = 0; j < this.width; ++j) {
                            int k = j + i * this.width;
                            image.method_4305(j, i, this.swapColor(pixels[k]));
                        }
                    }
                }
                this.canvasTexture.method_4524();
            }
            this.started = true;
        }

        public void render(@Nullable EntityCanvas canvas, float yaw, float pitch, class_4587 ms, class_4597 buffer, class_2350 facing, int packedLight) {
            float wScale = (float)this.width / 16.0f;
            float hScale = (float)this.height / 16.0f;
            ms.method_22903();
            Matrix3f mn = ms.method_23760().method_23762();
            float xOffset = facing.method_10148();
            float yOffset = facing.method_10164();
            float zOffset = facing.method_10165();
            if (canvas != null && canvas.getRotation() > 0) {
                ms.method_22907(class_7833.field_40714.rotationDegrees(pitch));
                ms.method_22907(class_7833.field_40716.rotationDegrees(180.0f - yaw));
                ms.method_22907(class_7833.field_40718.rotationDegrees((float)(90 * canvas.getRotation())));
                ms.method_22907(class_7833.field_40716.rotationDegrees(-180.0f + yaw));
                ms.method_22907(class_7833.field_40714.rotationDegrees(-pitch));
            }
            ms.method_23760().method_23762().set((Matrix3fc)mn);
            float f = 0.03125f;
            if (canvas != null) {
                if (facing.method_10166().method_10179()) {
                    ms.method_22904((double)zOffset * 0.5 * (double)wScale, -0.5 * (double)hScale, (double)(-xOffset) * 0.5 * (double)wScale);
                } else {
                    ms.method_22904(0.5 * (double)wScale, (double)(0.0f * hScale), (yOffset > 0.0f ? 0.5 : -0.5) * (double)wScale);
                }
            } else {
                ms.method_22904(0.75, 0.5, 0.5);
                f = wScale > 1.0f || hScale > 1.0f ? (f /= 3.3f) : (f /= 2.0f);
            }
            ms.method_22907(class_7833.field_40714.rotationDegrees(pitch));
            ms.method_22907(class_7833.field_40716.rotationDegrees(180.0f - yaw));
            ms.method_22905(f, f, f);
            RenderSystem.setShaderTexture((int)0, (class_2960)this.location);
            Matrix4f m = ms.method_23760().method_23761();
            mn = ms.method_23760().method_23762();
            class_4588 vb = buffer.getBuffer(class_1921.method_23572((class_2960)this.location));
            this.addVertex(vb, m, mn, 0.0, 32.0f * hScale, -1.0, 1.0f, 0.0f, packedLight, xOffset, yOffset, zOffset);
            this.addVertex(vb, m, mn, 32.0f * wScale, 32.0f * hScale, -1.0, 0.0f, 0.0f, packedLight, xOffset, yOffset, zOffset);
            this.addVertex(vb, m, mn, 32.0f * wScale, 0.0, -1.0, 0.0f, 1.0f, packedLight, xOffset, yOffset, zOffset);
            this.addVertex(vb, m, mn, 0.0, 0.0, -1.0, 1.0f, 1.0f, packedLight, xOffset, yOffset, zOffset);
            vb = buffer.getBuffer(class_1921.method_23572((class_2960)backLocation));
            float sideWidth = 0.0625f;
            RenderSystem.setShaderTexture((int)0, (class_2960)backLocation);
            this.addVertex(vb, m, mn, 0.0, 0.0, 1.0, 0.0f, 0.0f, packedLight, xOffset, yOffset, zOffset);
            this.addVertex(vb, m, mn, 32.0 * (double)wScale, 0.0, 1.0, 1.0f, 0.0f, packedLight, xOffset, yOffset, zOffset);
            this.addVertex(vb, m, mn, 32.0 * (double)wScale, 32.0 * (double)hScale, 1.0, 1.0f, 1.0f, packedLight, xOffset, yOffset, zOffset);
            this.addVertex(vb, m, mn, 0.0, 32.0 * (double)hScale, 1.0, 0.0f, 1.0f, packedLight, xOffset, yOffset, zOffset);
            this.addVertex(vb, m, mn, 0.0, 0.0, 1.0, 0.0625f, 0.0f, packedLight, xOffset, yOffset, zOffset);
            this.addVertex(vb, m, mn, 0.0, 32.0 * (double)hScale, 1.0, 0.0625f, 1.0f, packedLight, xOffset, yOffset, zOffset);
            this.addVertex(vb, m, mn, 0.0, 32.0 * (double)hScale, -1.0, 0.0f, 1.0f, packedLight, xOffset, yOffset, zOffset);
            this.addVertex(vb, m, mn, 0.0, 0.0, -1.0, 0.0f, 0.0f, packedLight, xOffset, yOffset, zOffset);
            this.addVertex(vb, m, mn, 0.0, 32.0 * (double)hScale, 1.0, 0.0f, 0.0f, packedLight, xOffset, yOffset, zOffset);
            this.addVertex(vb, m, mn, 32.0 * (double)wScale, 32.0 * (double)hScale, 1.0, 1.0f, 0.0f, packedLight, xOffset, yOffset, zOffset);
            this.addVertex(vb, m, mn, 32.0 * (double)wScale, 32.0 * (double)hScale, -1.0, 1.0f, 0.0625f, packedLight, xOffset, yOffset, zOffset);
            this.addVertex(vb, m, mn, 0.0, 32.0 * (double)hScale, -1.0, 0.0f, 0.0625f, packedLight, xOffset, yOffset, zOffset);
            this.addVertex(vb, m, mn, 32.0 * (double)wScale, 0.0, -1.0, 0.0f, 0.0f, packedLight, xOffset, yOffset, zOffset);
            this.addVertex(vb, m, mn, 32.0 * (double)wScale, 32.0 * (double)hScale, -1.0, 0.0f, 1.0f, packedLight, xOffset, yOffset, zOffset);
            this.addVertex(vb, m, mn, 32.0 * (double)wScale, 32.0 * (double)hScale, 1.0, 0.0625f, 1.0f, packedLight, xOffset, yOffset, zOffset);
            this.addVertex(vb, m, mn, 32.0 * (double)wScale, 0.0, 1.0, 0.0625f, 0.0f, packedLight, xOffset, yOffset, zOffset);
            this.addVertex(vb, m, mn, 0.0, 0.0, -1.0, 0.0f, 1.0f, packedLight, xOffset, yOffset, zOffset);
            this.addVertex(vb, m, mn, 32.0 * (double)wScale, 0.0, -1.0, 1.0f, 1.0f, packedLight, xOffset, yOffset, zOffset);
            this.addVertex(vb, m, mn, 32.0 * (double)wScale, 0.0, 1.0, 1.0f, 0.9375f, packedLight, xOffset, yOffset, zOffset);
            this.addVertex(vb, m, mn, 0.0, 0.0, 1.0, 0.0f, 0.9375f, packedLight, xOffset, yOffset, zOffset);
            ms.method_22909();
        }

        private void addVertex(class_4588 vb, Matrix4f m, Matrix3f mn, double x, double y, double z, float tx, float ty, int lightmap, float xOff, float yOff, float zOff) {
            vb.method_22918(m, (float)x, (float)y, (float)z).method_1336(255, 255, 255, 255).method_22913(tx, ty).method_22922(class_4608.field_21444).method_22916(lightmap).method_23763(mn, xOff, yOff, zOff).method_1344();
        }

        @Override
        public void close() {
            this.canvasTexture.close();
        }
    }

    public static class RenderEntityCanvasFactory
    implements class_5617<EntityCanvas> {
        @NotNull
        public class_897<EntityCanvas> create(class_5617.class_5618 ctx) {
            theInstance = new RenderEntityCanvas(ctx);
            return theInstance;
        }
    }
}

