/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercapaint;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_2487;
import net.minecraft.class_2540;

public class PaletteUtil {
    public static final Color emptinessColor = new Color(255, 236, 229);

    public static void writeCustomColorArrayToNBT(class_2487 tag, CustomColor[] customColors) {
        int[] totalReds = new int[12];
        int[] totalGreens = new int[12];
        int[] totalBlues = new int[12];
        int[] totalMaximums = new int[12];
        int[] numbersOfColors = new int[12];
        for (int i = 0; i < customColors.length; ++i) {
            totalReds[i] = customColors[i].totalRed;
            totalGreens[i] = customColors[i].totalGreen;
            totalBlues[i] = customColors[i].totalBlue;
            totalMaximums[i] = customColors[i].totalMaximum;
            numbersOfColors[i] = customColors[i].numberOfColors;
        }
        tag.method_10539("r", totalReds);
        tag.method_10539("g", totalGreens);
        tag.method_10539("b", totalBlues);
        tag.method_10539("m", totalMaximums);
        tag.method_10539("n", numbersOfColors);
    }

    public static void readCustomColorArrayFromNBT(class_2487 tag, CustomColor[] customColors) {
        int[] totalReds = tag.method_10561("r");
        int[] totalGreens = tag.method_10561("g");
        int[] totalBlues = tag.method_10561("b");
        int[] totalMaximums = tag.method_10561("m");
        int[] numbersOfColors = tag.method_10561("n");
        for (int i = 0; i < customColors.length; ++i) {
            customColors[i] = new CustomColor(totalReds[i], totalGreens[i], totalBlues[i], totalMaximums[i], numbersOfColors[i]);
        }
    }

    public static class CustomColor {
        private int totalRed = 0;
        private int totalGreen = 0;
        private int totalBlue = 0;
        private int totalMaximum = 0;
        private int numberOfColors = 0;
        private Color result;

        public CustomColor() {
            this.calculateResult();
        }

        public CustomColor(class_2540 buf) {
            this.readFromBuffer(buf);
        }

        public CustomColor(int totalRed, int totalGreen, int totalBlue, int totalMaximum, int numberOfColors) {
            this.totalRed = totalRed;
            this.totalGreen = totalGreen;
            this.totalBlue = totalBlue;
            this.totalMaximum = totalMaximum;
            this.numberOfColors = numberOfColors;
            this.calculateResult();
        }

        public void calculateResult() {
            if (this.numberOfColors == 0) {
                this.result = emptinessColor;
                return;
            }
            int averageRed = this.totalRed / this.numberOfColors;
            int averageGreen = this.totalGreen / this.numberOfColors;
            int averageBlue = this.totalBlue / this.numberOfColors;
            int averageMaximum = this.totalMaximum / this.numberOfColors;
            int maximumOfAverage = Math.max(Math.max(averageRed, averageGreen), averageBlue);
            int gainFactor = averageMaximum / maximumOfAverage;
            int resultRed = averageRed * gainFactor;
            int resultGreen = averageGreen * gainFactor;
            int resultBlue = averageBlue * gainFactor;
            this.result = new Color(resultRed, resultGreen, resultBlue);
        }

        public void mix(Color toBeMixed) {
            this.totalRed += toBeMixed.r;
            this.totalGreen += toBeMixed.g;
            this.totalBlue += toBeMixed.b;
            this.totalMaximum += Math.max(Math.max(toBeMixed.r, toBeMixed.g), toBeMixed.b);
            ++this.numberOfColors;
            this.calculateResult();
        }

        public void reset() {
            this.totalRed = 0;
            this.totalGreen = 0;
            this.totalBlue = 0;
            this.totalMaximum = 0;
            this.numberOfColors = 0;
            this.calculateResult();
        }

        public Color getColor() {
            return this.result;
        }

        public int getNumberOfColors() {
            return this.numberOfColors;
        }

        public void writeToBuffer(class_2540 buf) {
            buf.writeInt(this.totalRed);
            buf.writeInt(this.totalGreen);
            buf.writeInt(this.totalBlue);
            buf.writeInt(this.totalMaximum);
            buf.writeInt(this.numberOfColors);
        }

        public void readFromBuffer(class_2540 buf) {
            this.totalRed = buf.readInt();
            this.totalGreen = buf.readInt();
            this.totalBlue = buf.readInt();
            this.totalMaximum = buf.readInt();
            this.numberOfColors = buf.readInt();
        }
    }

    public static class Color {
        public static final Color WHITE = new Color(-1);
        public int r;
        public int g;
        public int b;

        public Color(int r, int g, int b) {
            this.r = r;
            this.g = g;
            this.b = b;
        }

        public Color(int rgb) {
            this.r = rgb >> 16 & 0xFF;
            this.g = rgb >> 8 & 0xFF;
            this.b = rgb & 0xFF;
        }

        public int rgbVal() {
            int val = this.r;
            val = (val << 8) + this.g;
            val = (val << 8) + this.b;
            return val -= 0x1000000;
        }

        public void setGLColor() {
            RenderSystem.setShaderColor((float)((float)this.r / 255.0f), (float)((float)this.g / 255.0f), (float)((float)this.b / 255.0f), (float)1.0f);
        }

        public static Color mix(Color a, Color b, float ratio) {
            if (ratio == 1.0f) {
                return a;
            }
            if (ratio == 0.0f) {
                return b;
            }
            Color res = new Color((int)((float)a.r * ratio) + (int)((float)b.r * (1.0f - ratio)), (int)((float)a.g * ratio) + (int)((float)b.g * (1.0f - ratio)), (int)((float)a.b * ratio) + (int)((float)b.b * (1.0f - ratio)));
            int averageMaximum = (int)((float)Math.max(Math.max(a.r, a.g), a.b) * ratio) + (int)((float)Math.max(Math.max(b.r, b.g), b.b) * (1.0f - ratio));
            int maximumOfAverage = Math.max(Math.max(res.r, res.g), res.b);
            int gainFactor = averageMaximum / maximumOfAverage;
            res.r *= gainFactor;
            res.g *= gainFactor;
            res.b *= gainFactor;
            return res;
        }
    }
}

