/*
 * Decompiled with CFR 0.152.
 */
package net.barribob.parkour.config;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Type;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import net.barribob.maelstrom.MaelstromMod;
import net.barribob.maelstrom.util.Version;
import net.barribob.parkour.config.Config;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u000b\u0010\fJ=\u0010\t\u001a\u00028\u0000\"\u0004\b\u0000\u0010\u00022\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u00032\u0012\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00030\u00052\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\n\u00a8\u0006\r"}, d2={"Lnet/barribob/parkour/config/ConfigManager;", "", "T", "Lnet/barribob/parkour/config/Config;", "defaultConfig", "Lcom/google/gson/reflect/TypeToken;", "typeToken", "", "modid", "handleConfigLoad", "(Lnet/barribob/parkour/config/Config;Lcom/google/gson/reflect/TypeToken;Ljava/lang/String;)Ljava/lang/Object;", "<init>", "()V", "mobs-attempt-parkour"})
public final class ConfigManager {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T handleConfigLoad(@NotNull Config<T> defaultConfig, @NotNull TypeToken<Config<T>> typeToken, @NotNull String modid) {
        CopyOption[] copyOptionArray;
        Object object;
        Type configType2;
        Gson gson;
        File configFile;
        block18: {
            Intrinsics.checkNotNullParameter(defaultConfig, (String)"defaultConfig");
            Intrinsics.checkNotNullParameter(typeToken, (String)"typeToken");
            Intrinsics.checkNotNullParameter((Object)modid, (String)"modid");
            File directory = new File("./config/" + modid + '/');
            if (!directory.exists()) {
                directory.mkdirs();
            }
            configFile = new File(directory, "config.json");
            gson = new Gson();
            configType2 = typeToken.getType();
            if (configFile.exists()) {
                try {
                    object = new FileReader(configFile);
                    copyOptionArray = null;
                    try {
                        Object reader = (FileReader)object;
                        boolean bl = false;
                        reader = (Config)gson.fromJson((Reader)reader, configType2);
                    }
                    catch (Throwable reader) {
                        copyOptionArray = reader;
                        throw reader;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)object, (Throwable)copyOptionArray);
                    }
                    Object existingConfig = reader;
                    if (existingConfig == null) break block18;
                    try {
                        if (new Version(defaultConfig.getConfigVersion()).compareTo(new Version(((Config)existingConfig).getConfigVersion())) <= 0) {
                            return ((Config)existingConfig).getData();
                        }
                        File configBackup = new File(directory, "config_" + ((Config)existingConfig).getConfigVersion() + ".json");
                        copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                        Files.copy(configFile.toPath(), configBackup.toPath(), copyOptionArray);
                        MaelstromMod.INSTANCE.getLOGGER().warn((Object)("Config file for " + modid + " is outdated. Created backup of config (" + FilesKt.toRelativeString((File)configBackup, (File)directory) + "), and using new default."));
                    }
                    catch (IllegalArgumentException e) {
                        MaelstromMod.INSTANCE.getLOGGER().error((Object)("Failed to read config file for " + modid + "! Perhaps the config version has been tampered with?"));
                        return defaultConfig.getData();
                    }
                }
                catch (Exception e) {
                    MaelstromMod.INSTANCE.getLOGGER().error((Object)("Failed to read config file for " + modid + '!'));
                    MaelstromMod.INSTANCE.getLOGGER().error((Object)e);
                    return defaultConfig.getData();
                }
            }
        }
        Closeable closeable = (Closeable)new JsonWriter((Writer)new FileWriter(configFile));
        object = null;
        try {
            JsonWriter writer = (JsonWriter)closeable;
            boolean bl = false;
            writer.setIndent("\t");
            gson.toJson(defaultConfig, configType2, writer);
            copyOptionArray = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
        }
        return defaultConfig.getData();
    }
}

