/*
 * Decompiled with CFR 0.152.
 */
package net.barribob.parkour;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.barribob.maelstrom.static_utilities.VecUtilsKt;
import net.barribob.parkour.ai.BlockType;
import net.minecraft.class_10;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1309;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2323;
import net.minecraft.class_2338;
import net.minecraft.class_2349;
import net.minecraft.class_238;
import net.minecraft.class_2397;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3481;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3922;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b,\u0010-J'\u0010\b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ'\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0015\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0012J%\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u001d\u0010\u001c\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001a\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u001f\u0010\u001e\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001aH\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001dJ\u001d\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00020!2\u0006\u0010 \u001a\u00020\u001fH\u0002\u00a2\u0006\u0004\b\"\u0010#J\u0017\u0010$\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u001aH\u0002\u00a2\u0006\u0004\b$\u0010%J-\u0010*\u001a\u00020)2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010&\u001a\u00020\u00022\u0006\u0010'\u001a\u00020\n2\u0006\u0010(\u001a\u00020\n\u00a2\u0006\u0004\b*\u0010+\u00a8\u0006."}, d2={"Lnet/barribob/parkour/ModUtils;", "", "Lnet/minecraft/class_243;", "point", "Lnet/minecraft/class_265;", "shape", "", "maxSamples", "findClosestCorner", "(Lnet/minecraft/class_243;Lnet/minecraft/class_265;I)Lnet/minecraft/class_243;", "", "x", "y", "z", "Lnet/minecraft/class_2338;", "floorBlockPos", "(DDD)Lnet/minecraft/class_2338;", "pos", "(Lnet/minecraft/class_243;)Lnet/minecraft/class_2338;", "Lnet/minecraft/class_1922;", "world", "callsLeft", "Lnet/barribob/parkour/ai/BlockType;", "getBlockType", "(Lnet/minecraft/class_1922;Lnet/minecraft/class_2338;I)Lnet/barribob/parkour/ai/BlockType;", "Lnet/minecraft/class_1937;", "Lnet/minecraft/class_1309;", "entity", "getJumpVelocity", "(Lnet/minecraft/class_1937;Lnet/minecraft/class_1309;)D", "getJumpVelocityMultiplier", "Lnet/minecraft/class_238;", "box", "", "getTopCornersAndEdges", "(Lnet/minecraft/class_238;)Ljava/util/List;", "getVelocityAffectingPos", "(Lnet/minecraft/class_1309;)Lnet/minecraft/class_2338;", "target", "horzVel", "yVel", "", "leapTowards", "(Lnet/minecraft/class_1309;Lnet/minecraft/class_243;DD)V", "<init>", "()V", "mobs-attempt-parkour"})
public final class ModUtils {
    @NotNull
    public static final ModUtils INSTANCE = new ModUtils();

    private ModUtils() {
    }

    public final double getJumpVelocity(@NotNull class_1937 world, @NotNull class_1309 entity) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        double baseVelocity = 0.42 * this.getJumpVelocityMultiplier(world, entity);
        if (entity.method_6059(class_1294.field_5913)) {
            class_1293 class_12932 = entity.method_6112(class_1294.field_5913);
            Intrinsics.checkNotNull((Object)class_12932);
            baseVelocity += 0.1 * (double)(class_12932.method_5578() + 1);
        }
        return baseVelocity;
    }

    private final double getJumpVelocityMultiplier(class_1937 world, class_1309 entity) {
        float f = world.method_8320(entity.method_24515()).method_26204().method_23350();
        float g = world.method_8320(this.getVelocityAffectingPos(entity)).method_26204().method_23350();
        return (double)f == 1.0 ? (double)g : (double)f;
    }

    private final class_2338 getVelocityAffectingPos(class_1309 entity) {
        return this.floorBlockPos(entity.method_19538().field_1352, entity.method_5829().field_1322 - 0.5000001, entity.method_19538().field_1350);
    }

    private final class_2338 floorBlockPos(double x, double y, double z) {
        return new class_2338(class_3532.method_15357((double)x), class_3532.method_15357((double)y), class_3532.method_15357((double)z));
    }

    @NotNull
    public final class_2338 floorBlockPos(@NotNull class_243 pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return this.floorBlockPos(pos.field_1352, pos.field_1351, pos.field_1350);
    }

    public final void leapTowards(@NotNull class_1309 entity, @NotNull class_243 target, double horzVel, double yVel) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        class_243 dir = target.method_1020(entity.method_19538()).method_1029();
        class_243 class_2432 = new class_243(dir.field_1352, 0.0, dir.field_1350).method_1029().method_1021(horzVel);
        Intrinsics.checkNotNullExpressionValue((Object)class_2432, (String)"Vec3d(dir.x, 0.0, dir.z)\u2026alize().multiply(horzVel)");
        class_243 leap = VecUtilsKt.yOffset((class_243)class_2432, (double)yVel);
        double clampedYVelocity = entity.method_18798().field_1351 < 0.1 ? leap.field_1351 : 0.0;
        class_243 horzVelocity = entity.method_18798().method_1031(leap.field_1352, 0.0, leap.field_1350);
        double scale = horzVel / horzVelocity.method_1033();
        if (scale < 1.0) {
            horzVelocity = horzVelocity.method_1021(scale);
        }
        class_243 class_2433 = horzVelocity;
        Intrinsics.checkNotNullExpressionValue((Object)class_2433, (String)"horzVelocity");
        entity.method_18799(VecUtilsKt.yOffset((class_243)class_2433, (double)clampedYVelocity));
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public final BlockType getBlockType(@NotNull class_1922 world, @NotNull class_2338 pos, int callsLeft) {
        BlockType blockType;
        BlockType belowType;
        block13: {
            block11: {
                class_2680 blockState;
                block12: {
                    BlockType blockType2;
                    Intrinsics.checkNotNullParameter((Object)world, (String)"world");
                    Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
                    blockState = world.method_8320(pos);
                    class_2248 block = blockState.method_26204();
                    class_3610 fluidState = world.method_8316(pos);
                    if (pos.method_10264() > 0 && callsLeft > 0) {
                        class_2338 class_23382 = pos.method_10074();
                        Intrinsics.checkNotNullExpressionValue((Object)class_23382, (String)"pos.down()");
                        blockType2 = this.getBlockType(world, class_23382, callsLeft - 1);
                    } else {
                        blockType2 = BlockType.OPEN;
                    }
                    belowType = blockType2;
                    if (blockState.method_27852(class_2246.field_16999) || blockState.method_26164(class_3481.field_21952) || class_3922.method_23896((class_2680)blockState) || fluidState.method_15767(class_3486.field_15517)) {
                        blockType = BlockType.PASSABLE_OBSTACLE;
                        return blockType;
                    }
                    if (fluidState.method_15767(class_3486.field_15518) || blockState.method_27852(class_2246.field_10029) || blockState.method_27852(class_2246.field_21211) || blockState.method_27852(class_2246.field_10092)) {
                        blockType = BlockType.SOLID_OBSTACLE;
                        return blockType;
                    }
                    if (block instanceof class_2397 || blockState.method_26164(class_3481.field_16584) || blockState.method_26164(class_3481.field_15504) || block instanceof class_2349 && !((Boolean)blockState.method_11654((class_2769)class_2349.field_11026)).booleanValue() || block instanceof class_2323 && !((Boolean)blockState.method_11654((class_2769)class_2323.field_10945)).booleanValue()) break block11;
                    if (!(block instanceof class_2323)) break block12;
                    Comparable comparable = blockState.method_11654((class_2769)class_2323.field_10945);
                    Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"blockState.get(DoorBlock.OPEN)");
                    if (((Boolean)comparable).booleanValue()) break block11;
                }
                if (blockState.method_26171(world, pos, class_10.field_50)) break block13;
            }
            blockType = BlockType.BLOCKED;
            return blockType;
        }
        if (belowType == BlockType.BLOCKED) {
            blockType = BlockType.WALKABLE;
            return blockType;
        }
        if (belowType == BlockType.OPEN) {
            blockType = BlockType.PASSABLE_OBSTACLE;
            return blockType;
        }
        if (belowType == BlockType.PASSABLE_OBSTACLE) {
            blockType = BlockType.PASSABLE_OBSTACLE;
            return blockType;
        }
        if (belowType == BlockType.SOLID_OBSTACLE) {
            blockType = BlockType.PASSABLE_OBSTACLE;
            return blockType;
        }
        blockType = BlockType.OPEN;
        return blockType;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final class_243 findClosestCorner(@NotNull class_243 point, @NotNull class_265 shape, int maxSamples) {
        Object v0;
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        List list = shape.method_1090();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"shape.boundingBoxes");
        Iterable $this$flatMap$iv = list;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            class_238 it = (class_238)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            Iterable list$iv$iv = INSTANCE.getTopCornersAndEdges(it);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List corners = CollectionsKt.take((Iterable)CollectionsKt.shuffled((Iterable)((List)destination$iv$iv)), (int)maxSamples);
        Iterable $this$minByOrNull$iv = corners;
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = minElem$iv;
            } else {
                class_243 it = (class_243)minElem$iv;
                boolean bl = false;
                double minValue$iv = it.method_1025(point);
                do {
                    Object e$iv = iterator$iv.next();
                    class_243 it2 = (class_243)e$iv;
                    $i$a$-minByOrNull-ModUtils$findClosestCorner$1 = false;
                    double v$iv = it2.method_1025(point);
                    if (Double.compare(minValue$iv, v$iv) <= 0) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = minElem$iv;
            }
        }
        return v0;
    }

    private final List<class_243> getTopCornersAndEdges(class_238 box) {
        double halfX = box.method_17939() * 0.5;
        double halfZ = box.method_17941() * 0.5;
        Object[] objectArray = new class_243[]{new class_243(box.field_1323, box.field_1325, box.field_1321), new class_243(box.field_1320, box.field_1325, box.field_1321), new class_243(box.field_1323, box.field_1325, box.field_1324), new class_243(box.field_1320, box.field_1325, box.field_1324), new class_243(box.field_1323 + halfX, box.field_1325, box.field_1321), new class_243(box.field_1323, box.field_1325, box.field_1321 + halfZ), new class_243(box.field_1320, box.field_1325, box.field_1321 + halfZ), new class_243(box.field_1323 + halfX, box.field_1325, box.field_1324)};
        return CollectionsKt.listOf((Object[])objectArray);
    }
}

