/*
 * Decompiled with CFR 0.152.
 */
package de.cristelknight.doapi.client.render.feature;

import com.google.common.collect.Sets;
import de.cristelknight.doapi.Util;
import de.cristelknight.doapi.api.DoApiAPI;
import de.cristelknight.doapi.api.DoApiPlugin;
import de.cristelknight.doapi.client.render.feature.CustomArmorSet;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_5599;
import net.minecraft.class_583;
import org.jetbrains.annotations.Nullable;

public class CustomArmorManager<T extends class_1309> {
    private final Set<CustomArmorSet<T>> ARMORS = Sets.newHashSet();
    private final class_5599 modelLoader;

    public CustomArmorManager(class_5599 modelLoader) {
        this.modelLoader = modelLoader;
    }

    public boolean isEmpty() {
        return this.ARMORS.isEmpty();
    }

    public CustomArmorSet<T> addArmor(CustomArmorSet<T> model) {
        this.ARMORS.add(model);
        return model;
    }

    @Nullable
    public CustomArmorSet<T> getSet(class_1792 item) {
        for (CustomArmorSet<T> armor : this.ARMORS) {
            if (!armor.getArmor().contains(item)) continue;
            return armor;
        }
        return null;
    }

    @Nullable
    public class_583<T> getModel(class_1792 item, class_1304 slot) {
        if (this.ARMORS.isEmpty()) {
            this.updateArmors();
        }
        for (CustomArmorSet<T> armor : this.ARMORS) {
            if (!armor.getArmor().contains(item)) continue;
            return armor.getModel(slot);
        }
        return null;
    }

    @Nullable
    public class_2960 getTexture(class_1792 item, String string) {
        if (this.ARMORS.isEmpty()) {
            this.updateArmors();
        }
        for (CustomArmorSet<T> armor : this.ARMORS) {
            if (!armor.getArmor().contains(item)) continue;
            return armor.getTexture(string);
        }
        return null;
    }

    private void updateArmors() {
        List<DoApiAPI> apis = Util.getApis(DoApiAPI.class, "doapi", DoApiPlugin.class);
        for (DoApiAPI api : apis) {
            api.registerArmor(this, this.modelLoader);
        }
    }
}

