/*
 * Decompiled with CFR 0.152.
 */
package mod.crend.autohud.render;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import mod.crend.autohud.AutoHud;
import mod.crend.autohud.component.Component;
import mod.crend.autohud.render.CustomFramebufferRenderer;
import net.minecraft.class_332;

public class AutoHudRenderer {
    public static boolean inRender;
    public static float tickDelta;
    public static float alpha;
    public static float globalOffsetX;
    public static float globalOffsetY;

    public static void preInjectFade(Component component) {
        AutoHudRenderer.preInjectFade(component, 0.0f);
    }

    public static void preInjectFade(Component component, float minAlpha) {
        if (AutoHud.config.animationFade()) {
            alpha = Math.max(component.getAlpha(tickDelta), minAlpha);
            RenderSystem.enableBlend();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        }
    }

    public static void preInjectFadeWithReverseTranslation(class_332 context, Component component, float minAlpha) {
        AutoHudRenderer.preInjectFade(component, minAlpha);
        if (AutoHud.config.animationMove()) {
            context.method_51448().method_22903();
            if (component.isHidden()) {
                context.method_51448().method_22904(-component.getOffsetX(tickDelta), -component.getOffsetY(tickDelta), 0.0);
            }
        }
        if (globalOffsetX != 0.0f || globalOffsetY != 0.0f) {
            context.method_51448().method_22903();
            context.method_51448().method_46416(globalOffsetX, globalOffsetY, 0.0f);
        }
    }

    public static void preInject(class_332 context, Component component) {
        if (AutoHud.config.animationFade()) {
            alpha = component.getAlpha(tickDelta);
            RenderSystem.enableBlend();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        }
        if (AutoHud.config.animationMove() || !AutoHud.config.animationFade()) {
            context.method_51448().method_22903();
            if (component.isHidden()) {
                context.method_51448().method_22904(component.getOffsetX(tickDelta), component.getOffsetY(tickDelta), 0.0);
            }
        }
    }

    public static boolean shouldRenderCrosshair() {
        if (!Component.Crosshair.config.active()) {
            return true;
        }
        if (AutoHud.config.animationFade()) {
            return !Component.Crosshair.fullyHidden() || Component.Crosshair.config.maximumFade() > 0.0;
        }
        return !Component.Crosshair.isHidden();
    }

    public static void preInjectCrosshair() {
        if (Component.Crosshair.config.active()) {
            CustomFramebufferRenderer.init();
            RenderSystem.defaultBlendFunc();
            AutoHudRenderer.preInjectFade(Component.Crosshair, (float)Component.Crosshair.config.maximumFade());
        }
    }

    public static void postInjectCrosshair(class_332 context) {
        if (Component.Crosshair.config.active()) {
            AutoHudRenderer.postInjectFade();
            RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.ONE_MINUS_DST_COLOR, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_COLOR, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ZERO);
            CustomFramebufferRenderer.draw(context);
        }
    }

    public static void postInjectFade() {
        if (AutoHud.config.animationFade()) {
            alpha = 1.0f;
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        }
    }

    public static void postInjectFadeWithReverseTranslation(class_332 context) {
        AutoHudRenderer.postInjectFade();
        if (AutoHud.config.animationMove()) {
            context.method_51448().method_22909();
        }
        if (globalOffsetX != 0.0f || globalOffsetY != 0.0f) {
            context.method_51448().method_22909();
        }
    }

    public static void postInject(class_332 context) {
        if (AutoHud.config.animationFade()) {
            alpha = 1.0f;
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        }
        if (AutoHud.config.animationMove() || !AutoHud.config.animationFade()) {
            context.method_51448().method_22909();
        }
    }

    public static int modifyArgb(int argb) {
        int oldAlpha = argb >> 24;
        if ((oldAlpha & 0xFC) == 0) {
            oldAlpha = 255;
        }
        return Math.round(alpha * (float)oldAlpha) << 24 | argb & 0xFFFFFF;
    }

    public static int getArgb() {
        return Math.round(alpha * 255.0f) << 24;
    }

    public static void injectTransparency() {
        if (inRender) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        }
    }

    static {
        tickDelta = 0.0f;
        alpha = 1.0f;
        globalOffsetX = 0.0f;
        globalOffsetY = 0.0f;
    }
}

