/*
 * Decompiled with CFR 0.152.
 */
package mod.crend.autohud.mixin.gui;

import com.google.common.collect.Ordering;
import java.util.Collection;
import mod.crend.autohud.AutoHud;
import mod.crend.autohud.component.Component;
import mod.crend.autohud.component.Hud;
import mod.crend.autohud.render.AutoHudRenderer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1074;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_310;
import net.minecraft.class_329;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_329.class}, priority=500)
public abstract class StatusEffectTimerMixin {
    @Shadow
    @Final
    private class_310 field_2035;

    @Inject(method={"renderStatusEffectOverlay"}, at={@At(value="TAIL")})
    private void renderDurationOverlay(class_332 context, CallbackInfo c) {
        if (!AutoHud.config.statusEffectTimer()) {
            return;
        }
        Collection collection = this.field_2035.field_1724.method_6026();
        if (!collection.isEmpty()) {
            int beneficialCount = 0;
            int nonBeneficialCount = 0;
            for (class_1293 statusEffectInstance : Ordering.natural().reverse().sortedCopy((Iterable)collection)) {
                class_1291 statusEffect = statusEffectInstance.method_5579();
                if (!Hud.shouldShowIcon(statusEffectInstance)) continue;
                int x = this.field_2035.method_22683().method_4486();
                int y = 1;
                if (this.field_2035.method_1530()) {
                    y += 15;
                }
                if (statusEffect.method_5573()) {
                    x -= 25 * ++beneficialCount;
                } else {
                    x -= 25 * ++nonBeneficialCount;
                    y += 26;
                }
                AutoHudRenderer.preInject(context, Component.get(statusEffect));
                String duration = this.getDurationAsString(statusEffectInstance);
                int durationLength = this.field_2035.field_1772.method_1727(duration);
                context.method_25303(this.field_2035.field_1772, duration, x + 13 - durationLength / 2, y + 14, -1711276033);
                int amplifier = statusEffectInstance.method_5578();
                if (amplifier > 0) {
                    String amplifierString = amplifier < 6 ? class_1074.method_4662((String)("potion.potency." + amplifier), (Object[])new Object[0]) : "**";
                    int amplifierLength = this.field_2035.field_1772.method_1727(amplifierString);
                    context.method_25303(this.field_2035.field_1772, amplifierString, x + 22 - amplifierLength, y + 3, -1711276033);
                }
                AutoHudRenderer.postInject(context);
            }
        }
    }

    @NotNull
    private String getDurationAsString(class_1293 statusEffectInstance) {
        int ticks = class_3532.method_15375((float)statusEffectInstance.method_5584());
        int seconds = ticks / 20;
        if (ticks > 32147) {
            return "**";
        }
        if (seconds > 60) {
            return seconds / 60 + "m";
        }
        return String.valueOf(seconds);
    }
}

