/*
 * Decompiled with CFR 0.152.
 */
package mod.crend.autohud.config;

import dev.isxander.yacl3.config.v2.api.SerialEntry;
import mod.crend.autohud.config.RevealPolicy;
import mod.crend.autohud.config.RevealType;
import mod.crend.autohud.config.ScrollDirection;
import mod.crend.yaclx.auto.annotation.AutoYaclConfig;
import mod.crend.yaclx.auto.annotation.Category;
import mod.crend.yaclx.auto.annotation.EnableIf;
import mod.crend.yaclx.auto.annotation.FloatingPointRange;
import mod.crend.yaclx.auto.annotation.Label;
import mod.crend.yaclx.auto.annotation.NumericRange;
import mod.crend.yaclx.auto.annotation.TransitiveObject;
import mod.crend.yaclx.auto.annotation.Translation;

@AutoYaclConfig(modid="autohud", filename="autohud.json5")
public class Config
implements Cloneable {
    @SerialEntry
    public boolean dynamicOnLoad = true;
    @NumericRange(min=10L, max=200L, interval=10L)
    @SerialEntry
    public int ticksRevealed = 40;
    @SerialEntry
    public boolean animationMove = true;
    @SerialEntry
    public boolean animationFade = true;
    @FloatingPointRange(min=1.0, max=4.0, interval=0.25)
    @SerialEntry
    public double animationSpeed = 2.0;
    @SerialEntry
    public AnimationSpeeds animationSpeeds = new AnimationSpeeds();
    @SerialEntry
    public RevealType revealType = RevealType.Stacked;
    @Category(name="components", group="statusEffects")
    @SerialEntry
    public boolean statusEffectTimer = true;
    @Category(name="advanced")
    @TransitiveObject
    @SerialEntry
    public DefaultValues defaultValues = new DefaultValues();
    @Category(name="components", group="statusBars")
    @SerialEntry
    public PolicyComponent health = new PolicyComponent();
    @Category(name="components", group="statusBars")
    @SerialEntry
    public PolicyComponent hunger = new PolicyComponent();
    @Category(name="components", group="statusBars")
    @SerialEntry
    public PolicyComponent air = new PolicyComponent();
    @Category(name="components", group="statusBars")
    @SerialEntry
    public PolicyComponent armor = new PolicyComponent();
    @Category(name="components", group="statusBars")
    @SerialEntry
    public BooleanComponent experience = new BooleanComponent();
    @Category(name="components", group="statusBars")
    @SerialEntry
    public BooleanComponent mountJumpBar = new BooleanComponent();
    @Category(name="components", group="statusBars")
    @SerialEntry
    public PolicyComponent mountHealth = new PolicyComponent();
    @Category(name="components", group="statusEffects")
    @SerialEntry
    public BooleanComponent statusEffects = new BooleanComponent();
    @Category(name="components", group="statusEffects")
    @SerialEntry
    public boolean hidePersistentStatusEffects = true;
    @Category(name="components")
    @SerialEntry
    public HotbarComponents hotbar = new HotbarComponents();
    @Category(name="components")
    @SerialEntry
    public ScoreboardComponents scoreboard = new ScoreboardComponents();
    @Category(name="components")
    @SerialEntry
    public BooleanComponent crosshair = new BooleanComponent();
    @Category(name="advanced")
    @Label(key="autohud.option.advanced.label")
    @TransitiveObject
    @SerialEntry
    public AdvancedComponents advanced = new AdvancedComponents();

    public Config() {
        this.hunger.policy = RevealPolicy.Low;
        this.air.policy = RevealPolicy.NotFull;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public static class AnimationSpeeds {
        @FloatingPointRange(min=1.0, max=4.0, interval=0.25)
        @EnableIf(field="animationMove", value=EnableIf.BooleanPredicate.class)
        @SerialEntry
        public double moveIn = 0.0;
        @FloatingPointRange(min=1.0, max=4.0, interval=0.25)
        @EnableIf(field="animationMove", value=EnableIf.BooleanPredicate.class)
        @SerialEntry
        public double moveOut = 0.0;
        @FloatingPointRange(min=1.0, max=4.0, interval=0.25)
        @EnableIf(field="animationFade", value=EnableIf.BooleanPredicate.class)
        @SerialEntry
        public double fadeIn = 0.0;
        @FloatingPointRange(min=1.0, max=4.0, interval=0.25)
        @EnableIf(field="animationFade", value=EnableIf.BooleanPredicate.class)
        @SerialEntry
        public double fadeOut = 0.0;

        AnimationSpeeds() {
        }
    }

    public static class DefaultValues {
        @FloatingPointRange(min=0.1, max=5.0, interval=0.1)
        @SerialEntry
        public double speedMultiplier = 1.0;
        @NumericRange(min=0L, max=200L, interval=5L)
        @SerialEntry
        public int distance = 60;
        @FloatingPointRange(min=0.0, max=1.0, interval=0.1)
        @SerialEntry
        public double maximumFade = 0.0;

        DefaultValues() {
        }
    }

    public static class PolicyComponent
    extends IComponent {
        @SerialEntry
        public RevealPolicy policy = RevealPolicy.Changing;

        PolicyComponent() {
        }
    }

    public static class BooleanComponent
    extends IComponent {
        @SerialEntry
        public boolean active = true;
        @EnableIf(field="active", value=EnableIf.BooleanPredicate.class)
        @SerialEntry
        public boolean onChange = true;

        BooleanComponent() {
        }
    }

    public static class HotbarComponents {
        @SerialEntry
        public BooleanComponent hotbar = new BooleanComponent();
        @EnableIf(field="hotbar.active", value=EnableIf.BooleanPredicate.class)
        @SerialEntry
        public boolean onSlotChange = true;
        @EnableIf(field="hotbar.active", value=EnableIf.BooleanPredicate.class)
        @SerialEntry
        public boolean onLowDurability = true;
        @NumericRange(min=0L, max=100L, interval=1L)
        @EnableIf.EnableIfList(value={@EnableIf(field="hotbar.active", value=EnableIf.BooleanPredicate.class), @EnableIf(field="onLowDurability", value=EnableIf.BooleanPredicate.class)})
        @SerialEntry
        public int durabilityPercentage = 10;
        @EnableIf.EnableIfList(value={@EnableIf(field="hotbar.active", value=EnableIf.BooleanPredicate.class), @EnableIf(field="onLowDurability", value=EnableIf.BooleanPredicate.class)})
        @SerialEntry
        public int durabilityTotal = 20;
        @EnableIf(field="hotbar.active", value=EnableIf.BooleanPredicate.class)
        @FloatingPointRange(min=0.0, max=1.0, interval=0.10000000149011612)
        @SerialEntry
        public float maximumFadeHotbarItems = 0.0f;
    }

    public static class ScoreboardComponents {
        @SerialEntry
        public BooleanComponent scoreboard = new BooleanComponent();
        @EnableIf(field="scoreboard.active", value=EnableIf.BooleanPredicate.class)
        @SerialEntry
        public boolean onScoreChange = true;
        @EnableIf(field="scoreboard.active", value=EnableIf.BooleanPredicate.class)
        @SerialEntry
        public boolean onTeamChange = true;
    }

    public static class AdvancedComponents {
        @Translation(key="autohud.group.hotbar")
        @SerialEntry
        public AdvancedComponent hotbar = new AdvancedComponent();
        @Translation(key="autohud.group.health")
        @SerialEntry
        public AdvancedComponent health = new AdvancedComponent();
        @Translation(key="autohud.group.armor")
        @SerialEntry
        public AdvancedComponent armor = new AdvancedComponent();
        @Translation(key="autohud.group.hunger")
        @SerialEntry
        public AdvancedComponent hunger = new AdvancedComponent();
        @Translation(key="autohud.group.air")
        @SerialEntry
        public AdvancedComponent air = new AdvancedComponent();
        @Translation(key="autohud.group.experience")
        @SerialEntry
        public AdvancedComponent experience = new AdvancedComponent();
        @Translation(key="autohud.group.mountJumpBar")
        @SerialEntry
        public AdvancedComponent mountJumpBar = new AdvancedComponent();
        @Translation(key="autohud.group.mountHealth")
        @SerialEntry
        public AdvancedComponent mountHealth = new AdvancedComponent();
        @Translation(key="autohud.group.statusEffects")
        @SerialEntry
        public AdvancedComponent statusEffects = new AdvancedComponent();
        @Translation(key="autohud.group.scoreboard")
        @SerialEntry
        public AdvancedComponent scoreboard = new AdvancedComponent();
        @Translation(key="autohud.group.crosshair")
        @SerialEntry
        public AdvancedFadeOnlyComponent crosshair = new AdvancedFadeOnlyComponent();

        private AdvancedComponents() {
            this.statusEffects.direction = ScrollDirection.Up;
            this.scoreboard.direction = ScrollDirection.Right;
            this.scoreboard.distance = 100;
            this.crosshair.maximumFade = 0.1;
            this.crosshair.speedMultiplier = 2.5;
        }
    }

    public static class SimpleComponent
    extends IComponent {
        @SerialEntry
        public boolean active = true;

        SimpleComponent() {
        }
    }

    public static class IComponent {
    }

    public static class AdvancedFadeOnlyComponent {
        @Translation(key="autohud.option.advanced.speedMultiplier")
        @FloatingPointRange(min=0.1, max=5.0, interval=0.1)
        @SerialEntry
        public double speedMultiplier = -1.0;
        @Translation(key="autohud.option.advanced.maximumFade")
        @FloatingPointRange(min=0.0, max=1.0, interval=0.1)
        @SerialEntry
        public double maximumFade = -1.0;

        AdvancedFadeOnlyComponent() {
        }
    }

    public static class AdvancedComponent {
        @Translation(key="autohud.option.advanced.direction")
        @SerialEntry
        public ScrollDirection direction = ScrollDirection.Down;
        @Translation(key="autohud.option.advanced.speedMultiplier")
        @FloatingPointRange(min=0.1, max=5.0, interval=0.1)
        @SerialEntry
        public double speedMultiplier = -1.0;
        @Translation(key="autohud.option.advanced.distance")
        @NumericRange(min=0L, max=200L, interval=5L)
        @SerialEntry
        public int distance = -1;
        @Translation(key="autohud.option.advanced.maximumFade")
        @FloatingPointRange(min=0.0, max=1.0, interval=0.1)
        @SerialEntry
        public double maximumFade = -1.0;

        AdvancedComponent() {
        }
    }
}

