/*
 * Decompiled with CFR 0.152.
 */
package mod.crend.autohud.component.state;

import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.objects.ObjectIntMutablePair;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import mod.crend.autohud.component.Component;
import mod.crend.autohud.component.state.ValueComponentState;
import mod.crend.autohud.mixin.TeamMixinAccessor;
import net.minecraft.class_2561;
import net.minecraft.class_266;
import net.minecraft.class_267;
import net.minecraft.class_268;
import net.minecraft.class_269;
import net.minecraft.class_310;

public class ScoreboardComponentState
extends ValueComponentState<class_266> {
    class_2561 cachedDisplayName;
    Map<String, Pair<class_268, Integer>> cachedTeams = new HashMap<String, Pair<class_268, Integer>>();
    Map<String, Pair<String, Integer>> cachedPlayerScores = new HashMap<String, Pair<String, Integer>>();

    public ScoreboardComponentState(Component component) {
        super(component, ScoreboardComponentState::createObjective, true);
        this.collectPlayerScores((class_266)this.oldValue);
    }

    private static class_266 createObjective() {
        int teamColorIndex;
        class_269 scoreboard = class_310.method_1551().field_1687.method_8428();
        class_266 objectiveToUse = null;
        class_268 playerTeam = scoreboard.method_1164(class_310.method_1551().field_1724.method_5820());
        if (playerTeam != null && (teamColorIndex = playerTeam.method_1202().method_536()) >= 0) {
            objectiveToUse = scoreboard.method_1189(3 + teamColorIndex);
        }
        if (objectiveToUse == null) {
            objectiveToUse = scoreboard.method_1189(1);
        }
        return objectiveToUse;
    }

    @Override
    protected void onUpdateReveal(class_266 newObjective) {
        if (!Objects.equals(newObjective, this.oldValue)) {
            this.collectPlayerScores(newObjective);
        }
    }

    private void collectPlayerScores(class_266 objective) {
        if (objective == null) {
            return;
        }
        this.cachedTeams.clear();
        this.cachedPlayerScores.clear();
        this.cachedDisplayName = objective.method_1114();
        objective.method_1117().method_1184(objective).forEach(this::addPlayerScoreAndTeam);
    }

    private void addPlayerScoreAndTeam(class_267 playerScore) {
        class_268 playerTeam = playerScore.method_1127().method_1117().method_1164(playerScore.method_1129());
        String teamName = playerTeam == null ? null : playerTeam.method_1197();
        this.cachedPlayerScores.put(playerScore.method_1129(), (Pair<String, Integer>)new ObjectIntMutablePair((Object)teamName, playerScore.method_1126()));
        if (teamName == null) {
            return;
        }
        if (this.cachedTeams.containsKey(teamName)) {
            Pair<class_268, Integer> teamEntry = this.cachedTeams.get(teamName);
            teamEntry.right((Object)((Integer)teamEntry.right() + 1));
        } else {
            this.cachedTeams.put(teamName, (Pair<class_268, Integer>)new ObjectIntMutablePair((Object)ScoreboardComponentState.copyTeam(playerTeam), 1));
        }
    }

    public void updateObjectiveDisplayName(class_266 objective) {
        class_2561 newDisplayName;
        if (Objects.equals(this.oldValue, objective) && !ScoreboardComponentState.isTextEqual(newDisplayName = objective.method_1114(), this.cachedDisplayName)) {
            this.cachedDisplayName = newDisplayName;
            this.component.revealCombined();
        }
    }

    public void onPlayerScoreUpdate(class_267 playerScore) {
        if (Objects.equals(this.oldValue, playerScore.method_1127())) {
            if (this.cachedPlayerScores.containsKey(playerScore.method_1129())) {
                Pair<String, Integer> cachedTeamAndScore = this.cachedPlayerScores.get(playerScore.method_1129());
                if (cachedTeamAndScore.right() == null || ((Integer)cachedTeamAndScore.right()).intValue() != playerScore.method_1126()) {
                    this.component.revealCombined();
                    cachedTeamAndScore.right((Object)playerScore.method_1126());
                }
            } else {
                this.addPlayerScoreAndTeam(playerScore);
            }
        }
    }

    public void onPlayerScoreRemove(String playerName) {
        if (this.cachedPlayerScores.containsKey(playerName)) {
            Pair<String, Integer> cachedTeamAndScore = this.cachedPlayerScores.get(playerName);
            if (cachedTeamAndScore.left() != null && this.cachedTeams.containsKey(cachedTeamAndScore.left())) {
                this.onTeamRemovedFromPlayer((class_268)this.cachedTeams.get(cachedTeamAndScore.left()).left());
            }
            this.cachedPlayerScores.remove(playerName);
        }
    }

    public void onPlayerScoreRemove(String playerName, class_266 objective) {
        if (Objects.equals(this.oldValue, objective)) {
            this.onPlayerScoreRemove(playerName);
        }
    }

    public void onTeamRemoved(class_268 team) {
        if (this.cachedPlayerScores.isEmpty()) {
            return;
        }
        boolean revealComponent = false;
        Iterator<Map.Entry<String, Pair<String, Integer>>> scores = this.cachedPlayerScores.entrySet().iterator();
        while (scores.hasNext()) {
            Pair<String, Integer> cachedPair = scores.next().getValue();
            if (!Objects.equals(cachedPair.left(), team.method_1197())) continue;
            cachedPair.left(null);
            revealComponent = true;
        }
        this.cachedTeams.remove(team.method_1197());
        if (revealComponent) {
            this.component.revealCombined();
        }
    }

    public void onTeamUpdated(class_268 team) {
        if (this.cachedTeams.isEmpty() || !this.cachedTeams.containsKey(team.method_1197())) {
            return;
        }
        Pair<class_268, Integer> cachedTeam = this.cachedTeams.get(team.method_1197());
        if (!ScoreboardComponentState.isTeamEqual(team, (class_268)cachedTeam.left())) {
            this.component.revealCombined();
            cachedTeam.left((Object)ScoreboardComponentState.copyTeam(team));
        }
    }

    public void onPlayerAddedToTeam(String playerName, class_268 team) {
        if (this.cachedPlayerScores.isEmpty()) {
            return;
        }
        Pair<String, Integer> cachedTeamAndScore = this.cachedPlayerScores.get(playerName);
        if (cachedTeamAndScore == null) {
            return;
        }
        if (!Objects.equals(cachedTeamAndScore.left(), team.method_1197())) {
            boolean cachedTeamHasDifferences;
            boolean cachedPlayerTeamIsEmpty = cachedTeamAndScore.left() == null;
            Pair<class_268, Integer> cachedTeam = cachedPlayerTeamIsEmpty ? null : this.cachedTeams.get(cachedTeamAndScore.left());
            boolean bl = cachedTeamHasDifferences = !cachedPlayerTeamIsEmpty && cachedTeam != null && !ScoreboardComponentState.isTeamEqual(team, (class_268)cachedTeam.left());
            if (cachedPlayerTeamIsEmpty || cachedTeamHasDifferences) {
                if (cachedTeamHasDifferences) {
                    this.onTeamRemovedFromPlayer((class_268)cachedTeam.left());
                }
                this.component.revealCombined();
                cachedTeamAndScore.left((Object)team.method_1197());
                this.onTeamAddedToPlayer(team);
            }
        }
    }

    public void onPlayerRemovedFromTeam(String playerName, class_268 team) {
        if (this.cachedPlayerScores.isEmpty()) {
            return;
        }
        Pair<String, Integer> cachedTeamAndScore = this.cachedPlayerScores.get(playerName);
        if (cachedTeamAndScore != null && Objects.equals(cachedTeamAndScore.left(), team.method_1197())) {
            this.component.revealCombined();
            cachedTeamAndScore.left(null);
            this.onTeamRemovedFromPlayer(team);
        }
    }

    private void onTeamAddedToPlayer(class_268 teamAddedTo) {
        Pair<class_268, Integer> cachedTeam = this.cachedTeams.get(teamAddedTo.method_1197());
        if (cachedTeam == null) {
            this.cachedTeams.put(teamAddedTo.method_1197(), (Pair<class_268, Integer>)new ObjectIntMutablePair((Object)ScoreboardComponentState.copyTeam(teamAddedTo), 1));
        } else {
            cachedTeam.right((Object)((Integer)cachedTeam.right() + 1));
        }
    }

    private void onTeamRemovedFromPlayer(class_268 teamRemovedFrom) {
        Pair<class_268, Integer> cachedTeam = this.cachedTeams.get(teamRemovedFrom.method_1197());
        if (cachedTeam == null) {
            return;
        }
        if ((Integer)cachedTeam.right() - 1 < 1) {
            this.cachedTeams.remove(teamRemovedFrom.method_1197());
        } else {
            cachedTeam.right((Object)((Integer)cachedTeam.right() - 1));
        }
    }

    private static boolean isTeamEqual(class_268 team, class_268 cachedTeam) {
        if (team == cachedTeam) {
            return true;
        }
        if (team == null || cachedTeam == null) {
            return false;
        }
        return team.method_1197().equals(cachedTeam.method_1197()) && team.method_1202() == cachedTeam.method_1202() && ScoreboardComponentState.isTextEqual(team.method_1140(), cachedTeam.method_1140()) && ScoreboardComponentState.isTextEqual(team.method_1144(), cachedTeam.method_1144()) && ScoreboardComponentState.isTextEqual(team.method_1136(), cachedTeam.method_1136());
    }

    private static boolean isTextEqual(class_2561 left, class_2561 right) {
        boolean rightIsEmpty;
        boolean leftIsEmpty = left == null;
        boolean bl = rightIsEmpty = right == null;
        if (leftIsEmpty && rightIsEmpty) {
            return true;
        }
        if (leftIsEmpty != rightIsEmpty) {
            return false;
        }
        return left.getString().equals(right.getString());
    }

    private static class_268 copyTeam(class_268 team) {
        class_268 copiedTeam = new class_268(null, team.method_1197());
        ((TeamMixinAccessor)copiedTeam).autohud$setDisplayName(team.method_1140());
        ((TeamMixinAccessor)copiedTeam).autohud$setColor(team.method_1202());
        ScoreboardComponentState.teamSetPrefix(copiedTeam, team.method_1144());
        ScoreboardComponentState.teamSetSuffix(copiedTeam, team.method_1136());
        return copiedTeam;
    }

    private static void teamSetPrefix(class_268 copiedTeam, class_2561 prefix) {
        ((TeamMixinAccessor)copiedTeam).autohud$setPrefix((class_2561)(prefix == null ? class_2561.method_43473() : prefix.method_27661()));
    }

    private static void teamSetSuffix(class_268 copiedTeam, class_2561 suffix) {
        ((TeamMixinAccessor)copiedTeam).autohud$setSuffix((class_2561)(suffix == null ? class_2561.method_43473() : suffix.method_27661()));
    }
}

