/*
 * Decompiled with CFR 0.152.
 */
package mod.crend.autohud.component.state;

import java.util.function.Supplier;
import mod.crend.autohud.component.Component;
import mod.crend.autohud.component.Hud;
import mod.crend.autohud.component.state.ValueComponentState;
import mod.crend.autohud.config.ConfigHandler;
import mod.crend.autohud.config.RevealPolicy;

public class PolicyComponentState
extends ValueComponentState<Integer> {
    protected Supplier<Integer> maxValueSupplier;

    public PolicyComponentState(Component component, Supplier<Integer> newValueSupplier, Supplier<Integer> maxValueSupplier, boolean updateEveryTick) {
        super(component, newValueSupplier, updateEveryTick);
        this.maxValueSupplier = maxValueSupplier;
    }

    public PolicyComponentState(Component component, Supplier<Integer> newValueSupplier, Supplier<Integer> maxValueSupplier) {
        this(component, newValueSupplier, maxValueSupplier, false);
    }

    public PolicyComponentState(Component component, Supplier<Integer> newValueSupplier, Integer maxValueSupplier, boolean updateEveryTick) {
        this(component, newValueSupplier, () -> maxValueSupplier, updateEveryTick);
    }

    public PolicyComponentState(Component component, Supplier<Integer> newValueSupplier, Integer maxValueSupplier) {
        this(component, newValueSupplier, maxValueSupplier, false);
    }

    @Override
    protected boolean doReveal(Integer newValue) {
        return switch (((ConfigHandler.PolicyComponent)this.component.config).policy()) {
            default -> throw new IncompatibleClassChangeError();
            case RevealPolicy.NotFull -> {
                if (newValue < this.maxValueSupplier.get()) {
                    yield true;
                }
                yield false;
            }
            case RevealPolicy.Low -> {
                if (newValue <= this.maxValueSupplier.get() / 3) {
                    yield true;
                }
                yield false;
            }
            case RevealPolicy.Increasing -> {
                if (newValue > (Integer)this.oldValue) {
                    yield true;
                }
                yield false;
            }
            case RevealPolicy.Decreasing -> {
                if (newValue < (Integer)this.oldValue) {
                    yield true;
                }
                yield false;
            }
            case RevealPolicy.Changing -> {
                if (!newValue.equals(this.oldValue)) {
                    yield true;
                }
                yield false;
            }
            case RevealPolicy.Disabled -> {
                if (!Hud.actDynamic()) {
                    yield true;
                }
                yield false;
            }
            case RevealPolicy.Always -> true;
        };
    }
}

