/*
 * Decompiled with CFR 0.152.
 */
package mod.crend.autohud.component;

import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mod.crend.autohud.AutoHud;
import mod.crend.autohud.component.Component;
import mod.crend.autohud.component.state.BooleanComponentState;
import mod.crend.autohud.component.state.ComponentState;
import mod.crend.autohud.component.state.EnhancedPolicyComponentState;
import mod.crend.autohud.component.state.ItemStackComponentState;
import mod.crend.autohud.component.state.PolicyComponentState;
import mod.crend.autohud.component.state.ScoreboardComponentState;
import mod.crend.autohud.component.state.ValueComponentState;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1812;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_239;
import net.minecraft.class_310;
import net.minecraft.class_5151;
import net.minecraft.class_746;

public class State {
    private Map<class_1291, class_1293> previousStatusEffects;
    private class_1799 previousItemStack;

    public State(class_746 player) {
        this.initStates(player);
        this.previousStatusEffects = new HashMap<class_1291, class_1293>();
        this.previousItemStack = player.method_6047().method_7972();
    }

    public void initStates(class_746 player) {
        Component.Hotbar.state = new ItemStackComponentState(Component.Hotbar, () -> ((class_746)player).method_6047(), true);
        Component.Tooltip.state = new ItemStackComponentState(Component.Tooltip, () -> ((class_746)player).method_6047(), true);
        Component.Health.state = new EnhancedPolicyComponentState(Component.Health, () -> (int)player.method_6032(), () -> (int)player.method_6063(), this::canHeal);
        Component.Hunger.state = new EnhancedPolicyComponentState(Component.Hunger, () -> player.method_7344().method_7586(), (Integer)20, () -> player.method_7344().method_7586() < 20 && player.method_6047().method_19267());
        Component.Armor.state = new EnhancedPolicyComponentState(Component.Armor, () -> ((class_746)player).method_6096(), 20, () -> {
            class_5151 equipment;
            class_1792 patt0$temp = player.method_6047().method_7909();
            return patt0$temp instanceof class_5151 && (equipment = (class_5151)patt0$temp).method_7685().method_46643() && player.method_18397(player.method_6047());
        }, true);
        Component.Air.state = new PolicyComponentState(Component.Air, () -> ((class_746)player).method_5669(), () -> ((class_746)player).method_5748());
        Component.ExperienceBar.state = new ValueComponentState<Integer>(Component.ExperienceBar, () -> player.field_7495, true);
        Component.Scoreboard.state = new ScoreboardComponentState(Component.Scoreboard);
        Component.MountJumpBar.state = new ComponentState(Component.MountJumpBar);
        Component.Crosshair.state = new BooleanComponentState(Component.Crosshair, State::shouldShowCrosshair);
        AutoHud.apis.forEach(api -> api.initState(player));
    }

    private static boolean shouldShowCrosshair() {
        class_239 hitResult = class_310.method_1551().field_1765;
        return hitResult != null && hitResult.method_17783() != class_239.class_240.field_1333;
    }

    private boolean isHealEffect(class_1293 effect) {
        return effect.method_5579() == class_1294.field_5924 || effect.method_5579() == class_1294.field_5915 || effect.method_5579() == class_1294.field_5914 || effect.method_5579() == class_1294.field_5898;
    }

    private boolean canHeal() {
        block3: {
            class_1799 itemStack;
            block2: {
                itemStack = class_310.method_1551().field_1724.method_6047();
                if (!itemStack.method_19267()) break block2;
                List statusEffects = itemStack.method_7909().method_19264().method_19235();
                for (Pair effect : statusEffects) {
                    if (!this.isHealEffect((class_1293)effect.getFirst())) continue;
                    return true;
                }
                break block3;
            }
            if (!(itemStack.method_7909() instanceof class_1812)) break block3;
            class_1842 potion = class_1844.method_8063((class_1799)itemStack);
            for (class_1293 effect : potion.method_8049()) {
                if (!this.isHealEffect(effect)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean revealHotbarOnDurability(class_1799 itemStack) {
        if (itemStack.method_7963() && (double)itemStack.method_7919() >= (double)(100 - AutoHud.config.getHotbarDurabilityPercentage()) / 100.0 * (double)itemStack.method_7936() && itemStack.method_7936() - itemStack.method_7919() < AutoHud.config.getHotbarDurabilityTotal()) {
            Component.Hotbar.revealCombined();
            Component.Tooltip.revealCombined();
            return true;
        }
        return false;
    }

    public void tick(class_746 player) {
        if (player == null) {
            return;
        }
        class_1799 mainHandStack = player.method_6047();
        if (!class_1799.method_7973((class_1799)mainHandStack, (class_1799)this.previousItemStack)) {
            this.previousItemStack = mainHandStack.method_7972();
            Component.Health.state.updateNextTick();
            Component.Hunger.state.updateNextTick();
            Component.Armor.state.updateNextTick();
        }
        Component.tickAll();
        if (AutoHud.config.isHotbarOnLowDurability() && !this.revealHotbarOnDurability(player.method_6047())) {
            this.revealHotbarOnDurability(player.method_6079());
        }
        if (AutoHud.config.statusEffects().active()) {
            if (AutoHud.config.statusEffects().onChange()) {
                HashMap<class_1291, class_1293> newStatusEffects = new HashMap<class_1291, class_1293>();
                Map effects = player.method_6088();
                for (class_1291 effect : effects.keySet()) {
                    class_1293 effectInstance = (class_1293)effects.get(effect);
                    if (!effectInstance.method_5592()) continue;
                    if (effectInstance.method_5584() < 5) {
                        Component.get(effect).hide();
                    } else if (!this.previousStatusEffects.containsKey(effect)) {
                        Component.get(effect).revealFromHidden();
                    } else if (!AutoHud.config.hidePersistentStatusEffects() || !this.previousStatusEffects.get(effect).equals((Object)effectInstance)) {
                        Component.get(effect).reveal();
                    }
                    newStatusEffects.put(effect, new class_1293(effectInstance));
                }
                this.previousStatusEffects = newStatusEffects;
            }
        } else {
            Component.getStatusEffectComponents().forEach(Component::reveal);
            if (AutoHud.config.hidePersistentStatusEffects()) {
                HashMap<class_1291, class_1293> newStatusEffects = new HashMap<class_1291, class_1293>();
                Map effects = player.method_6088();
                for (class_1291 effect : effects.keySet()) {
                    class_1293 effectInstance = (class_1293)effects.get(effect);
                    if (!effectInstance.method_5592()) continue;
                    if (this.previousStatusEffects.containsKey(effect) && this.previousStatusEffects.get(effect).equals((Object)effectInstance)) {
                        Component.get(effect).hideNow();
                    }
                    newStatusEffects.put(effect, new class_1293(effectInstance));
                }
                this.previousStatusEffects = newStatusEffects;
            }
        }
        AutoHud.apis.forEach(api -> api.tickState(player));
    }
}

