/*
 * Decompiled with CFR 0.152.
 */
package mod.crend.autohud.component;

import mod.crend.autohud.AutoHud;
import mod.crend.autohud.component.Component;
import mod.crend.autohud.component.state.ScoreboardComponentState;
import net.minecraft.class_266;
import net.minecraft.class_267;
import net.minecraft.class_268;

public class ScoreboardHelper {
    public static void onObjectiveUpdate(class_266 objective) {
        if (ScoreboardHelper.canUpdate() && AutoHud.config.shouldRevealScoreboardOnTitleChange()) {
            ScoreboardHelper.getScoreboardComponent().updateObjectiveDisplayName(objective);
        }
    }

    public static void onPlayerScoreUpdate(class_267 score) {
        if (ScoreboardHelper.canUpdate() && AutoHud.config.shouldRevealScoreboardOnScoreChange()) {
            ScoreboardHelper.getScoreboardComponent().onPlayerScoreUpdate(score);
        }
    }

    public static void onPlayerScoreRemove(String playerName) {
        if (ScoreboardHelper.canUpdate() && AutoHud.config.shouldRevealScoreboardOnScoreChange()) {
            ScoreboardHelper.getScoreboardComponent().onPlayerScoreRemove(playerName);
        }
    }

    public static void onPlayerScoreRemove(String playerName, class_266 objective) {
        if (ScoreboardHelper.canUpdate() && AutoHud.config.shouldRevealScoreboardOnScoreChange()) {
            ScoreboardHelper.getScoreboardComponent().onPlayerScoreRemove(playerName, objective);
        }
    }

    public static void onTeamRemoved(class_268 team) {
        if (ScoreboardHelper.canUpdate() && AutoHud.config.shouldRevealScoreboardOnTeamChange()) {
            ScoreboardHelper.getScoreboardComponent().onTeamRemoved(team);
        }
    }

    public static void onTeamUpdated(class_268 team) {
        if (ScoreboardHelper.canUpdate() && AutoHud.config.shouldRevealScoreboardOnTeamChange()) {
            ScoreboardHelper.getScoreboardComponent().onTeamUpdated(team);
        }
    }

    public static void onPlayerAddedToTeam(String playerName, class_268 team) {
        if (ScoreboardHelper.canUpdate() && AutoHud.config.shouldRevealScoreboardOnTeamChange()) {
            ScoreboardHelper.getScoreboardComponent().onPlayerAddedToTeam(playerName, team);
        }
    }

    public static void onPlayerRemovedFromTeam(String playerName, class_268 team) {
        if (ScoreboardHelper.canUpdate() && AutoHud.config.shouldRevealScoreboardOnTeamChange()) {
            ScoreboardHelper.getScoreboardComponent().onPlayerRemovedFromTeam(playerName, team);
        }
    }

    private static boolean canUpdate() {
        return AutoHud.config != null && Component.Scoreboard.config.active() && Component.Scoreboard.state != null;
    }

    private static ScoreboardComponentState getScoreboardComponent() {
        return (ScoreboardComponentState)Component.Scoreboard.state;
    }
}

