/*
 * Decompiled with CFR 0.152.
 */
package mod.crend.autohud.component;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mod.crend.autohud.AutoHud;
import mod.crend.autohud.component.Hud;
import mod.crend.autohud.component.state.ComponentState;
import mod.crend.autohud.config.ConfigHandler;
import mod.crend.autohud.config.ScrollDirection;
import net.minecraft.class_1058;
import net.minecraft.class_1291;
import net.minecraft.class_310;
import net.minecraft.class_4074;

public class Component {
    private static final List<Component> mainHudComponents = new ArrayList<Component>();
    public static Component Armor = new Component("Armor", (ConfigHandler.IComponent)AutoHud.config.armor(), true);
    public static Component Health = new Component("Health", AutoHud.config.health(), List.of(Armor), true);
    public static Component Air = new Component("Air", (ConfigHandler.IComponent)AutoHud.config.air(), true);
    public static Component Hunger = new Component("Hunger", AutoHud.config.hunger(), List.of(Air), true);
    public static Component MountHealth = new Component("MountHealth", AutoHud.config.mountHealth(), List.of(Air), true);
    public static Component MountJumpBar = new Component("MountJumpBar", (ConfigHandler.IComponent)AutoHud.config.mountJumpBar(), true);
    public static Component ExperienceBar = new Component("ExperienceBar", AutoHud.config.experience(), List.of(Health, Hunger, MountHealth), true);
    public static Component Hotbar = new Component("Hotbar", AutoHud.config.hotbar(), List.of(ExperienceBar), true);
    public static Component Tooltip = new Component("Tooltip", (ConfigHandler.IComponent)AutoHud.config.hotbar(), true);
    public static Component Scoreboard = new Component("Scoreboard", AutoHud.config.scoreboard());
    public static Component Crosshair = new Component("Crosshair", AutoHud.config.crosshair());
    private static final Map<class_1291, Component> statusEffectComponents = new HashMap<class_1291, Component>();
    private static final List<Component> components = new ArrayList<Component>(List.of(Hotbar, Tooltip, ExperienceBar, Armor, Health, Hunger, Air, MountHealth, MountJumpBar, Scoreboard, Crosshair));
    public final ConfigHandler.IComponent config;
    public ComponentState state = null;
    private final List<Component> stackComponents;
    private double alpha = 1.0;
    private double alphaDelta = 0.0;
    private double offset = 0.0;
    private double offsetDelta = 0.0;
    public final String name;
    private final boolean inMainHud;
    private float visibleTime = 1.0f;

    public static void registerComponent(Component component) {
        components.add(component);
    }

    public static void revealAll() {
        components.forEach(Component::revealCombined);
        statusEffectComponents.values().forEach(Component::revealCombined);
    }

    public static void hideAll() {
        components.forEach(Component::hide);
        statusEffectComponents.values().forEach(Component::hide);
    }

    public static void tickAll() {
        components.forEach(c -> {
            if (c.state != null) {
                c.state.tick();
                c.tick();
            }
        });
        statusEffectComponents.values().forEach(Component::tick);
    }

    public Component(String name, ConfigHandler.IComponent config, List<Component> stackComponents, boolean inMainHud) {
        this.name = name;
        this.config = config;
        this.stackComponents = new ArrayList<Component>(stackComponents);
        this.inMainHud = inMainHud;
        if (inMainHud) {
            mainHudComponents.add(this);
        }
    }

    public Component(String name) {
        this(name, List.of(), false);
    }

    public Component(String name, boolean inMainHud) {
        this(name, List.of(), inMainHud);
    }

    public Component(String name, ConfigHandler.IComponent config) {
        this(name, config, List.of(), false);
    }

    public Component(String name, ConfigHandler.IComponent config, boolean inMainHud) {
        this(name, config, List.of(), inMainHud);
    }

    public Component(String name, List<Component> stackComponents) {
        this(name, ConfigHandler.None, stackComponents, false);
    }

    public Component(String name, List<Component> stackComponents, boolean inMainHud) {
        this(name, ConfigHandler.None, stackComponents, inMainHud);
    }

    public Component(String name, ConfigHandler.IComponent config, List<Component> stackComponents) {
        this(name, config, stackComponents, false);
    }

    public static void register(class_1291 effect) {
        if (!statusEffectComponents.containsKey(effect)) {
            Component c = new Component(effect.method_5567(), AutoHud.config.statusEffects());
            c.offset = 1.0;
            c.alpha = 0.0;
            statusEffectComponents.put(effect, c);
        }
    }

    public static Component get(class_1291 effect) {
        Component.register(effect);
        return statusEffectComponents.get(effect);
    }

    public static Collection<Component> getComponents() {
        return components;
    }

    public static Collection<Component> getStatusEffectComponents() {
        return statusEffectComponents.values();
    }

    public static Component findBySprite(class_1058 sprite) {
        class_4074 statusEffectSpriteManager = class_310.method_1551().method_18505();
        for (class_1291 effect : statusEffectComponents.keySet()) {
            if (statusEffectSpriteManager.method_18663(effect) != sprite) continue;
            return statusEffectComponents.get(effect);
        }
        return null;
    }

    public double getOffsetX(float tickDelta) {
        if (!AutoHud.config.animationMove() && AutoHud.config.animationFade()) {
            return 0.0;
        }
        return switch (this.config.direction()) {
            default -> throw new IncompatibleClassChangeError();
            case ScrollDirection.Up, ScrollDirection.Down -> 0.0;
            case ScrollDirection.Left -> -(this.offset + (double)tickDelta * this.offsetDelta) * (double)this.config.distance();
            case ScrollDirection.Right -> (this.offset + (double)tickDelta * this.offsetDelta) * (double)this.config.distance();
        };
    }

    public double getOffsetY(float tickDelta) {
        if (!AutoHud.config.animationMove() && AutoHud.config.animationFade()) {
            return 0.0;
        }
        return switch (this.config.direction()) {
            default -> throw new IncompatibleClassChangeError();
            case ScrollDirection.Up -> -(this.offset + (double)tickDelta * this.offsetDelta) * (double)this.config.distance();
            case ScrollDirection.Down -> (this.offset + (double)tickDelta * this.offsetDelta) * (double)this.config.distance();
            case ScrollDirection.Left, ScrollDirection.Right -> 0.0;
        };
    }

    public float getAlpha(float tickDelta) {
        if (!AutoHud.config.animationFade()) {
            return 1.0f;
        }
        return (float)((1.0 - this.config.maximumFade()) * (this.alpha + (double)tickDelta * this.alphaDelta) + this.config.maximumFade());
    }

    public boolean isHidden() {
        return !this.fullyRevealed();
    }

    public void revealFromHidden() {
        this.offset = 1.0;
        this.alpha = 0.0;
        this.offsetDelta = 0.0;
        this.alphaDelta = 0.0;
        this.reveal();
    }

    public void reveal() {
        this.visibleTime = AutoHud.config.timeRevealed();
    }

    public void revealCombined() {
        this.visibleTime = AutoHud.config.timeRevealed();
        if (this.config.active()) {
            switch (AutoHud.config.revealType()) {
                case Combined: {
                    components.forEach(c -> {
                        c.visibleTime = Math.max(c.visibleTime, this.visibleTime);
                    });
                    break;
                }
                case HideCombined: {
                    components.forEach(c -> c.keepRevealed(this.visibleTime));
                    break;
                }
                case Stacked: {
                    this.keepRevealedStacked(this.visibleTime);
                    break;
                }
                case Grouped: {
                    this.revealGrouped(this.visibleTime);
                    break;
                }
            }
        }
    }

    private void revealGrouped(float visibleTime) {
        if (this.inMainHud) {
            mainHudComponents.forEach(c -> {
                c.visibleTime = Math.max(c.visibleTime, visibleTime);
            });
        }
    }

    private void keepRevealedStacked(float visibleTime) {
        this.keepRevealed(visibleTime);
        this.stackComponents.forEach(c -> c.keepRevealedStacked(visibleTime));
    }

    public void addStackComponent(Component component) {
        this.stackComponents.add(component);
    }

    public void revealNow() {
        this.visibleTime = AutoHud.config.timeRevealed();
        this.offset = 0.0;
        this.offsetDelta = 0.0;
        this.alpha = 1.0;
        this.alphaDelta = 0.0;
    }

    public void hideNow() {
        this.visibleTime = 0.0f;
        this.offset = 1.0;
        this.alpha = 0.0;
        this.offsetDelta = 0.0;
        this.alphaDelta = 0.0;
    }

    public void hide() {
        if (!this.config.active()) {
            return;
        }
        this.visibleTime = 0.0f;
        if (this.state != null) {
            this.state.updateNextTick();
        }
    }

    private boolean fullyRevealed() {
        return this.offset == 0.0 && this.alpha == 1.0;
    }

    public boolean fullyHidden() {
        return this.offset == 1.0 && this.alpha == 0.0;
    }

    private void keepRevealed(float time) {
        if (this.config.active() && this.visibleTime > 0.0f && this.visibleTime < time) {
            this.visibleTime = time;
        }
    }

    public void synchronizeFrom(Component other) {
        this.offset = Math.min(this.offset, other.offset);
        this.alpha = Math.max(this.alpha, other.alpha);
        if (other.offsetDelta < 0.0) {
            this.offsetDelta = Math.min(this.offsetDelta, other.offsetDelta);
            this.alphaDelta = Math.max(this.alphaDelta, other.alphaDelta);
        } else {
            this.offsetDelta = Math.max(this.offsetDelta, other.offsetDelta);
            this.alphaDelta = Math.min(this.alphaDelta, other.alphaDelta);
        }
        this.visibleTime = Math.max(this.visibleTime, other.visibleTime);
    }

    private void moveIn() {
        this.offset = Math.max(0.0, this.offset + this.offsetDelta);
        this.alpha = Math.min(1.0, this.alpha + this.alphaDelta);
        double offsetSpeed = Math.sqrt(0.01 + this.offset) * 0.1 * AutoHud.config.animationSpeedMoveIn() * this.config.speedMultiplier();
        double alphaSpeed = 0.05 * AutoHud.config.animationSpeedFadeIn() * this.config.speedMultiplier();
        this.offsetDelta = this.offset - offsetSpeed <= 0.0 ? -this.offset : -offsetSpeed;
        this.alphaDelta = this.alpha + alphaSpeed >= 1.0 ? 1.0 - this.alpha : alphaSpeed;
    }

    private void moveOut() {
        this.offset = Math.min(1.0, this.offset + this.offsetDelta);
        this.alpha = Math.max(0.0, this.alpha + this.alphaDelta);
        double offsetSpeed = Math.sqrt(0.01 + this.offset) * 0.1 * AutoHud.config.animationSpeedMoveOut() * this.config.speedMultiplier();
        double alphaSpeed = 0.05 * AutoHud.config.animationSpeedFadeOut() * this.config.speedMultiplier();
        this.offsetDelta = this.offset + offsetSpeed >= 1.0 ? 1.0 - this.offset : offsetSpeed;
        this.alphaDelta = this.alpha - alphaSpeed <= 0.0 ? -this.alpha : -alphaSpeed;
    }

    public void revealIf(boolean trigger) {
        if (!this.config.active() || this.config.onChange() && trigger) {
            this.revealCombined();
        }
    }

    public void updateState() {
        if (this.state != null) {
            this.state.update();
        }
    }

    public void tick() {
        if (this.visibleTime == 0.0f) {
            if (!(this.fullyHidden() || this.state != null && this.state.scheduledUpdate())) {
                if (AutoHud.config.animationNone()) {
                    this.hideNow();
                } else {
                    this.moveOut();
                }
            }
            if (this.offset == 1.0) {
                this.offsetDelta = 0.0;
            }
            if (this.alpha == 0.0) {
                this.alphaDelta = 0.0;
            }
        } else if (!this.fullyRevealed()) {
            if (AutoHud.config.animationNone()) {
                this.revealNow();
            } else {
                this.moveIn();
            }
        } else {
            if (this.offset == 0.0) {
                this.offsetDelta = 0.0;
            }
            if (this.alpha == 1.0) {
                this.alphaDelta = 0.0;
            }
        }
        if (this.config.active() && Hud.actDynamic() && this.visibleTime > 0.0f) {
            this.visibleTime = Math.max(0.0f, this.visibleTime - 1.0f);
            if (this.visibleTime == 0.0f && this.state != null) {
                this.state.updateNextTick();
            }
        }
    }
}

