/*
 * Decompiled with CFR 0.152.
 */
package com.pany.mods.entity_capturing_tool.Helpers;

import com.pany.mods.entity_capturing_tool.EntityCapturingTool;
import com.pany.mods.entity_capturing_tool.Helpers.ContainedObject;
import com.pany.mods.entity_capturing_tool.Helpers.ContainmentHandler;
import com.pany.mods.entity_capturing_tool.blocks.endercageblock.EnderCageEntity;
import com.pany.mods.entity_capturing_tool.entities.Unknownentity;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_7923;
import net.minecraft.class_898;

public class ContainmentRenderingObject {
    public CageAnimation CageAnim = new CageAnimation();
    private List<Object[]> ErrorEntities = new ArrayList<Object[]>();
    private class_1297 RenderEntity = null;
    private class_1299<?> RenderEntityType = null;
    private class_2487 MobData = null;
    private String MobId = null;
    private class_2487 MobNbt = null;
    private Object BoundTo = null;
    private BoundType BoundObjType = BoundType.Null;
    public boolean IsErrored = false;
    public boolean Dirty = false;
    public int ticks = 0;
    private static final List<String> NbtNotToInclude = new ArrayList<String>();

    public ContainmentRenderingObject() {
        this.ticks = (int)(Math.random() * 1000.0);
    }

    public ContainmentRenderingObject(class_2487 nbtCompound) {
        this.ReadData(nbtCompound);
        this.ticks = (int)(Math.random() * 1000.0);
    }

    public ContainmentRenderingObject(class_1799 stack) {
        this.SetBoundTo(stack);
        this.ReadData(stack);
        this.ticks = (int)(Math.random() * 1000.0);
    }

    public ContainmentRenderingObject(EnderCageEntity cageEntity) {
        this.SetBoundTo((Object)cageEntity);
        this.ReadData(cageEntity.ContainedEntity.ToNbtOrEmpty());
        this.ticks = (int)(Math.random() * 1000.0);
    }

    public void ReadData(class_1799 stack) {
        this.ReadData(class_1747.method_38072((class_1799)stack));
    }

    public void ReadData(ContainedObject containedObject) {
        this.IsErrored = false;
        this.MobId = containedObject.GetMobType();
        this.SetNbt(containedObject.GetEntityNbt());
        this.MobData = containedObject.ToNbtOrEmpty();
        this.SetBoundTo(containedObject.GetBoundObject());
    }

    public void ReadData(class_2487 nbt) {
        this.IsErrored = false;
        if ((nbt = ContainmentHandler.GetThisOrContainedNbt(nbt)) != null && nbt.method_10545("mobid")) {
            this.MobId = nbt.method_10558("mobid");
            if (ContainmentRenderingObject.GetEntityType(this.MobId) == null) {
                this.FlushData();
                return;
            }
            if (nbt.method_10545("mobnbt")) {
                this.SetNbt(nbt.method_10562("mobnbt"));
            }
            this.MobData = nbt;
            this.Dirty = true;
        }
    }

    public String GetMobId() {
        return this.MobId;
    }

    public void FlushData() {
        this.RenderEntity = null;
        this.MobNbt = null;
        this.MobId = null;
        this.MobData = null;
        this.RenderEntityType = null;
        this.Dirty = true;
        this.IsErrored = false;
    }

    public void SetBoundTo(Object obj) {
        this.IsErrored = false;
        this.BoundTo = obj;
        this.BoundObjType = obj instanceof class_1799 ? BoundType.Item : (obj instanceof EnderCageEntity ? BoundType.Block : BoundType.Null);
    }

    public void MarkErrored() {
        this.IsErrored = true;
    }

    private boolean ContainsEntity() {
        return ContainmentRenderingObject.GetEntityType(this.MobId) != null;
    }

    public class_1297 GetRenderEntity(class_1937 world) {
        class_1799 stack;
        if (world == null) {
            return null;
        }
        if (this.IsErrored) {
            return this.GetErrorEntity(world);
        }
        ++this.ticks;
        if (this.BoundObjType == BoundType.Item && (stack = (class_1799)this.BoundTo).GetIfRenderDirty()) {
            this.Dirty = true;
            stack.SetIfRenderDirty(false);
        }
        class_1297 CurrentRenderEntity = this.RenderEntity;
        if (this.ticks % 10 == 0 || this.Dirty) {
            if (this.ContainsEntity() == (CurrentRenderEntity == null) || this.ContainsEntity() && CurrentRenderEntity != null && ContainmentRenderingObject.GetEntityType(this.MobId) != this.RenderEntityType) {
                CurrentRenderEntity = ContainmentRenderingObject.GetEntity(this.MobId, world);
            }
            if (CurrentRenderEntity != null) {
                CurrentRenderEntity.method_5651(this.MobNbt);
            }
        }
        if (CurrentRenderEntity != null) {
            CurrentRenderEntity.method_36457(0.0f);
            CurrentRenderEntity.method_36456(0.0f);
            CurrentRenderEntity.method_5847(0.0f);
        }
        this.RenderEntity = CurrentRenderEntity;
        this.RenderEntityType = CurrentRenderEntity != null ? CurrentRenderEntity.method_5864() : null;
        return CurrentRenderEntity;
    }

    public Unknownentity GetErrorEntity(class_1937 world) {
        Unknownentity Return = null;
        for (Object[] errordata : this.ErrorEntities) {
            if ((class_1937)errordata[0] != world) continue;
            Return = (Unknownentity)((Object)errordata[1]);
        }
        if (Return == null) {
            Return = new Unknownentity(EntityCapturingTool.UnknownEntityType, world);
            Object[] Data = new Object[]{world, Return};
            this.ErrorEntities.add(Data);
        }
        return Return;
    }

    public void SetNbt(class_2487 nbt) {
        if (nbt != null) {
            for (String avoided : NbtNotToInclude) {
                if (!nbt.method_10545(avoided)) continue;
                nbt.method_10551(avoided);
            }
        }
        this.MobNbt = nbt;
        this.Dirty = true;
    }

    public void Render(class_898 renderDispatcher, class_1297 entity, float x, float y, float z, float yaw, float tickdelta, class_4587 matrices, class_4597 vertexConsumers, int light) {
        block6: {
            int StackSize;
            int PreviousStackSize;
            block5: {
                Deque Stack = matrices.field_20898;
                if (Stack == null) {
                    return;
                }
                PreviousStackSize = Stack.size();
                try {
                    renderDispatcher.method_3954(entity, (double)x, (double)y, (double)z, yaw, tickdelta, matrices, vertexConsumers, light);
                }
                catch (Exception e) {
                    this.MarkErrored();
                }
                StackSize = Stack.size();
                if (PreviousStackSize <= StackSize) break block5;
                for (int i = 0; i < PreviousStackSize - StackSize; ++i) {
                    matrices.method_22903();
                }
                break block6;
            }
            if (PreviousStackSize >= StackSize) break block6;
            for (int i = 0; i < StackSize - PreviousStackSize; ++i) {
                matrices.method_22909();
            }
        }
    }

    private static class_1299 GetEntityType(String id) {
        try {
            return (class_1299)class_7923.field_41177.method_10223(new class_2960(id));
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static class_1297 GetEntity(String id, class_1937 world) {
        class_1299 type = ContainmentRenderingObject.GetEntityType(id);
        if (type != null) {
            try {
                return type.method_5883(world);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    static {
        NbtNotToInclude.add("Rotation");
        NbtNotToInclude.add("Position");
        NbtNotToInclude.add("Motion");
    }

    public static class CageAnimation {
        public class_1297 RenderEntity = null;
        public float LastEntityYaw = 0.0f;
        public float AnimProgress = 0.0f;
    }

    private static enum BoundType {
        Item,
        Block,
        Null;

    }
}

