/*
 * Decompiled with CFR 0.152.
 */
package me.fzzyhmstrs.fzzy_config.registry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.fzzyhmstrs.fzzy_config.FC;
import me.fzzyhmstrs.fzzy_config.api.ConfigApi;
import me.fzzyhmstrs.fzzy_config.config.Config;
import me.fzzyhmstrs.fzzy_config.config.ConfigContext;
import me.fzzyhmstrs.fzzy_config.impl.ConfigApiImpl;
import me.fzzyhmstrs.fzzy_config.impl.ConfigApiImplClient;
import me.fzzyhmstrs.fzzy_config.networking.ConfigSyncS2CCustomPayload;
import me.fzzyhmstrs.fzzy_config.networking.ConfigUpdateC2SCustomPayload;
import me.fzzyhmstrs.fzzy_config.networking.ConfigUpdateS2CCustomPayload;
import me.fzzyhmstrs.fzzy_config.networking.SettingForwardCustomPayload;
import me.fzzyhmstrs.fzzy_config.util.FcText;
import me.fzzyhmstrs.fzzy_config.util.ValidationResult;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_634;
import net.minecraft.class_638;
import net.minecraft.class_6860;
import net.minecraft.class_746;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010%\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J-\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0004\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0017\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0004H\u0000\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u000f\u0010\u0017\u001a\u00020\nH\u0000\u00a2\u0006\u0004\b\u0016\u0010\u0003J\u000f\u0010\u0019\u001a\u00020\nH\u0000\u00a2\u0006\u0004\b\u0018\u0010\u0003J\u0017\u0010\u001e\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u001aH\u0000\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0015\u0010!\u001a\u00020\n2\u0006\u0010 \u001a\u00020\u001f\u00a2\u0006\u0004\b!\u0010\"J7\u0010(\u001a\u00020\n2\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040#2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00040%2\u0006\u0010'\u001a\u00020\u000e\u00a2\u0006\u0004\b(\u0010)R \u0010+\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u001a0*8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b+\u0010,\u00a8\u0006-"}, d2={"Lme/fzzyhmstrs/fzzy_config/registry/SyncedConfigRegistry;", "", "<init>", "()V", "", "update", "Ljava/util/UUID;", "player", "scope", "summary", "", "forwardSetting", "(Ljava/lang/String;Ljava/util/UUID;Ljava/lang/String;Ljava/lang/String;)V", "Lnet/minecraft/class_1657;", "", "getPlayerPermissionLevel", "(Lnet/minecraft/class_1657;)I", "id", "", "hasConfig$fzzy_config", "(Ljava/lang/String;)Z", "hasConfig", "registerAll$fzzy_config", "registerAll", "registerClient$fzzy_config", "registerClient", "Lme/fzzyhmstrs/fzzy_config/config/Config;", "config", "registerConfig$fzzy_config", "(Lme/fzzyhmstrs/fzzy_config/config/Config;)V", "registerConfig", "Lnet/minecraft/class_3244;", "handler", "syncConfigs", "(Lnet/minecraft/class_3244;)V", "", "serializedConfigs", "", "changeHistory", "playerPerm", "updateServer", "(Ljava/util/Map;Ljava/util/List;I)V", "", "syncedConfigs", "Ljava/util/Map;", "fzzy_config"})
public final class SyncedConfigRegistry {
    @NotNull
    public static final SyncedConfigRegistry INSTANCE = new SyncedConfigRegistry();
    @NotNull
    private static final Map<String, Config> syncedConfigs = new LinkedHashMap();

    private SyncedConfigRegistry() {
    }

    public final void forwardSetting(@NotNull String update2, @NotNull UUID player, @NotNull String scope, @NotNull String summary) {
        Intrinsics.checkNotNullParameter((Object)update2, (String)"update");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)summary, (String)"summary");
        class_2540 buf = PacketByteBufs.create();
        SettingForwardCustomPayload settingForwardCustomPayload = new SettingForwardCustomPayload(update2, player, scope, summary);
        Intrinsics.checkNotNull((Object)buf);
        settingForwardCustomPayload.write(buf);
        ClientPlayNetworking.send((class_2960)SettingForwardCustomPayload.Companion.getId(), (class_2540)buf);
    }

    public final void updateServer(@NotNull Map<String, String> serializedConfigs, @NotNull List<String> changeHistory, int playerPerm) {
        Intrinsics.checkNotNullParameter(serializedConfigs, (String)"serializedConfigs");
        Intrinsics.checkNotNullParameter(changeHistory, (String)"changeHistory");
        class_2540 buf = PacketByteBufs.create();
        ConfigUpdateC2SCustomPayload configUpdateC2SCustomPayload = new ConfigUpdateC2SCustomPayload(serializedConfigs, changeHistory, playerPerm);
        Intrinsics.checkNotNull((Object)buf);
        configUpdateC2SCustomPayload.write(buf);
        ClientPlayNetworking.send((class_2960)ConfigUpdateC2SCustomPayload.Companion.getId(), (class_2540)buf);
    }

    public final void registerClient$fzzy_config() {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)ConfigSyncS2CCustomPayload.Companion.getId(), SyncedConfigRegistry::registerClient$lambda$1);
        ClientPlayNetworking.registerGlobalReceiver((class_2960)ConfigUpdateS2CCustomPayload.Companion.getId(), SyncedConfigRegistry::registerClient$lambda$2);
        ClientPlayNetworking.registerGlobalReceiver((class_2960)SettingForwardCustomPayload.Companion.getId(), SyncedConfigRegistry::registerClient$lambda$3);
    }

    public final void syncConfigs(@NotNull class_3244 handler) {
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        for (Map.Entry<String, Config> entry : syncedConfigs.entrySet()) {
            String id = entry.getKey();
            Config config = entry.getValue();
            List syncErrors = new ArrayList();
            ConfigSyncS2CCustomPayload payload = new ConfigSyncS2CCustomPayload(id, ConfigApi.serializeConfig(config, syncErrors, (byte)0));
            if (!((Collection)syncErrors).isEmpty()) {
                ValidationResult<Boolean> syncError = ValidationResult.Companion.error(true, "Error encountered while serializing config for S2C configuration stage sync.");
                syncError.writeError(syncErrors);
            }
            class_2540 buf = PacketByteBufs.create();
            Intrinsics.checkNotNull((Object)buf);
            payload.write(buf);
            ServerPlayNetworking.send((class_3222)handler.field_14140, (class_2960)ConfigSyncS2CCustomPayload.Companion.getId(), (class_2540)buf);
        }
    }

    public final void registerAll$fzzy_config() {
        ServerLifecycleEvents.END_DATA_PACK_RELOAD.register(SyncedConfigRegistry::registerAll$lambda$4);
        ServerPlayNetworking.registerGlobalReceiver((class_2960)ConfigUpdateC2SCustomPayload.Companion.getId(), SyncedConfigRegistry::registerAll$lambda$5);
        ServerPlayNetworking.registerGlobalReceiver((class_2960)SettingForwardCustomPayload.Companion.getId(), SyncedConfigRegistry::registerAll$lambda$6);
    }

    private final int getPlayerPermissionLevel(class_1657 player) {
        int i = 0;
        while (player.method_5687(i)) {
            ++i;
        }
        return i - 1;
    }

    public final boolean hasConfig$fzzy_config(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return syncedConfigs.containsKey(id);
    }

    public final void registerConfig$fzzy_config(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Map<String, Config> map = syncedConfigs;
        String string = config.getId().method_42094();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toTranslationKey(...)");
        map.put(string, config);
    }

    private static final void registerClient$lambda$1$lambda$0(class_310 $client) {
        class_638 class_6383 = $client.field_1687;
        if (class_6383 != null) {
            class_6383.method_8525();
        }
        $client.method_18099();
        ConfigApiImpl.INSTANCE.openRestartScreen$fzzy_config();
    }

    private static final void registerClient$lambda$1(class_310 client, class_634 class_6342, class_2540 buf, PacketSender packetSender) {
        Intrinsics.checkNotNull((Object)buf);
        ConfigSyncS2CCustomPayload payload = new ConfigSyncS2CCustomPayload(buf);
        String id = payload.getId();
        String configString = payload.getSerializedConfig();
        if (syncedConfigs.containsKey(id)) {
            Config config = syncedConfigs.get(id);
            if (config == null) {
                return;
            }
            Config config2 = config;
            List errors = new ArrayList();
            ValidationResult<ConfigContext<Config>> result = ConfigApi.deserializeConfig(config2, configString, errors, (byte)2);
            boolean restart = result.get().getBoolean(ConfigContext.Keys.getRESTART_KEY());
            result.writeError(errors);
            result.get().getConfig().save();
            if (restart) {
                client.execute(() -> SyncedConfigRegistry.registerClient$lambda$1$lambda$0(client));
            }
        }
    }

    private static final void registerClient$lambda$2(class_310 client, class_634 class_6342, class_2540 buf, PacketSender packetSender) {
        Intrinsics.checkNotNull((Object)buf);
        ConfigUpdateS2CCustomPayload payload = new ConfigUpdateS2CCustomPayload(buf);
        Map<String, String> serializedConfigs = payload.getUpdates();
        for (Map.Entry<String, String> entry : serializedConfigs.entrySet()) {
            Config config;
            String id = entry.getKey();
            String configString = entry.getValue();
            if (!syncedConfigs.containsKey(id)) continue;
            if (syncedConfigs.get(id) == null) {
                return;
            }
            List errors = new ArrayList();
            ValidationResult<ConfigContext<Config>> result = ConfigApiImpl.INSTANCE.deserializeUpdate$fzzy_config(config, configString, errors, (byte)2);
            boolean restart = result.get().getBoolean(ConfigContext.Keys.getRESTART_KEY());
            result.writeError(errors);
            result.get().getConfig().save();
            if (!restart) continue;
            class_746 class_7462 = client.field_1724;
            if (class_7462 == null) continue;
            class_7462.method_43496((class_2561)FcText.INSTANCE.translate("fc.config.restart.update", new Object[0]));
        }
    }

    private static final void registerClient$lambda$3(class_310 class_3102, class_634 class_6342, class_2540 buf, PacketSender packetSender) {
        Intrinsics.checkNotNull((Object)buf);
        SettingForwardCustomPayload payload = new SettingForwardCustomPayload(buf);
        String update2 = payload.getUpdate();
        UUID sendingUuid = payload.getPlayer();
        String scope = payload.getScope();
        String summary = payload.getSummary();
        ConfigApiImplClient.INSTANCE.handleForwardedUpdate$fzzy_config(update2, sendingUuid, scope, summary);
    }

    private static final void registerAll$lambda$4(MinecraftServer server, class_6860 class_68602, boolean bl) {
        List players = server.method_3760().method_14571();
        for (class_3222 player : players) {
            for (Map.Entry<String, Config> entry : syncedConfigs.entrySet()) {
                String id = entry.getKey();
                Config config = entry.getValue();
                List syncErrors = new ArrayList();
                ConfigSyncS2CCustomPayload payload = new ConfigSyncS2CCustomPayload(id, ConfigApi.serializeConfig(config, syncErrors, (byte)0));
                if (!((Collection)syncErrors).isEmpty()) {
                    ValidationResult<Boolean> syncError = ValidationResult.Companion.error(true, "Error encountered while serializing config for S2C datapack reload sync.");
                    syncError.writeError(syncErrors);
                }
                class_2540 buf = PacketByteBufs.create();
                Intrinsics.checkNotNull((Object)buf);
                payload.write(buf);
                ServerPlayNetworking.send((class_3222)player, (class_2960)ConfigSyncS2CCustomPayload.Companion.getId(), (class_2540)buf);
            }
        }
    }

    private static final void registerAll$lambda$5(MinecraftServer server, class_3222 serverPlayer, class_3244 context, class_2540 buf, PacketSender sender) {
        Intrinsics.checkNotNull((Object)buf);
        ConfigUpdateC2SCustomPayload payload = new ConfigUpdateC2SCustomPayload(buf);
        int permLevel = payload.getPlayerPerm();
        Map<String, String> serializedConfigs = payload.getUpdates();
        if (!serverPlayer.method_5687(permLevel)) {
            Logger logger = FC.INSTANCE.getLOGGER$fzzy_config();
            class_2561 class_25612 = serverPlayer.method_5477();
            Intrinsics.checkNotNull((Object)serverPlayer);
            logger.error("Player [" + class_25612 + "] may have tried to cheat changes to the Server Config! Their perm level: " + INSTANCE.getPlayerPermissionLevel((class_1657)serverPlayer) + ", perm level synced from client: " + permLevel);
            List<String> changes = payload.getChangeHistory();
            ConfigApiImpl.INSTANCE.printChangeHistory$fzzy_config(changes, serializedConfigs.keySet().toString(), (class_1657)serverPlayer);
            for (class_3222 player : serverPlayer.field_13995.method_3760().method_14571()) {
                if (!player.method_5687(2)) continue;
                Object[] objectArray = new Object[1];
                Intrinsics.checkNotNullExpressionValue((Object)serverPlayer.method_5477(), (String)"getName(...)");
                player.method_43502((class_2561)FcText.INSTANCE.translate("fc.networking.permission.cheat", objectArray), false);
            }
            return;
        }
        for (Map.Entry<String, String> entry : serializedConfigs.entrySet()) {
            Config config;
            String id = entry.getKey();
            String configString = entry.getValue();
            if (syncedConfigs.get(id) == null) continue;
            List errors = new ArrayList();
            ValidationResult<ConfigContext<Config>> result = ConfigApiImpl.INSTANCE.deserializeUpdate$fzzy_config(config, configString, errors, (byte)2);
            boolean restart = result.get().getBoolean(ConfigContext.Keys.getRESTART_KEY());
            result.writeError(errors);
            result.get().getConfig().save();
            if (!restart) continue;
            FC.INSTANCE.getLOGGER$fzzy_config().error("The server has received a config update that may require a restart, please consult the change history below for details. Connected clients have been automatically updated and notified of the potential for restart.");
        }
        for (class_3222 player : serverPlayer.field_13995.method_3760().method_14571()) {
            if (Intrinsics.areEqual((Object)player, (Object)serverPlayer)) continue;
            ConfigUpdateS2CCustomPayload newPayload = new ConfigUpdateS2CCustomPayload(serializedConfigs);
            class_2540 newBuf = PacketByteBufs.create();
            Intrinsics.checkNotNull((Object)newBuf);
            newPayload.write(newBuf);
            ServerPlayNetworking.send((class_3222)player, (class_2960)ConfigUpdateS2CCustomPayload.Companion.getId(), (class_2540)newBuf);
        }
        List<String> changes = payload.getChangeHistory();
        ConfigApiImpl.INSTANCE.printChangeHistory$fzzy_config(changes, serializedConfigs.keySet().toString(), (class_1657)serverPlayer);
    }

    private static final void registerAll$lambda$6(MinecraftServer server, class_3222 serverPlayer, class_3244 context, class_2540 buf, PacketSender sender) {
        Intrinsics.checkNotNull((Object)buf);
        SettingForwardCustomPayload payload = new SettingForwardCustomPayload(buf);
        UUID uuid = payload.getPlayer();
        class_3222 class_32222 = serverPlayer.field_13995.method_3760().method_14602(uuid);
        if (class_32222 == null) {
            return;
        }
        class_3222 receivingPlayer = class_32222;
        String scope = payload.getScope();
        String update2 = payload.getUpdate();
        String summary = payload.getSummary();
        class_3222 sendingPlayer = serverPlayer;
        UUID uUID = sendingPlayer.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUuid(...)");
        SettingForwardCustomPayload newPayload = new SettingForwardCustomPayload(update2, uUID, scope, summary);
        class_2540 newBuf = PacketByteBufs.create();
        Intrinsics.checkNotNull((Object)newBuf);
        newPayload.write(newBuf);
        ServerPlayNetworking.send((class_3222)receivingPlayer, (class_2960)SettingForwardCustomPayload.Companion.getId(), (class_2540)newBuf);
    }
}

