/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.common.block;

import java.util.Map;
import net.mehvahdjukaar.amendments.common.tile.LiquidCauldronBlockTile;
import net.mehvahdjukaar.amendments.reg.ModRegistry;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidStack;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_174;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1920;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2275;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3532;
import net.minecraft.class_4970;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public abstract class ModCauldronBlock
extends class_2275
implements class_2343 {
    public ModCauldronBlock(class_4970.class_2251 properties) {
        super(properties, Map.of());
    }

    public class_1792 method_8389() {
        return class_1802.field_8638;
    }

    public abstract class_2758 getLevelProperty();

    public int method_9572(class_2680 state, class_1937 level, class_2338 pos) {
        return (Integer)state.method_11654((class_2769)this.getLevelProperty());
    }

    public void method_9504(class_2680 state, class_1937 level, class_2338 pos, class_1959.class_1963 precipitation) {
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new LiquidCauldronBlockTile(pos, state);
    }

    public void method_9554(class_1937 level, class_2680 state, class_2338 pos, class_1297 entity, float fallDistance) {
        if (this.method_31616(state, pos, entity)) {
            class_2586 class_25862;
            if (level.field_9236 && (class_25862 = level.method_8321(pos)) instanceof LiquidCauldronBlockTile) {
                LiquidCauldronBlockTile tile = (LiquidCauldronBlockTile)class_25862;
                int color = tile.getSoftFluidTank().getCachedParticleColor((class_1920)level, pos);
                int light = tile.getSoftFluidTank().getFluidValue().getEmissivity();
                ModCauldronBlock.playSplashAnimation(level, pos, entity, this.method_31615(state), color, light);
            }
            super.method_9554(level, state, pos, entity, 0.0f);
        } else {
            super.method_9554(level, state, pos, entity, fallDistance);
        }
    }

    public static void playSplashAnimation(class_1937 level, class_2338 pos, class_1297 e, double waterLevel, int color, int light) {
        class_1297 feetEntity = e.method_5782() && e.method_5642() != null ? e.method_5642() : e;
        float offset = feetEntity == e ? 0.2f : 0.9f;
        class_243 movement = feetEntity.method_18798();
        class_5819 rand = level.field_9229;
        float speed = Math.min(1.0f, (float)Math.sqrt(movement.field_1352 * movement.field_1352 * 0.2 + movement.field_1351 * movement.field_1351 + movement.field_1350 * movement.field_1350 * 0.2) * offset);
        if (speed < 0.25f) {
            level.method_8486(e.method_23317(), e.method_23318(), e.method_23321(), e.method_5625(), e.method_5634(), speed, 1.0f + (rand.method_43057() - rand.method_43057()) * 0.4f, false);
        } else {
            level.method_8486(e.method_23317(), e.method_23318(), e.method_23321(), e.method_5672(), e.method_5634(), speed, 1.0f + (rand.method_43057() - rand.method_43057()) * 0.4f, false);
        }
        double surface = (double)pos.method_10264() + waterLevel;
        float radius = 1.5f;
        float width = e.method_17681();
        ModCauldronBlock.spawnSplashParticles(level, e, pos, rand, surface, color, light, (class_2394)ModRegistry.BOILING_PARTICLE.get(), radius, width);
        ModCauldronBlock.spawnSplashParticles(level, e, pos, rand, surface, color, light, (class_2394)ModRegistry.SPLASH_PARTICLE.get(), radius, width);
        e.method_32876(class_5712.field_28160);
    }

    private static void spawnSplashParticles(class_1937 level, class_1297 e, class_2338 pos, class_5819 rand, double surface, int color, int light, class_2394 particleOptions, float radius, float width) {
        float mx = (float)pos.method_10263() + 0.125f;
        float Mx = (float)(pos.method_10263() + 1) - 0.125f;
        float mz = (float)pos.method_10260() + 0.125f;
        float Mz = (float)(pos.method_10260() + 1) - 0.125f;
        int i = 0;
        while ((float)i < 1.0f + width * 20.0f) {
            double x = e.method_23317() + (rand.method_43058() - 0.5) * (double)width * (double)radius;
            double z = e.method_23321() + (rand.method_43058() - 0.5) * (double)width * (double)radius;
            if (x >= (double)mx && x <= (double)Mx && z >= (double)mz && z <= (double)Mz) {
                level.method_8406(particleOptions, x, surface, z, (double)color, surface, (double)light);
            }
            ++i;
        }
    }

    public static void playExtinguishSound(class_1937 level, class_2338 pos, class_1297 entity) {
        level.method_8396(null, pos, class_3417.field_15222, entity.method_5634(), 0.7f, 1.6f + (level.field_9229.method_43057() - level.field_9229.method_43057()) * 0.4f);
    }

    public void method_9548(class_2680 state, class_1937 level, class_2338 pos, class_1297 entity) {
        if (this.method_31616(state, pos, entity)) {
            entity.field_5957 = true;
            if (level.field_9236) {
                return;
            }
            if (entity.method_5809()) {
                class_2586 class_25862;
                entity.method_5646();
                ModCauldronBlock.playExtinguishSound(level, pos, entity);
                if (entity.method_36971(level, pos) && (class_25862 = level.method_8321(pos)) instanceof LiquidCauldronBlockTile) {
                    LiquidCauldronBlockTile te = (LiquidCauldronBlockTile)class_25862;
                    te.consumeOneLayer();
                }
            }
            this.handleEntityInside(state, level, pos, entity);
        }
    }

    protected abstract void handleEntityInside(class_2680 var1, class_1937 var2, class_2338 var3, class_1297 var4);

    public void doCraftItem(class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, LiquidCauldronBlockTile te, SoftFluidStack fluid, class_1799 itemStack, class_1799 crafted, float layerPerItem, int itemCountMultiplier) {
        level.method_8396(player, pos, class_3417.field_14834, class_3419.field_15245, 1.0f, 1.3f);
        if (!(player instanceof class_3222)) {
            return;
        }
        class_3222 serverPlayer = (class_3222)player;
        player.method_7259(class_3468.field_15372.method_14956((Object)itemStack.method_7909()));
        class_174.field_24478.method_23889(serverPlayer, pos, itemStack);
        int maxRecolorable = (int)((float)(crafted.method_7947() * itemCountMultiplier * fluid.getCount()) / layerPerItem);
        int amountToRecolor = Math.min(maxRecolorable, itemStack.method_7947());
        crafted.method_7939(amountToRecolor);
        if (!player.method_7337()) {
            itemStack.method_7934(amountToRecolor);
            fluid.shrink(class_3532.method_15386((float)(layerPerItem * (float)amountToRecolor / (float)itemCountMultiplier)));
            te.method_5431();
        }
        if (itemStack.method_7960()) {
            player.method_6122(hand, crafted);
        } else if (!player.method_31548().method_7394(crafted)) {
            player.method_7328(crafted, false);
        }
    }

    public abstract class_2680 updateStateOnFluidChange(class_2680 var1, class_1937 var2, class_2338 var3, SoftFluidStack var4);

    public static void addSurfaceParticles(class_2394 type, class_1937 level, class_2338 pos, int count, double surface, class_5819 rand, float r, float g, float b) {
        for (int i = 0; i < count; ++i) {
            double x = (double)pos.method_10263() + 0.1875 + (double)rand.method_43057() * 0.625;
            double y = (double)pos.method_10264() + surface;
            double z = (double)pos.method_10260() + 0.1875 + (double)rand.method_43057() * 0.625;
            level.method_8406(type, x, y, z, (double)r, (double)g, (double)b);
        }
    }
}

