/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.world.gen.features;

import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import java.util.HashSet;
import net.minecraft.class_1936;
import net.minecraft.class_2222;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3031;
import net.minecraft.class_3111;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_5281;
import net.minecraft.class_5726;
import net.minecraft.class_5777;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import net.orcinus.galosphere.init.GBlocks;

public class LichenMushroomFeature
extends class_3031<class_3111> {
    public LichenMushroomFeature(Codec<class_3111> codec) {
        super(codec);
    }

    public boolean method_13151(class_5821<class_3111> context) {
        class_5281 world = context.method_33652();
        class_2338 blockPos = context.method_33655();
        class_5819 random = context.method_33654();
        int radius = class_3532.method_15395((class_5819)random, (int)2, (int)4);
        int height = radius * 2;
        int tries = 0;
        return !this.generateLichenMushroom(world, blockPos, random, radius, height, Sets.newHashSet(), tries);
    }

    private boolean generateLichenMushroom(class_5281 world, class_2338 blockPos, class_5819 random, int radius, int stemHeight, HashSet<class_2338> set, int tries) {
        for (int checkx = -radius; checkx <= radius; ++checkx) {
            for (int checkz = -radius; checkz <= radius; ++checkz) {
                boolean flag = checkx == -radius || checkx == radius;
                boolean flag1 = checkz == -radius || checkz == radius;
                boolean flag2 = flag && flag1;
                class_2338 checkpos = new class_2338(blockPos.method_10263() + checkx, blockPos.method_10264() - 1, blockPos.method_10260() + checkz);
                if (!world.method_22347(checkpos) && world.method_8316(checkpos).method_15769() || flag2) continue;
                if (++tries < 5) {
                    return this.generateLichenMushroom(world, blockPos.method_10074(), random, radius, stemHeight, set, tries);
                }
                return false;
            }
        }
        LichenMushroomFeature.generateHugeLichenMushroom(world, blockPos, random, radius, stemHeight, set);
        return false;
    }

    public static boolean generateHugeLichenMushroom(class_5281 world, class_2338 blockPos, class_5819 random, int radius, int stemHeight, HashSet<class_2338> set) {
        if (!LichenMushroomFeature.checkAirExposure((class_1936)world, blockPos, stemHeight)) {
            return false;
        }
        if (radius == 1) {
            LichenMushroomFeature.generateUnqiueLichenMushroom(world, blockPos, set);
        } else {
            LichenMushroomFeature.generateDefaultLichenMushroom(world, blockPos, radius, stemHeight, set);
        }
        set.forEach(mossPos -> {
            class_2350 randomDir;
            class_2350 direction;
            if (random.method_43048(3) == 0 && world.method_16358(mossPos.method_10084(), class_5726::method_33014)) {
                class_2248 block = random.method_43056() ? GBlocks.BOWL_LICHEN : GBlocks.LICHEN_ROOTS;
                world.method_8652(mossPos.method_10084(), (class_2680)block.method_9564().method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(world.method_8320(mossPos.method_10084()).method_27852(class_2246.field_10382))), 2);
            }
            if (world.method_16358(mossPos.method_10093(direction = class_2350.class_2353.field_11062.method_10183(random)), LichenMushroomFeature::canGenerate) && random.method_43048(3) == 0) {
                world.method_8652(mossPos.method_10093(direction), (class_2680)((class_2680)GBlocks.LICHEN_SHELF.method_9564().method_11657((class_2769)class_2222.field_9933, (Comparable)direction)).method_11657((class_2769)class_2222.field_9940, (Comparable)Boolean.valueOf(world.method_8316(mossPos.method_10093(direction)).method_15767(class_3486.field_15517))), 2);
            }
            if (world.method_16358(mossPos.method_10093(randomDir = class_2350.method_10162((class_5819)random)), LichenMushroomFeature::canGenerate) && random.method_43048(3) == 0) {
                world.method_8652(mossPos.method_10093(randomDir), (class_2680)((class_2680)class_2246.field_28411.method_9564().method_11657((class_2769)class_5777.method_33374((class_2350)randomDir.method_10153()), (Comparable)Boolean.valueOf(true))).method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(world.method_8316(mossPos.method_10093(randomDir)).method_15767(class_3486.field_15517))), 2);
            }
        });
        return true;
    }

    private static void generateUnqiueLichenMushroom(class_5281 world, class_2338 blockPos, HashSet<class_2338> set) {
        int z;
        int x;
        int stemRadius = 1;
        int capRadius = 2;
        int radiusOneHeight = 3;
        for (x = -stemRadius; x <= stemRadius; ++x) {
            for (z = -stemRadius; z <= stemRadius; ++z) {
                class_2338 generatePos = new class_2338(blockPos.method_10263() + x, blockPos.method_10264(), blockPos.method_10260() + z);
                for (int y = 0; y < radiusOneHeight; ++y) {
                    boolean flag1;
                    class_2338 pos = generatePos.method_10086(y);
                    boolean flag = x == stemRadius || x == -stemRadius;
                    boolean bl = flag1 = z == stemRadius || z == -stemRadius;
                    if (y != 1 ? y == 2 && (flag || flag1) : flag && flag1) continue;
                    if (!world.method_16358(pos, LichenMushroomFeature::canGenerate)) continue;
                    world.method_8652(pos, class_2246.field_10556.method_9564(), 2);
                }
                class_2338 capPos = generatePos.method_10086(radiusOneHeight);
                if (!world.method_16358(capPos, LichenMushroomFeature::canGenerate)) continue;
                world.method_8652(capPos, GBlocks.LICHEN_MOSS.method_9564(), 2);
                set.add(capPos);
            }
        }
        for (x = -capRadius; x <= capRadius; ++x) {
            for (z = -capRadius; z <= capRadius; ++z) {
                boolean flag;
                class_2338 capPos = new class_2338(blockPos.method_10263() + x, blockPos.method_10264() + radiusOneHeight + 1, blockPos.method_10260() + z);
                boolean bl = flag = !(x != capRadius && x != -capRadius || z != capRadius && z != -capRadius);
                if (flag || x * x + z * z <= 1 || !world.method_16358(capPos, LichenMushroomFeature::canGenerate)) continue;
                world.method_8652(capPos, GBlocks.LICHEN_MOSS.method_9564(), 2);
                set.add(capPos);
            }
        }
    }

    private static boolean canGenerate(class_2680 state) {
        return state.method_45474() || state.method_26215() || state.method_27852(class_2246.field_10382) || state.method_27852(GBlocks.BOWL_LICHEN);
    }

    private static void generateDefaultLichenMushroom(class_5281 world, class_2338 blockPos, int radius, int stemHeight, HashSet<class_2338> set) {
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                for (int y = 0; y < stemHeight; ++y) {
                    boolean flag2;
                    class_2338 pos = new class_2338(blockPos.method_10263() + x, blockPos.method_10264() + y, blockPos.method_10260() + z);
                    int f4 = 4 * radius;
                    boolean flag = x == -radius || x == radius;
                    boolean flag1 = z == -radius || z == radius;
                    boolean bl = flag2 = y == 0 && flag && flag1;
                    if (!((double)(x * x) + 2.0 * (Math.log(y * y) * (double)f4) / (double)f4 + (double)(z * z) <= (double)(radius * radius)) || flag2) continue;
                    if (world.method_16358(pos, LichenMushroomFeature::canGenerate)) {
                        world.method_8652(pos, class_2246.field_10556.method_9564(), 2);
                    }
                    for (int xMossRadius = -radius * 2; xMossRadius <= radius * 2; ++xMossRadius) {
                        for (int zMossRadius = -radius * 2; zMossRadius <= radius * 2; ++zMossRadius) {
                            class_2338 mossPos = new class_2338(blockPos.method_10263() + xMossRadius, blockPos.method_10264() + stemHeight - 1, blockPos.method_10260() + zMossRadius);
                            int distance = xMossRadius * xMossRadius + zMossRadius * zMossRadius;
                            if (distance < radius * 4) {
                                if (!world.method_16358(mossPos, LichenMushroomFeature::canGenerate)) continue;
                                world.method_8652(mossPos, GBlocks.LICHEN_MOSS.method_9564(), 2);
                                set.add(mossPos);
                                continue;
                            }
                            if (distance > radius * 8 || distance < radius * 4 || !world.method_16358(mossPos.method_10084(), LichenMushroomFeature::canGenerate)) continue;
                            world.method_8652(mossPos.method_10084(), GBlocks.LICHEN_MOSS.method_9564(), 2);
                            set.add(mossPos.method_10084());
                        }
                    }
                }
            }
        }
    }

    public static boolean checkAirExposure(class_1936 world, class_2338 blockPos, int height) {
        for (int y = 0; y < height; ++y) {
            if (!world.method_16358(blockPos.method_10086(y), LichenMushroomFeature::canGenerate)) continue;
            return true;
        }
        return false;
    }
}

