/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.init;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_4148;
import net.minecraft.class_4149;
import net.minecraft.class_5760;
import net.minecraft.class_7923;
import net.orcinus.galosphere.Galosphere;
import net.orcinus.galosphere.entities.ai.SparkleAi;
import net.orcinus.galosphere.entities.ai.SpectreAi;
import net.orcinus.galosphere.entities.ai.sensors.BerserkerEntitySensor;
import net.orcinus.galosphere.entities.ai.sensors.NearestLichenMossSensor;
import net.orcinus.galosphere.entities.ai.sensors.NearestPollinatedClusterSensor;
import net.orcinus.galosphere.entities.ai.sensors.PreservedEntitySensor;

public class GSensorTypes {
    public static final Map<class_2960, class_4149<?>> SENSOR_TYPES = Maps.newLinkedHashMap();
    public static final class_4149<class_5760> SPARKLE_TEMPTATIONS = GSensorTypes.register("sparkle_temptations", () -> new class_5760(SparkleAi.getTemptations()));
    public static final class_4149<class_5760> SPECTRE_TEMPTATIONS = GSensorTypes.register("spectre_temptations", () -> new class_5760(SpectreAi.getTemptations()));
    public static final class_4149<NearestPollinatedClusterSensor> NEAREST_POLLINATED_CLUSTER = GSensorTypes.register("nearest_pollinated_cluster", NearestPollinatedClusterSensor::new);
    public static final class_4149<NearestLichenMossSensor> NEAREST_LICHEN_MOSS = GSensorTypes.register("nearest_lichen_moss", NearestLichenMossSensor::new);
    public static final class_4149<BerserkerEntitySensor> BLIGHTED_ENTITY_SENSOR = GSensorTypes.register("blighted_entity_sensor", BerserkerEntitySensor::new);
    public static final class_4149<PreservedEntitySensor> PRESERVED_ENTITY_SENSOR = GSensorTypes.register("preserved_entity_sensor", PreservedEntitySensor::new);

    private static <U extends class_4148<?>> class_4149<U> register(String string, Supplier<U> supplier) {
        class_4149 sensorType = new class_4149(supplier);
        SENSOR_TYPES.put(Galosphere.id(string), sensorType);
        return sensorType;
    }

    public static void init() {
        SENSOR_TYPES.forEach((resourceLocation, sensorType) -> class_2378.method_10230((class_2378)class_7923.field_41130, (class_2960)resourceLocation, (Object)sensorType));
    }
}

