/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.init;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.event.player.UseItemCallback;
import net.fabricmc.fabric.api.loot.v2.LootTableEvents;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_117;
import net.minecraft.class_125;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_141;
import net.minecraft.class_1542;
import net.minecraft.class_1746;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2480;
import net.minecraft.class_2540;
import net.minecraft.class_2627;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_39;
import net.minecraft.class_3962;
import net.minecraft.class_44;
import net.minecraft.class_5268;
import net.minecraft.class_55;
import net.minecraft.class_5658;
import net.minecraft.class_5662;
import net.minecraft.class_5712;
import net.minecraft.class_746;
import net.minecraft.class_77;
import net.minecraft.class_79;
import net.orcinus.galosphere.Galosphere;
import net.orcinus.galosphere.api.BannerAttachable;
import net.orcinus.galosphere.api.Spectatable;
import net.orcinus.galosphere.api.SpectreBoundSpyglass;
import net.orcinus.galosphere.blocks.LumiereComposterBlock;
import net.orcinus.galosphere.config.GalosphereConfig;
import net.orcinus.galosphere.init.GBlocks;
import net.orcinus.galosphere.init.GItems;
import net.orcinus.galosphere.init.GNetwork;
import net.orcinus.galosphere.init.GSoundEvents;
import net.orcinus.galosphere.util.BannerRendererUtil;
import net.orcinus.galosphere.util.PreservedShulkerBox;

public class GEvents {
    public static void init() {
        GEvents.registerServerTickEvents();
        GEvents.registerLootTableEvents();
        GEvents.registerBlockUseEvents();
        GEvents.registerItemUseEvents();
    }

    @Environment(value=EnvType.CLIENT)
    public static void clientInit() {
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            SpectreBoundSpyglass spectreBoundSpyglass;
            class_746 player = client.field_1724;
            if (player != null && player instanceof SpectreBoundSpyglass && (spectreBoundSpyglass = (SpectreBoundSpyglass)player).isUsingSpectreBoundedSpyglass() && client.method_1560() instanceof Spectatable) {
                player.method_18799(player.method_18798().method_18805(0.0, 1.0, 0.0));
                player.field_6212 = 0.0f;
                player.field_6250 = 0.0f;
                player.method_6100(false);
                player.method_5728(false);
            }
        });
    }

    private static void registerServerTickEvents() {
        ServerTickEvents.START_WORLD_TICK.register(Galosphere.id("send_barometer_info"), level -> level.method_18766(player -> player.method_37908() != null).forEach(player -> {
            class_2540 buf = PacketByteBufs.create();
            class_5268 levelData = (class_5268)level.method_8401();
            int rainTime = levelData.method_155() > 0 ? levelData.method_155() : levelData.method_190();
            buf.writeInt(rainTime);
            ServerPlayNetworking.send((class_3222)player, (class_2960)GNetwork.BAROMETER_INFO, (class_2540)buf);
        }));
    }

    private static void registerItemUseEvents() {
        UseItemCallback.EVENT.register((player, world, hand) -> {
            BannerRendererUtil util = new BannerRendererUtil();
            class_1799 stack = player.method_5998(hand);
            if (((BannerAttachable)player).getBanner().method_7960() && player.method_6118(class_1304.field_6169).method_31574(GItems.STERLING_HELMET) && (util.isTapestryStack(stack) || stack.method_7909() instanceof class_1746)) {
                player.method_32875(class_5712.field_28739, (class_1297)player);
                class_1799 copy = stack.method_7972();
                if (!player.method_31549().field_7477) {
                    stack.method_7934(1);
                }
                copy.method_7939(1);
                ((BannerAttachable)player).setBanner(copy);
                player.method_5783(class_3417.field_14581, 1.0f, 1.0f);
                return class_1271.method_22427((Object)stack);
            }
            return class_1271.method_22430((Object)class_1799.field_8037);
        });
    }

    private static void registerBlockUseEvents() {
        PlayerBlockBreakEvents.BEFORE.register((world, player, pos, state, blockEntity) -> {
            class_2627 shulkerBoxBlockEntity;
            if (blockEntity instanceof class_2627 && ((PreservedShulkerBox)(shulkerBoxBlockEntity = (class_2627)blockEntity)).isPreserved()) {
                class_1799 stack = new class_1799((class_1935)class_2480.method_10525((class_1767)((class_2480)state.method_26204()).method_10528()));
                shulkerBoxBlockEntity.method_38240(stack);
                if (shulkerBoxBlockEntity.method_16914()) {
                    stack.method_7977(shulkerBoxBlockEntity.method_5797());
                }
                stack.method_7948().method_10556("Preserved", true);
                class_1542 itementity = new class_1542(player.method_37908(), (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, stack);
                itementity.method_6988();
                world.method_8649((class_1297)itementity);
                world.method_8650(pos, false);
                state.method_26204().method_9576(player.method_37908(), pos, state, player);
                return false;
            }
            return true;
        });
        UseBlockCallback.EVENT.register((player, world, hand, hitResult) -> {
            class_2338 pos = hitResult.method_17777();
            class_2680 state = world.method_8320(pos);
            if (player.method_5715() && !((BannerAttachable)player).getBanner().method_7960() && player.method_5998(hand).method_7960()) {
                class_1799 copy = ((BannerAttachable)player).getBanner();
                player.method_6122(hand, copy);
                player.method_32875(class_5712.field_28739, (class_1297)player);
                ((BannerAttachable)player).setBanner(class_1799.field_8037);
                return class_1269.field_5812;
            }
            if (state.method_27852(class_2246.field_17563) && player.method_5998(hand).method_7909() == GItems.LUMIERE_SHARD && (Integer)state.method_11654((class_2769)class_3962.field_17565) > 0 && (Integer)state.method_11654((class_2769)class_3962.field_17565) < 8) {
                if (!player.method_31549().field_7477) {
                    player.method_5998(hand).method_7934(1);
                }
                world.method_8652(pos, (class_2680)GBlocks.LUMIERE_COMPOSTER.method_9564().method_11657((class_2769)LumiereComposterBlock.field_17565, (Comparable)((Integer)state.method_11654((class_2769)class_3962.field_17565))), 2);
                world.method_8396(null, pos, GSoundEvents.LUMIERE_COMPOST, class_3419.field_15245, 1.0f, 1.0f);
                world.method_33596((class_1297)player, class_5712.field_28733, pos);
                return class_1269.field_5812;
            }
            return class_1269.field_5811;
        });
    }

    private static void registerLootTableEvents() {
        LootTableEvents.MODIFY.register((resourceManager, lootManager, id, tableBuilder, source) -> {
            if (id.equals((Object)class_1299.field_6105.method_16351()) && GalosphereConfig.pillagerDropSilverIngot) {
                tableBuilder.pool(class_55.method_347().method_352((class_5658)class_44.method_32448((float)1.0f)).method_351((class_79.class_80)class_77.method_411((class_1935)GItems.SILVER_NUGGET).method_438((class_117.class_118)class_141.method_621((class_5658)class_5662.method_32462((float)0.0f, (float)2.0f))).method_438((class_117.class_118)class_125.method_547((class_5658)class_5662.method_32462((float)0.0f, (float)1.0f)))).method_355());
            }
            if (id.equals((Object)class_39.field_38438) && GalosphereConfig.spectreFlareAncientCityLoot) {
                tableBuilder.pool(class_55.method_347().method_351((class_79.class_80)class_77.method_411((class_1935)GItems.SPECTRE_FLARE).method_437(1).method_438((class_117.class_118)class_141.method_621((class_5658)class_5662.method_32462((float)0.0f, (float)2.0f)))).method_355());
            }
            if ((id.equals((Object)class_39.field_472) || id.equals((Object)class_39.field_16593)) && GalosphereConfig.silverUpgradeTemplatesLoot) {
                tableBuilder.pool(class_55.method_347().method_351((class_79.class_80)class_77.method_411((class_1935)GItems.SILVER_UPGRADE_SMITHING_TEMPLATE).method_437(1).method_438((class_117.class_118)class_141.method_621((class_5658)class_5662.method_32462((float)0.0f, (float)2.0f)))).method_355());
            }
        });
    }
}

