/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.entities;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.mojang.serialization.Dynamic;
import java.util.Map;
import java.util.function.IntFunction;
import javax.annotation.Nullable;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_13;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1315;
import net.minecraft.class_1408;
import net.minecraft.class_1429;
import net.minecraft.class_15;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1810;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3542;
import net.minecraft.class_3730;
import net.minecraft.class_4095;
import net.minecraft.class_4140;
import net.minecraft.class_4148;
import net.minecraft.class_4149;
import net.minecraft.class_4209;
import net.minecraft.class_4538;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5712;
import net.minecraft.class_5757;
import net.minecraft.class_5766;
import net.minecraft.class_5819;
import net.minecraft.class_6019;
import net.minecraft.class_7;
import net.minecraft.class_7988;
import net.minecraft.class_7995;
import net.minecraft.class_9;
import net.orcinus.galosphere.entities.ai.SparkleAi;
import net.orcinus.galosphere.init.GBlockTags;
import net.orcinus.galosphere.init.GBlocks;
import net.orcinus.galosphere.init.GEntityTypes;
import net.orcinus.galosphere.init.GItemTags;
import net.orcinus.galosphere.init.GItems;
import net.orcinus.galosphere.init.GMemoryModuleTypes;
import net.orcinus.galosphere.init.GSensorTypes;

public class Sparkle
extends class_1429
implements class_7988<CrystalType> {
    private static final class_2940<Integer> CRYSTAL_TYPE = class_2945.method_12791(Sparkle.class, (class_2941)class_2943.field_13327);
    protected static final ImmutableList<? extends class_4149<? extends class_4148<? super Sparkle>>> SENSOR_TYPES = ImmutableList.of((Object)class_4149.field_18466, (Object)class_4149.field_18469, GSensorTypes.SPARKLE_TEMPTATIONS, GSensorTypes.NEAREST_POLLINATED_CLUSTER, (Object)class_4149.field_37447);
    protected static final ImmutableList<? extends class_4140<?>> MEMORY_TYPES = ImmutableList.of((Object)class_4140.field_18446, (Object)class_4140.field_18441, (Object)class_4140.field_18442, (Object)class_4140.field_18445, (Object)class_4140.field_19293, (Object)class_4140.field_18449, (Object)class_4140.field_18448, (Object)class_4140.field_28325, (Object)class_4140.field_28326, (Object)class_4140.field_28327, (Object)class_4140.field_18451, (Object)class_4140.field_18452, (Object[])new class_4140[]{class_4140.field_30243, class_4140.field_37442, class_4140.field_39408, GMemoryModuleTypes.NEAREST_POLLINATED_CLUSTER, GMemoryModuleTypes.POLLINATED_COOLDOWN});
    private static final class_6019 REGROWTH_TICKS = class_6019.method_35017((int)6000, (int)12000);
    private final Map<class_2248, class_2248> clustersToGlinted = (Map)class_156.method_654((Object)Maps.newHashMap(), map -> {
        map.put(GBlocks.ALLURITE_CLUSTER, GBlocks.GLINTED_ALLURITE_CLUSTER);
        map.put(GBlocks.LUMIERE_CLUSTER, GBlocks.GLINTED_LUMIERE_CLUSTER);
        map.put(class_2246.field_27161, GBlocks.GLINTED_AMETHYST_CLUSTER);
    });
    private int growthTicks;

    public Sparkle(class_1299<? extends Sparkle> type, class_1937 world) {
        super(type, world);
        this.method_5941(class_7.field_18, 4.0f);
        this.method_5941(class_7.field_19, -1.0f);
        this.field_6207 = new class_5757((class_1308)this, 85, 10, 0.02f, 0.1f, true);
    }

    public float method_49476() {
        return 1.0f;
    }

    public Map<class_2248, class_2248> getClustersToGlinted() {
        return this.clustersToGlinted;
    }

    public float method_6144(class_2338 blockPos, class_4538 levelReader) {
        return 0.0f;
    }

    protected class_4095.class_5303<Sparkle> method_28306() {
        return class_4095.method_28311(MEMORY_TYPES, SENSOR_TYPES);
    }

    protected class_4095<?> method_18867(Dynamic<?> dynamic) {
        return SparkleAi.makeBrain((class_4095<Sparkle>)this.method_28306().method_28335(dynamic));
    }

    public class_4095<Sparkle> method_18868() {
        return super.method_18868();
    }

    protected void method_5958() {
        this.method_37908().method_16107().method_15396("sparkleBrain");
        this.method_18868().method_19542((class_3218)this.method_37908(), (class_1309)this);
        this.method_37908().method_16107().method_15407();
        this.method_37908().method_16107().method_15396("sparkleActivityUpdate");
        SparkleAi.updateActivity(this);
        this.method_37908().method_16107().method_15407();
        super.method_5958();
    }

    protected void method_18409() {
        super.method_18409();
        class_4209.method_19774((class_1309)this);
    }

    public void method_6091(class_243 vec3) {
        if (this.method_6034() && this.method_5799()) {
            this.method_5724(this.method_6029(), vec3);
            this.method_5784(class_1313.field_6308, this.method_18798());
            this.method_18799(this.method_18798().method_1021(0.9));
        } else {
            super.method_6091(vec3);
        }
    }

    public boolean method_6094() {
        return true;
    }

    public boolean method_5675() {
        return false;
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23719, 1.0).method_26868(class_5134.field_23716, 10.0);
    }

    public int method_5978() {
        return 1;
    }

    public int method_5986() {
        return 1;
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(CRYSTAL_TYPE, (Object)0);
    }

    public static boolean checkSparkleSpawnRules(class_1299<? extends class_1309> sparkle, class_1936 world, class_3730 reason, class_2338 pos, class_5819 random) {
        return world.method_8320(pos.method_10074()).method_26164(GBlockTags.SPARKLES_SPAWNABLE_ON);
    }

    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 data, @Nullable class_2487 tag) {
        CrystalType type = this.getRandomType();
        this.setVariant(type);
        return super.method_5943(world, difficulty, spawnReason, data, tag);
    }

    public void method_5749(class_2487 tag) {
        super.method_5749(tag);
        this.setVariant(CrystalType.byId(tag.method_10550("CrystalType")));
        this.setGrowthTicks(tag.method_10550("GrowthTicks"));
    }

    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
        tag.method_10569("CrystalType", this.getVariant().getId());
        tag.method_10569("GrowthTicks", this.getGrowthTicks());
    }

    public void setGrowthTicks(int growthTicks) {
        this.growthTicks = growthTicks;
    }

    public int getGrowthTicks() {
        return this.growthTicks;
    }

    protected class_1408 method_5965(class_1937 world) {
        return new SparklePathNavigation(this, world);
    }

    public void setVariant(CrystalType crystalType) {
        this.field_6011.method_12778(CRYSTAL_TYPE, (Object)crystalType.getId());
    }

    public CrystalType getVariant() {
        return CrystalType.byId((Integer)this.field_6011.method_12789(CRYSTAL_TYPE));
    }

    public boolean method_6481(class_1799 stack) {
        return stack.method_31573(GItemTags.SPARKLE_TEMPT_ITEMS);
    }

    @Nullable
    public class_1296 method_5613(class_3218 world, class_1296 mob) {
        Sparkle sparkleEntity = (Sparkle)GEntityTypes.SPARKLE.method_5883((class_1937)world);
        if (sparkleEntity != null) {
            sparkleEntity.setVariant(CrystalType.NONE);
        }
        return sparkleEntity;
    }

    public void method_6007() {
        super.method_6007();
        if (!this.method_37908().method_8608()) {
            if (this.getGrowthTicks() > 0) {
                this.setGrowthTicks(this.getGrowthTicks() - 1);
            }
            CrystalType type = this.getVariant();
            if (this.getGrowthTicks() == 0 && type == CrystalType.NONE) {
                this.setVariant(type);
            }
        }
    }

    public CrystalType getRandomType() {
        return this.field_5974.method_43056() ? CrystalType.ALLURITE : CrystalType.LUMIERE;
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        if (this.getVariant() != CrystalType.NONE && stack.method_7909() instanceof class_1810 && !this.method_6109()) {
            this.extractShard(stack);
            stack.method_7956(1, (class_1309)player, entity -> entity.method_20236(hand));
            this.method_32875(class_5712.field_28730, (class_1297)player);
            return class_1269.field_5812;
        }
        if (this.getVariant() == CrystalType.NONE && stack.method_31573(GItemTags.SPARKLE_TEMPT_ITEMS)) {
            if (!player.method_31549().field_7477) {
                stack.method_7934(1);
            }
            this.setGrowthTicks(this.getGrowthTicks() - class_3532.method_15395((class_5819)this.field_5974, (int)20, (int)40));
            return class_1269.field_5812;
        }
        return super.method_5992(player, hand);
    }

    public void extractShard(class_1799 stack) {
        this.spawnShard(stack);
        this.method_5783(class_3417.field_26951, 1.0f, 1.0f);
        this.setVariant(CrystalType.NONE);
        this.setGrowthTicks(REGROWTH_TICKS.method_35008(this.method_6051()));
    }

    private void spawnShard(class_1799 stack) {
        class_1792 item = class_1890.method_8225((class_1887)class_1893.field_9099, (class_1799)stack) > 0 ? this.getVariant().getSilktouchItem() : this.getVariant().getItem();
        int rolls = class_1890.method_8225((class_1887)class_1893.field_9130, (class_1799)stack) > 0 ? 1 + class_1890.method_8225((class_1887)class_1893.field_9130, (class_1799)stack) : 1;
        for (int i = 0; i < rolls; ++i) {
            this.method_5706((class_1935)item);
        }
    }

    public static enum CrystalType implements class_3542
    {
        NONE(0, "none", null, null),
        ALLURITE(1, "allurite", GItems.ALLURITE_SHARD, GBlocks.ALLURITE_CLUSTER.method_8389()),
        LUMIERE(2, "lumiere", GItems.LUMIERE_SHARD, GBlocks.LUMIERE_CLUSTER.method_8389());

        public static final IntFunction<CrystalType> BY_ID;
        private final int id;
        private final String name;
        private final class_1792 item;
        private final class_1792 silktouchItem;

        private CrystalType(int id, String name, class_1792 item, class_1792 silktouchItem) {
            this.id = id;
            this.name = name;
            this.item = item;
            this.silktouchItem = silktouchItem;
        }

        public int getId() {
            return this.id;
        }

        public static CrystalType byId(int i) {
            return BY_ID.apply(i);
        }

        public String getName() {
            return this.name;
        }

        public class_1792 getItem() {
            return this.item;
        }

        public class_1792 getSilktouchItem() {
            return this.silktouchItem;
        }

        public String method_15434() {
            return this.name;
        }

        static {
            BY_ID = class_7995.method_47914(CrystalType::getId, (Object[])CrystalType.values(), (class_7995.class_7996)class_7995.class_7996.field_41664);
        }
    }

    static class SparklePathNavigation
    extends class_5766 {
        public SparklePathNavigation(Sparkle sparkle, class_1937 level) {
            super((class_1308)sparkle, level);
        }

        public boolean method_48158(class_7 blockPathTypes) {
            return blockPathTypes != class_7.field_4 && super.method_48158(blockPathTypes);
        }

        protected class_13 method_6336(int i) {
            this.field_6678 = new SparkleNodeEvaluator(true);
            this.field_6678.method_15(true);
            return new class_13(this.field_6678, i);
        }
    }

    static class SparkleNodeEvaluator
    extends class_15 {
        public SparkleNodeEvaluator(boolean bl) {
            super(bl);
        }

        @Nullable
        public class_9 method_21() {
            return this.method_43415(new class_2338(class_3532.method_15357((double)this.field_33.method_5829().field_1323), class_3532.method_15357((double)this.field_33.method_5829().field_1322), class_3532.method_15357((double)this.field_33.method_5829().field_1321)));
        }
    }
}

